/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.krimp.gui;

import com.rapidminer.krimp.CodeTable;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.tools.Tools;
import javax.swing.table.AbstractTableModel;

public class STCodeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5490209607479134881L;
    private static final int COLUMN_SUPPORT = 0;
    private static final int COLUMN_CODE_LENGTH = 1;
    private final FrequentItemSet[] codingSet;
    private final double[] codeLength;
    private int nrOfColumns;

    public STCodeTableModel(CodeTable codeTable) {
        this.codingSet = codeTable.getItemSets().toArray(new FrequentItemSet[0]);
        this.codeLength = new double[this.codingSet.length];
        this.nrOfColumns = 0;
        int i = 0;
        for (FrequentItemSet itemSet : codeTable.getItemSets()) {
            this.nrOfColumns = Math.max(this.nrOfColumns, itemSet.getNumberOfItems());
            this.codeLength[i++] = codeTable.getCodeLengthRight(itemSet);
        }
        this.nrOfColumns += 2;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Support";
        }
        if (column == 1) {
            return "Standard Code Length";
        }
        return "Item";
    }

    @Override
    public int getRowCount() {
        return this.codingSet.length;
    }

    @Override
    public int getColumnCount() {
        return this.nrOfColumns;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.codingSet[rowIndex].getFrequency();
        }
        if (columnIndex == 1) {
            return Tools.formatNumber((double)this.codeLength[rowIndex]);
        }
        int actualIndex = columnIndex - 2;
        if (actualIndex < this.codingSet[rowIndex].getNumberOfItems()) {
            return this.codingSet[rowIndex].getItem(actualIndex).toString();
        }
        return "";
    }
}

