/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.krimp.gui;

import com.rapidminer.krimp.CodeTable;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.tools.Tools;
import javax.swing.table.AbstractTableModel;

public class CodeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 435436021732207040L;
    private static final int COLUMN_SUPPORT = 0;
    private static final int COLUMN_USAGE = 1;
    private static final int COLUMN_CODE_LENGTH_LEFT = 2;
    private static final int COLUMN_CODE_LENGTH_RIGHT = 3;
    private final FrequentItemSet[] codingSet;
    private final double[] codeLengthRight;
    private final double[] codeLengthLeft;
    private final int[] usages;
    private int nrOfColumns;

    public CodeTableModel(CodeTable codeTable) {
        this.codingSet = codeTable.getItemSets().toArray(new FrequentItemSet[0]);
        this.codeLengthLeft = new double[this.codingSet.length];
        this.codeLengthRight = new double[this.codingSet.length];
        this.usages = new int[this.codingSet.length];
        this.nrOfColumns = 0;
        int i = 0;
        for (FrequentItemSet itemSet : codeTable.getItemSets()) {
            this.nrOfColumns = Math.max(this.nrOfColumns, itemSet.getNumberOfItems());
            this.usages[i] = codeTable.getUsage(itemSet);
            this.codeLengthLeft[i] = codeTable.getCodeLengthLeft(itemSet);
            this.codeLengthRight[i++] = codeTable.getCodeLengthRight(itemSet);
        }
        this.nrOfColumns += 4;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Support";
        }
        if (column == 1) {
            return "Usage";
        }
        if (column == 2) {
            return "Standard Code Length";
        }
        if (column == 3) {
            return "Code Length";
        }
        return "Item " + (column - 3);
    }

    @Override
    public int getRowCount() {
        return this.codingSet.length;
    }

    @Override
    public int getColumnCount() {
        return this.nrOfColumns;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.codingSet[rowIndex].getFrequency();
        }
        if (columnIndex == 1) {
            return this.usages[rowIndex];
        }
        if (columnIndex == 2) {
            return this.codeLengthLeft[rowIndex];
        }
        if (columnIndex == 3) {
            return Tools.formatNumber((double)this.codeLengthRight[rowIndex]);
        }
        int actualIndex = columnIndex - 4;
        if (actualIndex < this.codingSet[rowIndex].getNumberOfItems()) {
            return this.codingSet[rowIndex].getItem(actualIndex).toString();
        }
        return "";
    }
}

