/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.krimp;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.krimp.CodeTable;
import com.rapidminer.krimp.Database;
import com.rapidminer.krimp.comparators.StandardCandidateComparator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class KRIMP
extends Operator {
    public static final String PARAMETER_PRUNE = "employ pruning";
    public static final String PARAMETER_MIN_SUPPORT = "min_support";
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final InputPort frequentSetsInput = this.getInputPorts().createPort("frequent sets", FrequentItemSets.class);
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort codedSetsOutput = (OutputPort)this.getOutputPorts().createPort("coding set");
    private final OutputPort freqSetsOutput = (OutputPort)this.getOutputPorts().createPort("frequent sets of the code table");

    public KRIMP(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition((Precondition)new ExampleSetPrecondition(this.exampleSetInput, 6, new String[0]));
        this.getTransformer().addGenerationRule(this.codedSetsOutput, CodeTable.class);
        this.getTransformer().addGenerationRule(this.freqSetsOutput, FrequentItemSets.class);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    public void doWork() throws OperatorException {
        boolean prune = this.getParameterAsBoolean(PARAMETER_PRUNE);
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData(ExampleSet.class);
        FrequentItemSets candidateSets = (FrequentItemSets)this.frequentSetsInput.getData(FrequentItemSets.class);
        double minSup = this.getParameterAsDouble(PARAMETER_MIN_SUPPORT);
        int minTotalSup = (int)Math.ceil(minSup * (double)exampleSet.size());
        Tools.onlyNominalAttributes((ExampleSet)exampleSet, (String)"StandardCodeTable");
        ExampleSet workingSet = this.preprocessExampleSet(exampleSet);
        Database database = new Database(workingSet);
        candidateSets.sortSets((Comparator)new StandardCandidateComparator());
        CodeTable actualCT = CodeTable.getStandardCodeTable(database);
        for (FrequentItemSet candidateSet : candidateSets) {
            CodeTable candCT;
            if (candidateSet.getNumberOfItems() <= 1 || !((candCT = actualCT.addToCodingSet(candidateSet, database)).getCompressedSize() < actualCT.getCompressedSize())) continue;
            if (prune) {
                actualCT = this.prune(candCT, actualCT, database);
                continue;
            }
            actualCT = candCT;
        }
        FrequentItemSets freqSetsOutp = new FrequentItemSets(database.getNumberOfTransactions());
        for (FrequentItemSet freqItemSet : actualCT.getItemSets()) {
            if (actualCT.getUsage(freqItemSet) <= 0 || freqItemSet.getFrequency() < minTotalSup) continue;
            freqSetsOutp.addFrequentSet(freqItemSet);
        }
        this.exampleSetOutput.deliver((IOObject)exampleSet);
        this.codedSetsOutput.deliver((IOObject)actualCT);
        this.freqSetsOutput.deliver((IOObject)freqSetsOutp);
    }

    private CodeTable prune(CodeTable newCT, CodeTable oldCT, Database db) {
        SortedSet<FrequentItemSet> pruneSet = this.getPruneSet(newCT, oldCT);
        while (!pruneSet.isEmpty()) {
            FrequentItemSet pruneCand = pruneSet.first();
            pruneSet.remove(pruneCand);
            CodeTable pruneCT = newCT.removeFromCodingSet(pruneCand);
            if (!(pruneCT.getCompressedSize() < newCT.getCompressedSize())) continue;
            pruneSet.addAll(this.getPruneSet(pruneCT, newCT));
            newCT = pruneCT;
        }
        return newCT;
    }

    private SortedSet<FrequentItemSet> getPruneSet(CodeTable newCT, CodeTable oldCT) {
        HashSet<FrequentItemSet> tempSet = new HashSet<FrequentItemSet>(newCT.getItemSets());
        tempSet.retainAll(oldCT.getItemSets());
        for (FrequentItemSet itemSet : new HashSet<FrequentItemSet>(tempSet)) {
            if (itemSet.getNumberOfItems() == 1) {
                tempSet.remove(itemSet);
                continue;
            }
            if (newCT.getUsage(itemSet) < oldCT.getUsage(itemSet)) continue;
            tempSet.remove(itemSet);
        }
        TreeSet<FrequentItemSet> pruneSet = new TreeSet<FrequentItemSet>(new PruneSetComparator(newCT));
        pruneSet.addAll(tempSet);
        return pruneSet;
    }

    private ExampleSet preprocessExampleSet(ExampleSet exampleSet) {
        ExampleSet workingSet = (ExampleSet)exampleSet.clone();
        int oldAttributeCount = workingSet.getAttributes().size();
        this.removeNonBooleanAttributes(workingSet);
        int newAttributeCount = workingSet.getAttributes().size();
        if (oldAttributeCount != newAttributeCount) {
            int removeCount = oldAttributeCount - newAttributeCount;
            String message = null;
            message = removeCount == 1 ? "Removed 1 non-binominal attribute, creation of a standard code table is only supported for the positive values of binominal attributes." : "Removed " + removeCount + " non-binominal attributes, creation of a standard code table is only supported for the positive values of binominal attributes.";
            this.logWarning(message);
        }
        return workingSet;
    }

    private void removeNonBooleanAttributes(ExampleSet exampleSet) {
        ArrayList<Attribute> deleteAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNominal() && attribute.getMapping().size() == 2) continue;
            deleteAttributes.add(attribute);
        }
        for (Attribute attribute : deleteAttributes) {
            exampleSet.getAttributes().remove(attribute);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_PRUNE, "Indicates if post-acceptance pruning should be deployed. This improves the compression rate by removal of less used frequent patterns from the code table when a new candidate item set is accepted. However, the computation time might slightly increase.", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MIN_SUPPORT, "The minimal support necessary in order to be a frequent item (set). Affects only the frequent sets output.", 0.0, 1.0, 0.95));
        return types;
    }

    private class PruneSetComparator
    implements Comparator<FrequentItemSet> {
        CodeTable candCT;

        public PruneSetComparator(CodeTable candCT) {
            this.candCT = candCT;
        }

        @Override
        public int compare(FrequentItemSet o1, FrequentItemSet o2) {
            return this.candCT.getUsage(o1) - this.candCT.getUsage(o2);
        }
    }
}

