package com.rapidminer.krimp.comparators;

import java.util.Arrays;
import java.util.Comparator;

import com.rapidminer.operator.learner.associations.FrequentItemSet;

/**
 * x1 < x2 <=> 1. |x1|>|x2| or 2. |x1|=|x2| & supp(x1)>supp(x2) or 3. |x1|=|x2|
 * & supp(x1)=supp(x2) & x1<lexi x2
 * 
 * @author hess
 * 
 */
public class StandardCoverComparator implements Comparator<FrequentItemSet> {

	@Override
	public int compare(FrequentItemSet x1, FrequentItemSet x2) {
		if (x1 == null && x2 == null)
			return 0;
		if (x1 == null)
			return 1;
		if (x2 == null)
			return -1;
		if (x1.getNumberOfItems() != x2.getNumberOfItems())
			return (int) Math.signum(x2.getNumberOfItems()
					- x1.getNumberOfItems());
		if (x1.getFrequency() != x2.getFrequency())
			return (int) Math.signum(x2.getFrequency() - x1.getFrequency());
		String[] x1Items = x1.getItemsAsString().split(", ");
		String[] x2Items = x2.getItemsAsString().split(", ");
		Arrays.sort(x1Items);
		Arrays.sort(x2Items);
		for (int i = 0; i < x1Items.length; i++) {
			if (x1Items[i].compareTo(x2Items[i]) != 0)
				return x1Items[i].compareTo(x2Items[i]);
		}
		return 0;
	}
}
