package com.rapidminer.example.table.struct.tree;

import java.util.Iterator;
import java.util.LinkedList;


/**
 * 
 * This class implements a simple iterator over nodes of a tree. The tree
 * is given by its root-node and the iterator will then traverse all nodes
 * following that root in a BFS manner.
 * 
 * @author Martin Had, Christian Bockermann &lt;chris@jwall.org&gt;
 *
 */
public class TreeIterator implements Iterator<KTreeNode> {

	private LinkedList<KTreeNode> treeStack;

	
	/**
	 * Create a new iterator which will iterate over all nodes of the
	 * tree given by the root node <code>root</code>.
	 * 
	 * @param root The root of the tree to iterate over.
	 */
	public TreeIterator(KTreeNode root) {
		treeStack = new LinkedList<KTreeNode>();
		treeStack.add( root );
	}

	
	/**
	 * @see java.util.Iterator#hasNext()
	 */
	public boolean hasNext() {
		return (!treeStack.isEmpty());
	}

	
	/**
	 * @see java.util.Iterator#next()
	 */
	public KTreeNode next() {
		//
		// simplification by using a linked list (chris@jwall.org)
		//
		KTreeNode tr = treeStack.removeLast();

		//ArrayList<KTreeNode> kids = tr.children();
		// so that we can efficiently use one List, we reverse them
		
		for (int i = tr.children().size() - 1; i >= 0; i--) 
			treeStack.add( tr.getChild( i ) ); //kids.get(i));

		return tr;
	}

	/**
	 * Not supported
	 */
	public void remove() {
		throw new UnsupportedOperationException();
	}

	public String toString() {
		return "TreeIterator";
	}
}