package hitters.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;

/**
 * Logservice.
 * 
 * @author Peter Fricke
 * 
 */
public class LogDatabase {

	private String filename;	
	private BufferedWriter out;	

	public LogDatabase( String filename ){
		this.filename = filename;
		this.openWrite();
	}


	private boolean openWrite(){
		boolean success = true;
		try{ 
			out = new BufferedWriter(new FileWriter(filename));			
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());
			success = false;
		}
		catch (java.io.IOException e) { success = false; };

		return success;
	}

	
	/** Close logfile */
	public void close(){	    
		try{
			out.close();
		}
		catch (java.io.IOException e) {  };	    
	}


	public void println(String s) {
		try{ 
			out.write( s + System.getProperty("line.separator") );
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());		    	
		}
		catch (java.io.IOException e) { };
	}

	
	public void print(String s) {
		try{ 
			out.write( s );
		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print(e.getMessage());		    	
		}
		catch (java.io.IOException e) { };
	}

}


