/**
 * @author Peter Fricke 
 */
package hitters.test;

import static org.junit.Assert.assertTrue;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import hitters.multi.Weights;

import org.junit.Before;
import org.junit.Test;

public class WeightsTest {

	String file = "resources/testcase/WeightTest/Freq.txt";
	String resultFile = "resources/testcase/WeightTest/Freq.res";
	double exp = 0.5;
	List<String> solution = load( resultFile );
	Weights w;
	
	
	@Before
	public void setUp() throws Exception {

		try{
			w = new Weights( "Freq.txt", exp );
		}catch(java.io.FileNotFoundException ex) { 
			System.out.println("Kann die Datei " +
					"resources/testcase/WeightTest/Freq.txt nicht finden.");
			System.out.print( ex.getMessage());
		}
	}	
	 		
	
	@Test
	public void testGetWeightPlain() {

		List<String> names = new ArrayList<String>();		
		String line;
		String[] parts;
		
		try{
			w = new Weights( "Freq.txt", 1.0 );
		}catch(java.io.FileNotFoundException ex) { }
		
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {				
				if( line.length() > 2 && ( ! line.startsWith("#") ) ){
					parts = line.split("\\s");
					names.add( parts[0]);			
				}
			}
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}		
	
		double d = 0;
		for( String call : names ){				
			System.out.println( call + "  " + w.getFreq(call) );
			d += w.getFreq(call);
		}
		
		System.out.println( d );
	}

	
	@Test
	public void testGetWeight() {

		List<String> names = new ArrayList<String>();
		List<Double> expWeight = new ArrayList<Double>();
		String line;
		String[] parts;
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {				
				if( line.length() > 2 && ( ! line.startsWith("#") ) ){
					parts = line.split("\\s");
					names.add( parts[0]);
					expWeight.add( w.getWeight( parts[0] ) );
				}
			}

		} catch( IOException e ) {
			throw new RuntimeException(e);
		}		
	
		double resWt, calcWt;
		for( String res : solution ){
			
			parts = res.split("\\s");
			resWt = Double.parseDouble(parts[1]);
			calcWt = w.getWeight(parts[0]);
			//System.out.println( parts[0] + "  " + calcWt + "  " + resWt );
			assertTrue(  Math.abs( calcWt - resWt ) < 1E-12 );
		}
		
	}

	
	
	
	
	
	@Test
	public void testGetWeightsSum() {

		String fixedCalls = "_llseek;accept;accept4;access;brk;clock_gettime;clone;close;dup;dup2;dup3;execve;fcntl;fcntl64;fork;fstat;fstat64;futex;getdents;getdents64;gettimeofday;inotify_init;inotify_init1;ioctl;lseek;lstat;lstat64;mmap2;mprotect;munmap;nanosleep;open;pipe;pipe2;poll;read;readlink;recv;recvmsg;rt_sigaction;select;send;sendfile;sendmsg;sendto;socket;stat;stat64;time;uname;unshare;vfork;write;writev";
		String[] fixed = fixedCalls.split( ";" );
		List<String> names = Arrays.asList( fixed );
		
		try{
			w = new Weights( "Freq.txt", 1.0 );
		}catch(java.io.FileNotFoundException ex) { }
		
		int i = 0;
		double d = 0;
		for( String call : names ){				
			System.out.println( call + "  " + w.getCount(call) + "  " + w.getFreq(call) );
			d += w.getFreq(call);
			i += w.getCount(call);
		}
		
		System.out.println( "Sum = " + i + "  " + d );
	}


	
	
	private List<String> load( String file ){

		List<String> list = new ArrayList<String>();
		String line;
		
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {							
				if(  ! line.startsWith("#") ) {
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		return list;
	}
	
}
