package hitters.test;

import static org.junit.Assert.assertTrue;
import hitters.multi.Element;
import hitters.multi.Exact;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.Parameter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.junit.Before;
import org.junit.Test;

/**
 * @author Peter Fricke
 * 
 */
public class ExactTest {

	// Pfad zu Testfaellen
	String dir = "resources/testcase/ExactTest/";

	Parameter myParams;
	MultiDatabase d;
	Exact myExact;
	byte[][] plength = {  };
	double phi;


	@Before
	public void setUp() throws Exception {

		myParams = new Parameter( 2 - plength.length, plength );		
		myExact = new Exact( myParams );						
	}



	@Test	
	public void testInsert() {

		d = new MultiDatabase( dir + "Exact1", myParams );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		for( Element e : data ) myExact.insert(e, 1, true);

		assertTrue( myExact.getN() == 15 );
		assertTrue( myExact.getTupelCount() == 10 );
		assertTrue( myExact.getMaxTupelCount() == 10 );

		for( Element e : data ) myExact.insert(e.clone(), 9, true);

		assertTrue( myExact.getN() == 150 );
		assertTrue( myExact.getTupelCount() == 10 );
		assertTrue( myExact.getMaxTupelCount() == 10 );
	}


	@Test	
	public void testOutputSet() {		

		for( int i = 1; i < 9; i++ ){			
			this.load( "Exact" + i );			
			this.validateCompletely( myExact, "Exact" + i, i );
		}
	}

	

	@Test
	//@Ignore
	public void testClean1D(){
				
//		HashMap<Element, MultiHitterInfo> res;
//		List<Map.Entry<Element, MultiStringElement>> dump;
//		
		Parameter p = new Parameter(1);
		String file = "1D/PA1D";

		for( int i = 1; i < 4 ; i++ ){			
			this.load( file + i, p );			
			this.validateCompletely( myExact, file + i, i );
		}
//				
//		int i = 3;
//
//		this.load( file + i, p );			
//		res = myExact.outputSet( phi, false );			
//		Map<Element, Integer> abs = myExact.dumpf();
//		Map<Element, Integer> disc = myExact.dumpF(phi);
//		
//		
//		for( Element e : abs.keySet() ){
//			System.out.println( e.toShortString() + " (" + abs.get(e) + ")" );
//		}
//		
//		System.out.println();
//		
//		for( Element e : disc.keySet() ){
//			System.out.println( e.toShortString() + " (" + disc.get(e) + ")" );
//		}
//		
//		System.out.println();
//				
//		for( Element e : res.keySet() )
//			System.out.println( e.toShortString() + " " + res.get(e).toShortString() );
	}
	
	

	@Test
	//@Ignore
	public void testClean3D(){
				
		HashMap<Element, MultiHitterInfo> res;
	//	List<Map.Entry<Element, MultiStringElement>> dump;
		
		Parameter p = new Parameter(3);
		String file = "3D/PA3D";

		for( int i = 1; i < 3 ; i++ ){			
			this.load( file + i, p );			
			this.validateCompletely( myExact, file + i, i );
		}
				
		int i = 2;

		this.load( file + i, p );			
		res = myExact.outputSet( phi, false );			
		Map<Element, Integer> abs = myExact.dumpf();
		Map<Element, Integer> disc = myExact.dumpF(phi);
		
		
		for( Element e : abs.keySet() ){
			System.out.println( e.toShortString() + " (" + abs.get(e) + ")" );
		}
		
		System.out.println();
		
		for( Element e : disc.keySet() ){
			System.out.println( e.toShortString() + " (" + disc.get(e) + ")" );
		}
		
		System.out.println();
				
		for( Element e : res.keySet() )
			System.out.println( e.toShortString() + " " + res.get(e).toShortString() );
	}

	
	
	@Test	
	//@Ignore
	public void testBuffers() {

		HashMap<Element, MultiHitterInfo> res;
		String[] eInt1 = new String[myParams.getDimI()];
		String[] eInt2 = eInt1.clone();
		String[] eInt3 = eInt2.clone();
		String[] eStr1 = { "/b", "/1"};
		String[] eStr2 = { "*", "/1"};
		String[] eStr3 = { "/b", "*"};
		Element e1 = Element.createElement( eStr1, eInt1, myParams );
		Element e2 = Element.createElement( eStr2, eInt2, myParams );
		Element e3 = Element.createElement( eStr3, eInt3, myParams );

		this.load( "ExactBufferFirst" );		
		res = myExact.outputSet( 1.0, false );
		res = myExact.outputSet( 0.9, true );
		res = myExact.outputSet( phi, true );
		this.validate( res, "ExactBufferFirst", 2);

		HashMap<Element, Integer> f = myExact.dumpf();
		HashMap<Element, Integer> F = myExact.dumpF(phi);

		assertTrue( f.get(e1) == 2);
		assertTrue( F.get(e1) == 2);

		assertTrue( f.get(e2) == 8);
		assertTrue( F.get(e2) == 2);

		assertTrue( f.get(e3) == 4);
		assertTrue( F.get(e3) == 4);

		myExact.insert(e1, 1, true);
		res = myExact.outputSet( phi, false );
		this.validate( res, "ExactBuffer", 99);
		res = myExact.outputSet( phi, false );
		res = myExact.outputSet( phi, true );
		res = myExact.outputSet( phi, true );
		this.validate( res, "ExactBuffer", 99);
		f = myExact.dumpf();
		F = myExact.dumpF(phi);
		assertTrue( f.get(e1) == 3);
		assertTrue( F.get(e1) == 3);

		assertTrue( f.get(e2) == 9);
		assertTrue( F.get(e2) == 3);

		assertTrue( f.get(e3) == 5);
		assertTrue( F.get(e3) == 5);		

		myExact.insert(e1, 2, true);
		res = myExact.outputSet( phi, true );
		this.validate( res, "ExactBuffer2", 99);
		res = myExact.outputSet( phi, false );
		res = myExact.outputSet( phi, true );
		res = myExact.outputSet( phi, true );
		this.validate( res, "ExactBuffer2", 99);
		f = myExact.dumpf();
		F = myExact.dumpF(phi);
		assertTrue( f.get(e1) == 5);
		assertTrue( F.get(e1) == 5);

		assertTrue( f.get(e2) == 11);
		assertTrue( F.get(e2) == null); // Nullen werden nicht expl. gesp.

		assertTrue( f.get(e3) == 7);
		assertTrue( F.get(e3) == 2);				

	}


	private void validate( HashMap<Element, MultiHitterInfo> res, String testcase, int nr ){

		String s = null;
		String message, pre;

		List<String> list = new ArrayList<String>();

		for( Element e : res.keySet() ){
			list.add( e.toShortString() + " " + res.get( e ).toShortString() );
		}								
		Collections.sort( list );

		List<String> solution = this.loadSolution( dir + testcase + ".res");		

		assertTrue("Problem: Testcase " + nr + " Groessen unterschiedl.", list.size() == solution.size() );	
		for( int i = 0; i < list.size(); i++ ){
			s = list.get(i);
			pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
			message = pre + " Berechnet: " + list.get(i);
			message += "\nGelesen: " + solution.get(i);
			assertTrue( message, s.trim().equals( solution.get(i).trim() ) );
		}		
	}
	
	
	private void validateCompletely( Exact exactAlgo, String testcase, int nr ){

		String s = null;
		String message, pre;
		
		Map<Element, Integer> abs = exactAlgo.dumpf();
		Map<Element, Integer> disc = exactAlgo.dumpF(phi);
		Map<Element, MultiHitterInfo> res = exactAlgo.outputSet(phi);		
		
		List<String> listf = new ArrayList<String>();
		List<String> listF = new ArrayList<String>();
		List<String> listOut = new ArrayList<String>();
		
		List<String> solutionf = this.loadf( dir + testcase + ".res");
		List<String> solutionF = this.loadF( dir + testcase + ".res");
		List<String> solutionOut = this.loadOut( dir + testcase + ".res");

		for( Element e : abs.keySet() ){
			listf.add( e.toShortString() + " (" + abs.get( e ) + ")" );
		}								
		
		for( Element e : disc.keySet() ){
			listF.add( e.toShortString() + " (" + disc.get( e ) + ")" );		
		}
		
		for( Element e : res.keySet() ){
			listOut.add( e.toShortString() + " " + res.get( e ).toShortString() );
		}								
		Collections.sort( listf );
		Collections.sort( listF );
		Collections.sort( listOut );		
	
		
		assertTrue("Problem: Testcase " + nr + " Groessen " +
				"unterschiedl.", listf.size() == solutionf.size() );	
		assertTrue("Problem: Testcase " + nr + " Groessen " +
				"unterschiedl.", listF.size() == solutionF.size() );	
		assertTrue("Problem: Testcase " + nr + " Groessen " +
				"unterschiedl.", listOut.size() == solutionOut.size() );	
						
		for( int i = 0; i < listf.size(); i++ ){
			s = listf.get(i);
			pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
			message = pre + " Berechnet fuer f: " + listf.get(i);
			message += "\nGelesen: " + solutionf.get(i);
			assertTrue( message, s.trim().equals( solutionf.get(i).trim() ) );
		}
		
		for( int i = 0; i < listF.size(); i++ ){
			s = listF.get(i);
			pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
			message = pre + " Berechnet fuer f: " + listF.get(i);
			message += "\nGelesen: " + solutionF.get(i);
			assertTrue( message, s.trim().equals( solutionF.get(i).trim() ) );
		}
		
		for( int i = 0; i < listOut.size(); i++ ){
			s = listOut.get(i);
			pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
			message = pre + " Berechnet fuer f: " + listOut.get(i);
			message += "\nGelesen: " + solutionOut.get(i);
			assertTrue( message, s.trim().equals( solutionOut.get(i).trim() ) );
		}		
	}
	
	
	private List<String> loadSolution( String file ){

		List<String> list = new ArrayList<String>();
		String line;

		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {				
				if( line.length() > 2 && ( ! line.startsWith("#") ) ){
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		Collections.sort( list );		

		return list;
	}

	
	private List<String> loadf( String file ){

		List<String> list = new ArrayList<String>();
		String line;

		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {				
				if( line.startsWith("# F") ) break;
				if( line.length() > 2 && ( ! line.startsWith("#") ) ){
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		Collections.sort( list );		

		return list;
	}

	
	private List<String> loadF( String file ){

		List<String> list = new ArrayList<String>();
		String line;
		boolean read = false;
		
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {				
				if( line.startsWith("# out") ) break;
				if( line.startsWith("# F") ) read = true;
				if( read && line.length() > 2 && ( ! line.startsWith("#") ) ){
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		Collections.sort( list );		

		return list;
	}
	
	
	private List<String> loadOut( String file ){

		List<String> list = new ArrayList<String>();
		String line;
		boolean read = false;
		
		try {
			BufferedReader in = new BufferedReader( new FileReader(file) );
			while( (line = in.readLine()) != null) {								
				if( line.startsWith("# out") ) read = true;
				if( read && line.length() > 2 && ( ! line.startsWith("#") ) ){
					list.add( line );						
				}
			}			
		} catch( IOException e ) {
			throw new RuntimeException(e);
		}

		Collections.sort( list );		

		return list;
	}

	
	private void load( String testcase ){
		load( testcase, myParams );
	}
	
	private void load( String testcase, Parameter p ){
		d = new MultiDatabase( dir + testcase, p );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		myExact = new Exact(p);
		for( Element e : data ) myExact.insert(e, 1, true);
		phi = d.getPhi();
	}

}
