package hitters.test;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import hitters.multi.AbstractComplexHHH;
import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.Exact;
import hitters.multi.MultiDatabase;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.SysParameter;

import org.junit.Before;
import org.junit.Test;

/**
 * @author Peter Fricke
 * 
 */
public class EvaluationTest {

	//	Testfall
	//	
	//	#$ 2 | 0
	//	# N, phi, Epsilon
	//	#% 12 | 0.35 | 0.1
	//	/1/1 | /1
	//	/1/1 | /2
	//	/1/1 | /3
	//	/1/2 | /1
	//	/1/2 | /2
	//	/1/2 | /3 
	//	/1/3 | /1
	//	/1/3 | /2 
	//	/1/3 | /3
	//	/1/4 | /1
	//	/1/4 | /2
	//	/1/4 | /3

	Parameter par;
	AbstractComplexHHH pa;
	//Element[] aSorted = new Element[9];
	List<Element> list = new ArrayList<Element>();
	List<Element> ogmList = new ArrayList<Element>();
	List<Element> bigList = new ArrayList<Element>();

	@Before
	public void setUp() throws Exception {

		byte[][] plength = { };		
		par = new Parameter( 2 - plength.length, plength );				
		pa = new PartAncHHH( 0, par );

		String[][] s = { {"/1/1", "/1"}, {"/1/1", "/2"},
				{"/1/1", "/3"}, {"/1/2", "/1"},
				{"/1/2", "/2"}, {"/1/2", "/3"}, 
				{"/1/3", "/1"}, {"/1/3", "/2"}, 
				{"/1/3", "/3"}, {"/1/4", "/1"}, 				
				{"/1/4", "/2"}, {"/1/4", "/3"},};

		for( String[] eInt : s )
			list.add( Element.createElement( eInt, null, par ) );			

		ogmList.add( Element.createElement( s[0], null, par ) );//0
		ogmList.add( Element.createElement( s[1], null, par ) );//1
		ogmList.add( Element.createElement( s[2], null, par ) );//2

		String[][] t = { {"*", "/1"}, {"/1", "/3"},
				{"/1", "*"}, {"*", "*"} };
		ogmList.add( Element.createElement( t[0], null, par ) );//3
		ogmList.add( Element.createElement( t[1], null, par ) );//4
		ogmList.add( Element.createElement( t[2], null, par ) );//5
		ogmList.add( Element.createElement( t[3], null, par ) );//6

		// BigList:
		//		#$ 2 | 0
		//		# N, phi, Epsilon
		//		#% 12 | 0.35 | 0.1
		//		/1/1 | /1
		//		/1/1 | /2
		//		/1/1 | /3
		//		/1/2 | /1
		//		/1/2 | /2
		//		/1/2 | /3 
		//		/1/3 | /1
		//		/1/3 | /2 


		// Fuer grosse Liste: Blaetter... 
		for( int i = 0; i < 8; i++ )
			bigList.add( Element.createElement( s[i], null, par ) );			

		// ...und Praefixe
		String[][] u = { {"/1", "/3"}, {"/1/2", "*"}, 	//8, 9
				{"/1/1", "*"}, {"/1", "/2"},		//10,11
				{"/1", "/1"}, {"/1/3", "*"},		//12,13
				{"*", "/3"}, {"/1", "*"},			//14,15
				{"*", "/2"}, {"*", "/1"},			//16,17
				{"*", "*"} };						//18
		for( String[] eInt : u )
			bigList.add( Element.createElement( eInt, null, par ) );			


	}

	@Test
	public void testJaccardAndDice() {

		HashSet<Element> approx = new HashSet<Element>();
		HashSet<Element> exact = new HashSet<Element>();

		// Disjunkt
		this.fill( approx, 0, 8 );
		this.fill( exact, 8, 11 );
		assertTrue( Math.abs( Evaluation.jaccard(approx, exact) - 0 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dice(approx, exact) - 0 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.precision(approx, exact) - 0 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.recall(approx, exact) - 0 ) < 1E-12 );


		// Gleich
		this.fill( approx, 0, 12 );
		this.fill( exact, 0, 12 );
		assertTrue( Math.abs( Evaluation.jaccard(approx, exact) - 1 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dice(approx, exact) - 1 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.precision(approx, exact) - 1 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.recall(approx, exact) - 1 ) < 1E-12 );


		// Eine leer
		this.fill( approx, 0, 0 );
		this.fill( exact, 7, 11 );
		assertTrue( Math.abs( Evaluation.jaccard(approx, exact) - 0 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dice(approx, exact) - 0 ) < 1E-12 );		
		assertTrue( Math.abs( Evaluation.precision(approx, exact) - 0) < 1E-12 );
		assertTrue( Math.abs( Evaluation.recall(approx, exact) - 0 ) < 1E-12 );


		// Eins gemeinsam
		this.fill( approx, 0, 8 );  // 8
		this.fill( exact, 7, 12 ); // 5
		assertTrue( Math.abs( Evaluation.jaccard(approx, exact) - 1.0/12 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dice(approx, exact) - 2.0/13 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.precision(approx, exact) - 1.0/8 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.recall(approx, exact) - 1.0/5 ) < 1E-12 );


		// Vier gemeinsam
		this.fill( approx, 5, 12 ); // 7
		this.fill( exact, 1, 9 );  // 8
		assertTrue( Math.abs( Evaluation.jaccard(approx, exact) - 4.0/11 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dice(approx, exact) - 8.0/15 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.precision(approx, exact) - 4.0/7 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.recall(approx, exact) - 4.0/8 ) < 1E-12 );


		// Neun gemeinsam
		this.fill( approx, 0, 11 ); // 11
		this.fill( exact, 2, 12 ); // 10
		assertTrue( Math.abs( Evaluation.jaccard(approx, exact) - 9.0/12 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dice(approx, exact) - 18.0/21 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.precision(approx, exact) - 9.0/11 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.recall(approx, exact) - 9.0/10 ) < 1E-12 );


		// Zehn gemeinsam, Teilmenge
		this.fill( approx, 0, 12 ); // 12
		this.fill( exact, 1, 11 ); // 10
		assertTrue( Math.abs( Evaluation.jaccard(approx, exact) - 10.0/12 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dice(approx, exact) - 20.0/22 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.precision(approx, exact) - 10.0/12 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.recall(approx, exact) - 10.0/10 ) < 1E-12 );		
	}


	@Test
	public void testOgmGanesan() {

		HashSet<Element> approx = new HashSet<Element>();
		HashSet<Element> exact = new HashSet<Element>();

		// Ein Element
		this.clear( approx, exact );		
		approx.add( ogmList.get( 0 ).clone() );
		exact.add( ogmList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 2.0/3 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( ogmList.get( 0 ).clone() );
		exact.add( ogmList.get( 0 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 1.0 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( ogmList.get( 0 ).clone() );
		exact.add( ogmList.get( 2 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 2.0/3 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( ogmList.get( 0 ).clone() );
		exact.add( ogmList.get( 3 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 2.0/3 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( ogmList.get( 0 ).clone() );
		exact.add( ogmList.get( 4 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 5.0/12 ) < 1E-12 );

		this.clear( approx, exact );
		exact.add( ogmList.get( 6 ).clone() );
		approx.add( ogmList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 1.0/2 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( ogmList.get( 0 ).clone() );
		approx.add( ogmList.get( 4 ).clone() );
		exact.add( ogmList.get( 3 ).clone() );
		exact.add( ogmList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 17.0/24.0 ) < 1E-12 );
		
		this.clear( approx, exact );
		approx.add( bigList.get( 1 ).clone() );
		approx.add( bigList.get( 8 ).clone() );		
		approx.add( bigList.get( 17 ).clone() );		
		exact.add( bigList.get( 2 ).clone() );
		exact.add( bigList.get( 6 ).clone() );
		exact.add( bigList.get( 9 ).clone() );

		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 25.0/36.0 ) < 1E-12 );

	}

	
	@Test
	public void testOgmCormode() {

		HashSet<Element> approx = new HashSet<Element>();
		HashSet<Element> exact = new HashSet<Element>();

		// Ein Element
		this.clear( approx, exact );		
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - (-1) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 0 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - 1 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 2 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - (-1) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 3 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - (-1) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 4 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - (-3) ) < 1E-12 );

		this.clear( approx, exact );
		exact.add( bigList.get( 6 ).clone() );
		approx.add( bigList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - (-3) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		approx.add( bigList.get( 4 ).clone() );
		exact.add( bigList.get( 3 ).clone() );
		exact.add( bigList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - (-3) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 1 ).clone() );
		approx.add( bigList.get( 8 ).clone() );		
		approx.add( bigList.get( 17 ).clone() );		
		exact.add( bigList.get( 2 ).clone() );
		exact.add( bigList.get( 6 ).clone() );
		exact.add( bigList.get( 9 ).clone() );

		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - (-4) ) < 1E-12 );

	}

	@Test
	public void testBgm() {

		HashSet<Element> approx = new HashSet<Element>();
		HashSet<Element> exact = new HashSet<Element>();

		// Ein Element
		this.clear( approx, exact );		
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm(approx, exact) - (-3) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 0 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm(approx, exact) - 1 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 2 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm(approx, exact) - (-3) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 4 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm(approx, exact) - (-7) ) < 1E-12 );

		this.clear( approx, exact );
		exact.add( bigList.get( 6 ).clone() );
		approx.add( bigList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm(approx, exact) - (-7) ) < 1E-12 );

		//Geaendert!
		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		approx.add( bigList.get( 9 ).clone() );
		exact.add( bigList.get( 3 ).clone() );
		exact.add( bigList.get( 16 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm(approx, exact) - (-6) ) < 1E-12 );
		
		this.clear( approx, exact );
		approx.add( bigList.get( 1 ).clone() );
		approx.add( bigList.get( 8 ).clone() );		
		approx.add( bigList.get( 17 ).clone() );		
		exact.add( bigList.get( 2 ).clone() );
		exact.add( bigList.get( 6 ).clone() );
		exact.add( bigList.get( 9 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm(approx, exact) - (-9) ) < 1E-12 );

	}

	@Test
	public void testBgm2() {

		HashSet<Element> approx = new HashSet<Element>();
		HashSet<Element> exact = new HashSet<Element>();

		// Ein Element
		this.clear( approx, exact );		
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 1 ).clone() ); 
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - (2.0/3) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 0 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - 1 ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 2 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - (2.0/3) ) < 1E-12 );

		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		exact.add( bigList.get( 4 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - (1.0/3) ) < 1E-12 );

		this.clear( approx, exact );
		exact.add( bigList.get( 6 ).clone() );
		approx.add( bigList.get( 1 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - (1.0/3) ) < 1E-12 );

		//Geaendert!
		this.clear( approx, exact );
		approx.add( bigList.get( 0 ).clone() );
		approx.add( bigList.get( 9 ).clone() );
		exact.add( bigList.get( 3 ).clone() );
		exact.add( bigList.get( 16 ).clone() );
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - (14.0/24) ) < 1E-12 );
		
		this.clear( approx, exact );
		approx.add( bigList.get( 1 ).clone() );
		approx.add( bigList.get( 8 ).clone() );		
		approx.add( bigList.get( 17 ).clone() );		
		exact.add( bigList.get( 2 ).clone() );
		exact.add( bigList.get( 6 ).clone() );
		exact.add( bigList.get( 9 ).clone() );		
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - (25.0/36) ) < 1E-12 );
	}

	
	@Test
	public void testbgm2HHH() {

		String dir = "resources/testcase/Evaluation/";
		HashSet<Element> approx = new HashSet<Element>();
		HashSet<Element> exact = new HashSet<Element>();
		Set<Element> tmp1, tmp2;
		Parameter myParams = new Parameter( 2 );
		Element e;
		String[][] s = { {"*", "/2"}, {"*", "*"}, {"/2", "/2"},
				{"/2", "*"} };
				
		// Siehe Eva7.graphml
		tmp1 = hittersPA( dir + "Eva7" );
		tmp2 = hittersExact( dir + "Eva7" );
		for( Element el : tmp1 ) approx.add(el);
		for( Element el : tmp2 ) exact.add(el);
		
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - 1.0 ) < 1E-12 );
		
		e = Element.createElement( s[0], null, myParams );
		approx.add(e);
		e = Element.createElement( s[1], null, myParams );
		exact.add(e);
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - 3.0/4 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.bgm2(exact, approx) - 3.0/4 ) < 1E-12 );		
		
		e = Element.createElement( s[2], null, myParams );
		approx.add(e);
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - 7.0/10 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.bgm2(exact, approx) - 7.0/10 ) < 1E-12 );		

		e = Element.createElement( s[3], null, myParams );
		exact.add(e);
		assertTrue( Math.abs( Evaluation.bgm2(approx, exact) - 9.0/12 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.bgm2(exact, approx) - 9.0/12 ) < 1E-12 );		
	
	}	
	
	@Test
	public void testOgmHHH() {

		String dir = "resources/testcase/Evaluation/";
		Set<Element> approx;
		Set<Element> exact;
 
		// Siehe Eva1.graphml
		approx = hittersPA( dir + "Eva1" );
		exact = hittersExact( dir + "Eva1" );
		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 1.0 ) < 1E-12 );

		
		this.clear( approx, exact );		
		approx = hittersPA( dir + "Eva1" );
		exact = hittersExact( dir + "Eva1" );
		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - 1.0 ) < 1E-12 );

		System.out.println(Evaluation.evaluate(approx, exact));
		
	}

	
	@Test
	public void testDsmHHH() {

		String dir = "resources/testcase/Evaluation/";
		Map<Element, Integer> approxDs;
		Map<Element, Integer> exactDs;
		Parameter myParams = new Parameter( 2 );
		Element e;
		String[][] s = { {"/2", "/2"}, {"*", "/2"}, {"/2/2", "*"},
				{"*", "/1"} };
		
		// Siehe Eva7.graphml
		approxDs = hittersPADataStruct( dir + "Eva7" );
		exactDs = hittersExactDataStruct( dir + "Eva7" );		
		assertTrue( Math.abs( Evaluation.dsm(approxDs, approxDs) - 1.0 ) < 1E-12 );		
		assertTrue( Math.abs( Evaluation.dsm(exactDs, exactDs) - 1.0 ) < 1E-12 );		
		assertTrue( Math.abs( Evaluation.dsm(approxDs, exactDs) - 1.0/3 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dsm(exactDs, approxDs) - 1.0/3 ) < 1E-12 );		
		
		e = Element.createElement( s[0], null, myParams );
		approxDs.put(e, 3);
		e = Element.createElement( s[1], null, myParams );
		approxDs.put(e, 2);
		assertTrue( Math.abs( Evaluation.dsm(approxDs, exactDs) - 25.0/54 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dsm(exactDs, approxDs) - 25.0/54 ) < 1E-12 );		
		
		e = Element.createElement( s[2], null, myParams );
		approxDs.put(e, 3);
		assertTrue( Math.abs( Evaluation.dsm(approxDs, exactDs) - 119.0/270 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dsm(exactDs, approxDs) - 119.0/270 ) < 1E-12 );		
		
		e = Element.createElement( s[3], null, myParams );
		approxDs.put(e, 5);
		exactDs.put(e, 2);
		assertTrue( Math.abs( Evaluation.dsm(approxDs, exactDs) - 953.0/1890 ) < 1E-12 );
		assertTrue( Math.abs( Evaluation.dsm(exactDs, approxDs) - 953.0/1890 ) < 1E-12 );		
		
	}
	


	@Test
	public void testDA() {
		
		HashSet<Element> approx = new HashSet<Element>();
		HashSet<Element> exact = new HashSet<Element>();
		HashSet<Element> third = new HashSet<Element>();
		
		String[][] u = { 				
				{"/FILESYS/read"},
				{"/FILESYS/open/WR_ONLY"},
				{"/INFO/gettimeofday"},				
				{"/FILESYS/open"},
				{"/PROCMEM/clone"},
				{"/FILESYS"},				
				{"/FILESYS/open"},
				{"/PROCMEM/clone"}				
		};						

		byte[][] plength = { };		
		par = new Parameter( 1 - plength.length, plength );				
		//pa = new PartAncHHH( 0, par );

		
		approx.add( Element.createElement( u[0], null, par ) );
		approx.add( Element.createElement( u[1], null, par ) );
		approx.add( Element.createElement( u[2], null, par ) );
		
		exact.add( Element.createElement( u[3], null, par ) );
		exact.add( Element.createElement( u[4], null, par ) );
		
		third.add( Element.createElement( u[5], null, par ) );
		third.add( Element.createElement( u[6], null, par ) );
		third.add( Element.createElement( u[7], null, par ) );
		
		System.out.println( "C1 = " + approx + "  \n\n C2 = " + exact + "\n\n C3 = " + third );
		
//		assertTrue( Math.abs( Evaluation.ogmGanesan(approx, exact) - 1.0 ) < 1E-12 );
//
//		
//		this.clear( approx, exact );		
//		approx = hittersPA( dir + "Eva1" );
//		exact = hittersExact( dir + "Eva1" );
//		assertTrue( Math.abs( Evaluation.ogmCormode(approx, exact) - 1.0 ) < 1E-12 );

		System.out.println(Evaluation.evaluate(approx, exact)+"\n\n");
		System.out.println(Evaluation.evaluate(third, exact)+"\n\n");		
		//System.out.println(Evaluation.evaluate(exact, third));
	}
	
	
	private void clear(Set<Element> approx, Set<Element> exact) {
		approx.clear();
		exact.clear();
	}

	
	private void fill( Set<Element> set, int lo, int hi ){

		if( lo < 0 || hi > list.size() ) 
			throw new RuntimeException( "Unpassende Schranken." );

		set.clear();

		for( int i = lo; i < hi; i++ )
			set.add( list.get( i ).clone() );
	}

	
	private Set<Element> hittersPA( String testcase ){

		Parameter myParams = new Parameter( 2 );
		MultiDatabase d = new MultiDatabase( testcase, myParams );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		d.closeRead();
		double phi = d.getPhi();

		PartAncHHH hitterAlgo = new PartAncHHH( d.getEpsilon(), myParams );
		
		for( Element e : data ) hitterAlgo.insert(e, 1);
		
		return hitterAlgo.outputSet( phi ).keySet();
	}
	
	
	private Set<Element> hittersExact( String testcase ){

		Parameter myParams = new Parameter( 2 );
		MultiDatabase d = new MultiDatabase( testcase, myParams );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		d.closeRead();
		double phi = d.getPhi();

		Exact hitterAlgo = new Exact( myParams );
		
		for( Element e : data ) hitterAlgo.insert(e, 1);
		
		return hitterAlgo.outputSet( phi ).keySet();
	}

	
	private Map<Element, Integer> hittersPADataStruct( String testcase ){

		Parameter myParams = new Parameter( 2 );
		MultiDatabase d = new MultiDatabase( testcase, myParams );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		d.closeRead();		

		PartAncHHH hitterAlgo = new PartAncHHH( d.getEpsilon(), myParams );
		for( Element e : data ) hitterAlgo.insert(e, 1);

		return hitterAlgo.dumpf();
	}

	
	private Map<Element, Integer> hittersExactDataStruct( String testcase ){

		Parameter myParams = new Parameter( 2 );
		MultiDatabase d = new MultiDatabase( testcase, myParams );
		d.openRead(); 
		Vector<Element> data = d.readElements();
		d.closeRead();

		Exact hitterAlgo = new Exact( myParams );		
		for( Element e : data ) hitterAlgo.insert(e, 1);
		
		return hitterAlgo.dumpf();
	}

}
