/**
 * @author Peter Fricke 
 */

package hitters.multi;

import hitters.tools.Utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


public class Weights {

	String filename;	
	HashMap<String, Integer> countMap = new HashMap<String, Integer>();
	HashMap<String, Double> expMap = new HashMap<String, Double>(); 
	int sum = 0;
	
	public Weights( String file, double exp ) throws java.io.FileNotFoundException{
		
		// Locate file
		Reader reader = null;		
		InputStream str = null;
		String[] places = Utils.resourceLocationsJar();
		for( String place : places ){
			str = Weights.class.getResourceAsStream( place + file );
			if( str != null ){
				reader = new InputStreamReader( str );
				break;
			}
		}
		
		if( str == null ){
			URL url = Weights.class.getClassLoader().getResource(".");			
			String p = url.getPath();
			String[] otherPlaces = Utils.resourceLocationsFiles();			
			for( String place : otherPlaces ){
				try{ 
					reader = new FileReader( p + place + file );
				}catch(Exception e){}// System.out.println(e); }			
				if( reader != null ){				
					break;
				}
			}		
		}
		
		
		this.filename  = file;

		List<Integer> counts = new ArrayList<Integer>();
		List<String> names = new ArrayList<String>();
		double[] weightsTmp;
		String line;
		String[] parts;
		int n = 0;
		double expSum = 0;
	
		try {
			BufferedReader in = new BufferedReader( reader );
			while( (line = in.readLine()) != null) {				
				if( line.length() > 2 && ( ! line.startsWith("#") ) ){
					parts = line.split("\\s");
					names.add( parts[0]);
					counts.add( Integer.parseInt( parts[1] ) );
				}
			}
			in.close();

		} catch( IOException e ) {
			throw new RuntimeException(e);
		}		
		
		// Summe aller Haeufigkeiten aller Calls ist n
		// bei implizitem Gewicht 1
		for( Integer c : counts ){
			n += c;
		}
		sum = n;
		
		weightsTmp = new double[counts.size()];
		
		for( int i = 0; i < counts.size(); i++ ){
			
			// Gewichte sind in loser Analogie zu TFIDF
			// fuer seltene Calls hoeher als fuer haeufige,
			// die genaue Gewichtung wird durch exp aus [0,1]
			// festgelegt.
			// Weiter unten werden die so berechneten Gewichte 
			// noch skaliert, so dass die Summe aller Gewichte 
			// wie zuvor n ergibt.
			weightsTmp[i] = Math.pow( ( n / (double)counts.get(i) ), exp );
			expSum += weightsTmp[i] * counts.get(i);			
		}
		
		for( int i = 0; i < counts.size(); i++ ){
			
			// Haeufigkeiten
			countMap.put( names.get(i), counts.get(i) );
			
			// Gewichte, skaliert, so dass Summe = n
			expMap.put( names.get(i), (weightsTmp[i] * ( n /expSum )) );			
		}

	}
	
	
	public double getWeight( String call ){			
		return expMap.get( call );
	}
	
	
	public double getFreq( String call ){			
		//System.out.println( "GET" + call );
		if( countMap.get( call ) == null ) return 0;
		else return countMap.get( call ) /(double) sum;
	}
	
	
	public int getCount( String call ){			
		if( countMap.get( call ) == null ) return 0;
		else return countMap.get( call );
	}
}
