package hitters.multi;

/**
 * @author Peter Fricke
 * 
 */
public class SysElement extends Element {


	public SysElement( final String[] eStr, final int[] eInt,
			final SysParameter myParams ){ 				 					

		super( eStr, eInt, myParams );		
	}		

	
//	public SysElement( final String line, final SysParameter myParams ){ 				 					
//		super( myParams );
//		
//		String[] comps = line.split("|");
//
//		
//		// Schritt zwei: Zahlen interpretieren
//			switch( getPar().dimContents( i + myParams.getDimS() ) ){
//
//			case CALL: 
//
//				myS = myS + getPar().getTaxonomy().getPathlabel( code ); 
//
//				break;
//
//			case SEQUENCE:							
//				
//				for( int c : code ){
//					part = getPar().getTaxonomy().flat2call( c );
//					if( part != null ) seq = seq + "/" + part;
//				}
//				if( seq.length() > 0 ) myS = myS + seq;
//				else myS = myS + "*";
//				
//				break;
//
//			case RETURN:
//
//				switch( code[1] ){
//				case 0: myS = myS + "*"; break;
//				case 1: myS = myS + "/NO_ERROR"; break;
//				case 2: myS = myS + "/ERROR"; break;
//				}
//
//				break;
//
//			default: throw new RuntimeException("default SysElement");
//			}
//
//			if( i < eInt.length -1 ) myS = myS + " (i) | ";
//			else myS = myS + " (i)";
//		}		
//
//		
//	}		

	

	public String toString(){		

		int res;
		int[] code;
		String myS = "";
		String part;
		String seq = "";
		

		// Strings einfach hinschreiben
		for( int i = 0; i < eStr.length; i++ ){
			myS = myS + eStr[i];
			if( i < myParams.getDim() -1 ) myS = myS + " (s) | ";
			else myS = myS + " (s)";
		}		

		// Ints decodieren
		for( int i = 0; i < eInt.length; i++ ){

			code = new int[myParams.getMaskLength(i)];			

			// Schritt eins: Bits ebenenweise in Zahlen verwandeln
			for( int j = 1; j < myParams.getMaskLength(i); j++ ){

				res = eInt[i] & 
				myParams.getMask(i,j) & ~ myParams.getMask(i, j-1); 

				res = res >>> ( 32 - myParams.getPlength(i,j) );				
				code[j] = res;				
			}

			
			// Schritt zwei: Zahlen interpretieren
			switch( getPar().dimContents( i + myParams.getDimS() ) ){

			case CALL: 

				myS = myS + getPar().getTaxonomy().getPathlabel( code ); 

				break;

			case SEQUENCE:							
				
				for( int c : code ){
					part = getPar().getTaxonomy().flat2call( c );
					if( part != null ) seq = seq + "/" + part;
				}
				if( seq.length() > 0 ) myS = myS + seq;
				else myS = myS + "*";
				
				break;

			case RETURN:

				switch( code[1] ){
				case 0: myS = myS + "*"; break;
				case 1: myS = myS + "/NO_ERROR"; break;
				case 2: myS = myS + "/ERROR"; break;
				}

				break;

			default: throw new RuntimeException("default SysElement");
			}

			if( i < eInt.length -1 ) myS = myS + " (i) | ";
			else myS = myS + " (i)";
		}		

		return "( " + myS + " )";
	}

	
	public String toShortString(){		

		int res;
		int[] code;
		String myS = "";
		String part;
		String seq = "";
		

		// Strings einfach hinschreiben
		for( int i = 0; i < eStr.length; i++ ){
			myS = myS + eStr[i];
			if( i < myParams.getDim() -1 ) myS = myS + " | ";			
		}		

		// Ints decodieren
		for( int i = 0; i < eInt.length; i++ ){

			code = new int[myParams.getMaskLength(i)];			

			// Schritt eins: Bits ebenenweise in Zahlen verwandeln
			for( int j = 1; j < myParams.getMaskLength(i); j++ ){

				res = eInt[i] & 
				myParams.getMask(i,j) & ~ myParams.getMask(i, j-1); 

				res = res >>> ( 32 - myParams.getPlength(i,j) );				
				code[j] = res;				
			}

			
			// Schritt zwei: Zahlen interpretieren
			switch( getPar().dimContents( i + myParams.getDimS() ) ){

			case CALL: 

				myS = myS + getPar().getTaxonomy().getPathlabel( code ); 

				break;

			case SEQUENCE:							
				
				for( int c : code ){
					part = getPar().getTaxonomy().flat2call( c );
					if( part != null ) seq = seq + "/" + part;
				}
				if( seq.length() > 0 ) myS = myS + seq;
				else myS = myS + "*";
				
				break;

			case RETURN:

				switch( code[1] ){
				case 0: myS = myS + "*"; break;
				case 1: myS = myS + "/NO_ERROR"; break;
				case 2: myS = myS + "/ERROR"; break;
				}

				break;

			default: throw new RuntimeException("default SysElement");
			}

			if( i < eInt.length -1 ) myS = myS + " | ";			
		}		

		return myS;
	}

	
	
	public SysElement clone(){
		return new SysElement( eStr, eInt, getPar() );
	}
	
	private SysParameter getPar(){ return (SysParameter) myParams; }


}
