package hitters.multi;

import java.util.HashSet;

/**
 * @author Peter Fricke
 * 
 */
public class OLD_FullAncHHH extends OLD_AbstractComplexHHH {


	public OLD_FullAncHHH( double epsilon, Parameter p ){	
		super( epsilon, p );
	}



	@Override
	protected void specializedInsert(Element e, int count, int delta) {

		Element p;

		if( delta < 0 ) delta = bcurrent - 1;

		for( int dim = 0; dim < par.getDim(); dim++ ){
			p = e.clone();
			if( p.turnIntoParent( dim ) ){ 
				insertWork( p, 0, false, false  );
				delta = Math.min( delta, this.trieGet( p ).m );
			}
		}

		MultiStringElement m = new MultiStringElement( count, delta, delta );				
		this.triePut( e, m );					
	}


	/*
	 * Gibt fuer kinderlose Knoten <code>true</code> zurueck.
	 */
	@Override
	protected boolean checkChildren( Element e, 
			HashSet<Element> currentParentSet ){ 

		boolean ok;
		ok = ! currentParentSet.contains( e );

		return ok; 
	}

	/*
	 * Fuegt die Eltern des uebergebenen Knotens,
	 * sofern sie existieren, in die uebergebene Elternmenge ein.
	 */
	@Override
	protected void updateNextParentSet( Element e, 
			HashSet<Element> nextParentSet ){ 

		Element p;

		for( int i = 0; i < par.getDim(); i++ ){
			p = e.clone();
			if( p.turnIntoParent( i ) )
				nextParentSet.add( p );	
		}		
	}

}
