/**
 * 
 */
package hitters.multi;


/**
 * @author Peter Fricke
 *  
 * 	Nutzlast eines Knotens in der Halbordnung.
 * 
 * 	Halbordnung wird gespeichert per HashMap, Schlssel ist das 
 * 	multidimensionale Prfix (Element), ber das auch die
 * 	Navigation stattfindet, Wert ist das MultiStringElement.
 * 
 */
public class MultiStringElement implements Comparable<MultiStringElement> {

	public int g = 0, m = 0, delta = 0;

	public MultiStringElement( int g, int m, int delta ){
		this.g 	   = g;
		this.m     = m;
		this.delta = delta;
	}

	public void setTo( int g, int m, int delta ){
		this.g 	   = g;
		this.m     = m;
		this.delta = delta;
	}

	@Override
	public String toString() {
		String s = " ( g = " + g + ", m = " + m + ", delta = " + delta + " ) ";		
		//s = s + System.getProperty("line.separator");
		return s;
	}

	public boolean equals( Object o){
		if( ! (o instanceof MultiStringElement) ) return false;
		MultiStringElement mse = (MultiStringElement) o;
		return( mse.g == g && mse.m == m && mse.delta == delta );
	}

	public int compareTo(MultiStringElement value) {
		int erg = g - value.g;
		if( erg != 0 ) return erg; else erg = m     - value.m;
		if( erg != 0 ) return erg; else erg = delta - value.delta;
		return erg;
	}

	public String toShortString() {
		String s = "(" + g + ", " + m + ", " + delta + ")";		
		return s;
	}

}
