package hitters.multi;

import hitters.tools.LogService;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import com.google.common.collect.HashMultiset;

public class ControlRoom {
	
	static String DELIMITER = "\n\n************************************\n\n";		
	
	/////////////////////////////////////////////////////////////////
	// 
	// 					Anwendungsarten ( modes )
	//
	/////////////////////////////////////////////////////////////////

	static final int SPEED_MAXSPACE = 1;// Laufzeit und max Speicher bei versch. Dim und Epsilon
	static final int SPACE_DYN = 2; 	// Speicherbedarf im Zeitverlauf
	static final int SPEED_BUF = 3;		// Laufzeit Puffern
	static final int SPEED_CAP = 4;		// Laufzeit Beschr. Hierarchietiefe
	static final int ALL_CAP   = 5;
	static final int ALL   = 6;
	static final int EVALUATION = 7;
	static final int TMP   = 8;
	static final int ALL_CAP_NEU   = 9;
	
	static int mode;						
	static AlgoType algo;		
	
	// /dev/shm/log/rb4 F 0.00005 0.01 1000
	//J:/log/rb4 F 0.00005 0.01 2
	//D:/wsirae/IRAE/tmp/tst
	//J:/log/tp4
	public static void main(String[] args) throws IOException {
		
		SysParameter par;
		System.out.println( "# " + Arrays.toString(args) );
		String file = args[0]; //"J:/log/rb4"
		String outFile = args[1]; //"J:/log/out" "/home/fricke/speed"
		
		if( args.length > 0 ){
			char[] flags = args[2].toCharArray();
			for( char c : flags ){
				switch( c ){				
				case 'F': algo = AlgoType.FULL_ANC;	break;
				case 'P': algo = AlgoType.PART_ANC;	break;				
				case 's': mode = SPEED_MAXSPACE;	break;
				case 'd': mode = SPACE_DYN;			break;
				case 'b': mode = SPEED_BUF;			break;
				case 'c': mode = SPEED_CAP;			break;
				case 'a': mode = ALL_CAP;			break;
				case 'm': mode = ALL;				break;
				case 'e': mode = EVALUATION;		break;
				case 't': mode = TMP;				break;
				case 'n': mode = ALL_CAP_NEU;		break;
				}
			}
		}

		BufferedWriter out  = new BufferedWriter( new FileWriter( outFile ) );
		DimType[] dims = null;
		int n; 
		double eps;
		long time;
		List<Element> list;
		AbstractComplexHHH hitterAlgo = null;
				
		switch( mode ){

		//////////////////////////////////////////////////////////////////
		// 
		//  Laufzeit und max Speicher bei versch. Dim und Epsilon
		//
		//////////////////////////////////////////////////////////////////
		case SPEED_MAXSPACE:			

			n = 3;
			double epsmin = Double.parseDouble(args[3]);
			double epsmax = Double.parseDouble(args[4]);
			int step = Integer.parseInt(args[5]);
			double stepsize = (epsmax - epsmin) / step;
			double[] points = new double[step+1];
			double pos = epsmin;
			for( int i = 0; i < step +1; i++ ){
				points[i] = pos;
				pos += stepsize;
			}

			out.write( "# " + Arrays.toString( points ) );	
			out.newLine();			
			int sumTupelCount;

			for( int a = 0; a < 2; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 0; round < 3; round++ ){
					switch( round ){
					case 0: dims = new DimType[]{ DimType.CALL }; break;
					case 1: dims = new DimType[]{ DimType.PATH, DimType.CALL }; break;
					case 2: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; break;
					case 3: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN }; break;
					}
					par = new SysParameter( dims ); 		 					
					list = parseElements( file, par );

					for( double point : points ){					
						time = - System.currentTimeMillis();
						sumTupelCount = 0;
						out.write( algo + ";" + round + ";" + point + ";" );
						for( int i = 0; i < n; i++ ){
							hitterAlgo = getAlgo( point, par );
							for( Element e : list ){
								hitterAlgo.insert(e, 1);
							}
							sumTupelCount = hitterAlgo.getMaxTupelCount();
						}
						time += System.currentTimeMillis();
						out.write( "" + time / n + ";" + sumTupelCount );
						out.newLine();
					}
				}
			}			
			break;

			
		//////////////////////////////////////////////////////////////////
		// 
		//  Approximationsgte bei versch. Dim und Epsilon
		//
		//////////////////////////////////////////////////////////////////
		case EVALUATION: // 0.00005 bis 0.01 steps 10
			//J:/log/rb4 D:/fertig/speedneu/tstEvalDyn e 0.00005 0.01 10	
			//J:/log/rb4 D:/fertig/speedneu/tstEvalDyn e 0.00005 0.001 10
			//J:/log/rb4 D:/fertig/speedneu/tstEvalDyn e 0.00005 0.001 20

			n = 1;
			epsmin = Double.parseDouble(args[3]);
			epsmax = Double.parseDouble(args[4]);
			step = Integer.parseInt(args[5]);
			double phi = 0.001;//Double.parseDouble(args[6]);
			stepsize = (epsmax - epsmin) / step;
			points = new double[step+1];
			pos = epsmin;
			for( int i = 0; i < step +1; i++ ){
				points[i] = pos;
				pos += stepsize;
			}

			out.write( "# " + Arrays.toString( points ) );	
			out.newLine();			

			for( int a = 0; a < 2; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 0; round < 3; round++ ){
					switch( round ){
					case 0: dims = new DimType[]{ DimType.CALL }; break;
					case 1: dims = new DimType[]{ DimType.PATH, DimType.CALL }; break;
					case 2: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; break;
					case 3: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN }; break;
					}
					par = new SysParameter( dims ); 		 					
					list = parseElements( file, par );

					for( double point : points ){					

						double ogm = 0;
						double cor = 0;
						double bgm = 0;
						double bgm2 = 0;											

						out.write( algo + ";" + round + ";" + point + ";" );
						System.out.println( algo + ";" + round + ";" + point + ";" );
						for( int i = 0; i < n; i++ ){
							hitterAlgo = getAlgo( point, par );
							for( Element e : list ){
								hitterAlgo.insert(e, 1);
							}
						}

						Exact exactAlgo = new Exact( par );
						for( Element e : list ){
							exactAlgo.insert(e, 1);
						}

						Set<Element> exact = exactAlgo.outputSet(phi).keySet();
						Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
						ogm = Evaluation.ogmGanesan(approx, exact);
						cor = Evaluation.ogmCormode(approx, exact);
						bgm = Evaluation.bgm(approx, exact);
						bgm2 = Evaluation.bgm2(approx, exact);						

						out.write( ogm + ";" + cor + ";" + bgm + ";" + bgm2 );
						out.newLine();
						System.out.println( ogm + ";" + cor + ";" + bgm + ";" + bgm2 );
					}
				}
			}			
			break;

			
			//////////////////////////////////////////////////////////////////
			// 
			//  Speicherbedarf im Zeitverlauf
			//
			//////////////////////////////////////////////////////////////////
		case SPACE_DYN:			

			n = 1;
			eps = Double.parseDouble(args[3]);

			for( int a = 0; a < 2; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 0; round < 3; round++ ){
					switch( round ){
					case 0: dims = new DimType[]{ DimType.CALL }; break;
					case 1: dims = new DimType[]{ DimType.PATH, DimType.CALL }; break;
					case 2: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; break;
					case 3: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN }; break;
					}
					par = new SysParameter( dims ); 		 					
					list = parseElements( file, par );										
					for( int i = 0; i < n; i++ ){
						out.flush();
						hitterAlgo = getAlgo( eps, par );
						int count = 0;
						for( Element e : list ){
							hitterAlgo.insert(e, 1);
							if( ++count % 20 == 0 ){
								out.write( algo + ";" + round + ";" + eps + ";" + count + ";" + hitterAlgo.getTupelCount() );
								out.newLine();
							}
						}						
					}					
				}
			}
			break;

			//////////////////////////////////////////////////////////////////
			// 
			//  Rechenzeit Puffern
			//
			//////////////////////////////////////////////////////////////////
		case SPEED_BUF:		//J:/log/tp4 D:/fertig/speedneu/tstOutTP4cor5 b 	

			double buf;
			n = 5;
			//eps = Double.parseDouble(args[3]);
			//buf = Double.parseDouble(args[4]);
			long timeBuf, timeAlgoBuf;
			AbstractComplexHHH buffAlgo;
			HashMultiset<Element> buffer = HashMultiset.create(1000000);

			for( eps = 0.000001; eps < 0.02; eps *= 100 ){
				for( buf = 3; buf < 28; buf *= 3 ){
					for( int a = 0; a < 2; a++ ){
						if( a == 0 ) algo = AlgoType.FULL_ANC;
						else algo = AlgoType.PART_ANC;
						for( int round = 0; round < 3; round++ ){
							switch( round ){
							case 0: dims = new DimType[]{ DimType.CALL }; break;
							case 1: dims = new DimType[]{ DimType.PATH, DimType.CALL }; break;
							case 2: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; break;
							case 3: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE, DimType.RETURN }; break;
							}
							par = new SysParameter( dims ); 		 					
							list = parseElements( file, par );										
							out.write( algo + ";" + buf + ";" + round + ";" + eps + ";" );

							time = - System.currentTimeMillis();
							for( int i = 0; i < n; i++ ){
								hitterAlgo = getAlgo( eps, par );						
								for( Element e : list ){
									hitterAlgo.insert(e, 1);
								}										
							}	
							time += System.currentTimeMillis();

							int window = (int)Math.floor(1.0 / eps);
							int max = (int)Math.floor(window * buf);
							int counter;
							buffer = HashMultiset.create( 2 * max );
							timeBuf = - System.currentTimeMillis();
							timeAlgoBuf = 0;					
							for( int i = 0; i < n; i++ ){
								buffAlgo = getAlgo( eps, par );						
								counter = 0;
								buffer.clear();
								for( Element e : list ){
									buffer.add(e);							
									if( counter++ >= max ){								
										long tmp = - System.currentTimeMillis();
										for( Element bufEl : buffer.elementSet() ){
											buffAlgo.insert(bufEl, buffer.count(bufEl));
										}
										tmp += System.currentTimeMillis();
										timeAlgoBuf += tmp;
										counter = 0;
										buffer.clear();
									}		
								}
								//PUFFER LEEREN!!!!
								long tmp = - System.currentTimeMillis();
								for( Element bufEl : buffer.elementSet() ){
									buffAlgo.insert(bufEl, buffer.count(bufEl));
								}
								tmp += System.currentTimeMillis();
								timeAlgoBuf += tmp;
								
								//ANZAHL EINGEF ELEM VERGl
								if( buffAlgo.getN() != hitterAlgo.getN() ) throw new RuntimeException( "buffAlgo.getN() != hitterAlgo.getN()" );
								//Quatsch: if( Evaluation.dsm(buffAlgo.dumpf(), hitterAlgo.dumpf()) < .98 )throw new RuntimeException( "Evaluation.dsm(approxDs, exactDs)" );

							}	
							timeBuf += System.currentTimeMillis();

							out.write( "" + time / n + ";" + timeBuf / n + ";" + timeAlgoBuf / n  );
							out.newLine();
							out.flush();
						}
					}
				}
			}
			break;			
			

		//////////////////////////////////////////////////////////////////
		// 
		//  Laufzeit und max Speicher bei Beschr. der Hierarchietiefe
		//
		//////////////////////////////////////////////////////////////////
		case SPEED_CAP: //J:/log/tp4 D:/fertig/speed/TP4cap.txt c 0.00005
						//J:/log/RB4 D:/fertig/speed/RB4cap5e-5.txt c 0.00005

			n = 1;
			eps = Double.parseDouble(args[3]);
			List<int[]> caps = new ArrayList<int[]>();
			
			for( int a = 0; a < 2; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 0; round < 2; round++ ){ ///////////////// Test: round < 2 ///////
					caps.clear();					
					switch( round ){
					case 0: 
						dims = new DimType[]{ DimType.CALL }; 
						for( int i = 1; i < 7; i++ ){
							caps.add( new int[]{i} );
						}
						break;
					case 1: 
						dims = new DimType[]{ DimType.PATH, DimType.CALL }; 
						for( int i = 1; i < 7; i++ ){
							caps.add( new int[]{12,i} );
						}
						for( int i = 1; i < 13; i++ ){
							caps.add( new int[]{i,6} );
						}
						break;
					case 2: 
						dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; 
						for( int i = 1; i < 7; i++ ){
							caps.add( new int[]{12,i,4} );
						}
						for( int i = 1; i < 13; i++ ){
							caps.add( new int[]{i,6,4} );
						}
						for( int i = 1; i < 5; i++ ){
							caps.add( new int[]{12,6,i} );
						}
						break;
					}

					for( int[] cap : caps ){					
						par = new SysParameter( dims, cap ); 		 					
						list = parseElements( file, par );

						time = - System.currentTimeMillis();
						sumTupelCount = 0;
						out.write( algo + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";" );
						for( int i = 0; i < n; i++ ){
							hitterAlgo = getAlgo( eps, par );
							for( Element e : list ){
								hitterAlgo.insert(e, 1);
							}
							sumTupelCount = hitterAlgo.getMaxTupelCount();
						}
						time += System.currentTimeMillis();
						out.write( "" + time / n + ";" + sumTupelCount );
						out.newLine();
					}
				}
			}			
			break;

			
			//////////////////////////////////////////////////////////////////
			// 
			//  Laufzeit und max Speicher, Verwendung aller Dateien, alle Kombinationen von Dimensionen
			//	Zusaetzlich Approximationsguete.
			//
			//////////////////////////////////////////////////////////////////
		case ALL: 	//J:/log/tp4 D:/fertig/speedneu/tstEval m 0.0005
					//J:/log/tp4 D:/fertig/speedneu/tstEval2 m 0.01
					//J:/log/tp4 D:/fertig/speedneu/tstEval3 m 0.0005
			//J:/log/tp4 D:/fertig/speedneu/tstEvalSilly m 0.0005
			//J:/log/tp4 D:/fertig/speedneu/tstEval4 m 0.0005

			out.write( "algo;round;eps;time;sumTupCount;ogm;cor;bgm;bgm2;length;sizeExact;sizeApprox;timeV;approxV;dssizeV;hhhsizeV"  );
			out.newLine();
			n = 1;
			eps = Double.parseDouble(args[3]);
			phi = 4 * eps;
			String prefix = "J:/log/";
			String[] files = "ff;tp;rb;gy;ne;vg;xe;ka;xt;tb;ep".split(";");
			
			double[] t_vect;			
			double[] a_vect;
			int[] s_vect;
			int[] h_vect;
			int[] e_vect;
			
			List<String> allfiles = new ArrayList<String>();
			for( String s : files ) allfiles.add( prefix + s + "1" );
						
			for( int a = 0; a < 2; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 0; round < 7; round++ ){ 					
					t_vect = new double[files.length];					
					a_vect = new double[files.length];
					s_vect = new int[files.length];
					h_vect = new int[files.length];
					
					switch( round ){
					case 0: dims = new DimType[]{ DimType.CALL };  break;
					case 1:	dims = new DimType[]{ DimType.PATH }; break;
					case 2: dims = new DimType[]{ DimType.SEQUENCE }; break;
					case 3:	dims = new DimType[]{ DimType.PATH, DimType.CALL }; break;
					case 4:	dims = new DimType[]{ DimType.PATH, DimType.SEQUENCE }; break;
					case 5:	dims = new DimType[]{ DimType.CALL, DimType.SEQUENCE }; break;
					case 6: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; break;					
					}
								
					par = new SysParameter( dims ); 		 					
					
					out.write( algo + ";" + round + ";" + eps + ";" );
					System.out.println( algo + ";" + round + ";" + eps + ";" );
					
					time = 0;						
					sumTupelCount = 0;
					double ogm = 0;
					double cor = 0;
					double bgm = 0;
					double bgm2 = 0;										
					int length = 0;
					int sizeExact = 0;
					int sizeApprox = 0;
					
					int fileNr = 0;
					for( String aFile : allfiles ){
						list = null;
						list = parseElements( aFile, par );
						
						length += list.size();
			//			System.out.println( algo + ";" + round + "start");
						long tmp = - System.currentTimeMillis();						
						for( int i = 0; i < n; i++ ){
							hitterAlgo = getAlgo( eps, par );
							for( Element e : list ){
								hitterAlgo.insert(e, 1);
							}
							sumTupelCount += hitterAlgo.getMaxTupelCount();
						}
						tmp += System.currentTimeMillis();
		//				System.out.println( algo + ";" + round + "stop");
						time += tmp;
												
						Exact exactAlgo = new Exact( par );
						for( Element e : list ){
							exactAlgo.insert(e, 1);
						}
						
						Set<Element> exact = exactAlgo.outputSet(phi).keySet();
						Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
						ogm += Evaluation.ogmGanesan(approx, exact);
						cor += Evaluation.ogmCormode(approx, exact);
						bgm += Evaluation.bgm(approx, exact);
						double tmpA = Evaluation.bgm2(approx, exact);
						bgm2 += tmpA;
						sizeExact += exact.size();
						sizeApprox += approx.size();
						
						t_vect[fileNr] = tmp; 						
						a_vect[fileNr] = tmpA;
						s_vect[fileNr] = hitterAlgo.getMaxTupelCount();
						h_vect[fileNr] = approx.size();
						
						fileNr++;
					}
					
					out.write( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) );
					out.write(";" + ogm / ( n * allfiles.size() ) );
					out.write(";" + cor / ( n * allfiles.size() ) );
					out.write(";" + bgm / ( n * allfiles.size() ) );
					out.write(";" + bgm2 / ( n * allfiles.size() ) );
					out.write(";" + length /  allfiles.size() );
					out.write(";" + sizeExact /  allfiles.size() );
					out.write(";" + sizeApprox /  allfiles.size() );
					out.write(";" + Arrays.toString(t_vect) );
					out.write(";" + Arrays.toString(a_vect) );
					out.write(";" + Arrays.toString(s_vect) );
					out.write(";" + Arrays.toString(h_vect) );
					System.out.println( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) + ";" + bgm2 / ( n * allfiles.size() ) );
					System.out.println( ";" + length /  allfiles.size() + ";" + sizeExact /  allfiles.size() + ";" + sizeApprox /  allfiles.size() );  
					out.newLine();
					out.flush();
				}

			}			
			break;
			

			
			
						//////////////////////////////////////////////////////////////////
			// 
			//  Laufzeit und max Speicher, Verwendung aller Dateien, alle Kombinationen von Dimensionen
			//	Zusaetzlich Approximationsguete.
			//
			//////////////////////////////////////////////////////////////////
		case ALL_CAP_NEU:
			
			//J:/log/tp4 D:/fertig/speedneu/Cap4 n 0.0005
			//J:/log/tp4 D:/fertig/speedneu/Exact n 0.0005
			
			caps = new ArrayList<int[]>();
			out.write( "algo;round;eps;cap;time;sumTupCount;ogm;cor;bgm;bgm2;length;sizeExact;sizeApprox;timeV;approxV;dssizeV;hhhsizeV;hhhexactV"  );
			out.newLine();
			n = 1;
			eps = Double.parseDouble(args[3]);
			phi = 4 * eps;
			prefix = "J:/log/";
			files = "ff;tp;rb;gy;ne;vg;xe;ka;xt;tb;ep".split(";");
			
		
			allfiles = new ArrayList<String>();
			for( String s : files ) allfiles.add( prefix + s + "1" );
						
			for( int a = 0; a < 2; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 0; round < 7; round++ ){ 					
					t_vect = new double[files.length];					
					a_vect = new double[files.length];
					s_vect = new int[files.length];
					h_vect = new int[files.length];
					e_vect = new int[files.length];
					
					caps.clear();					

					switch( round ){
					case 0: 
						dims = new DimType[]{ DimType.CALL };  
						caps.add( new int[]{6} );
						caps.add( new int[]{3} );
						break;

					case 1:	
						dims = new DimType[]{ DimType.PATH }; 
						caps.add( new int[]{12} );
						caps.add( new int[]{6} );
						break;

					case 2: 
						dims = new DimType[]{ DimType.SEQUENCE }; 
						caps.add( new int[]{4} );
						caps.add( new int[]{2} );
						break;

					case 3:	
						dims = new DimType[]{ DimType.PATH, DimType.CALL }; 
						caps.add( new int[]{12,6} );
						caps.add( new int[]{6,3} );
						break;

					case 4:	
						dims = new DimType[]{ DimType.PATH, DimType.SEQUENCE }; 
						caps.add( new int[]{12,4} );
						caps.add( new int[]{6,2} );						
						break;

					case 5:	
						dims = new DimType[]{ DimType.CALL, DimType.SEQUENCE }; 
						caps.add( new int[]{6,4} );
						caps.add( new int[]{3,2} );						
						break;

					case 6: 
						dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; 
						caps.add( new int[]{12,6,4} );
						caps.add( new int[]{6,3,2} );						
						break;					
					}

					for( int[] cap : caps ){
						par = new SysParameter( dims, cap ); 		 					
						out.write( algo + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";" );

						System.out.println( algo + ";" + round + ";" + eps + ";" );

						time = 0;						
						sumTupelCount = 0;
						double ogm = 0;
						double cor = 0;
						double bgm = 0;
						double bgm2 = 0;										
						int length = 0;
						int sizeExact = 0;
						int sizeApprox = 0;

						int fileNr = 0;
						for( String aFile : allfiles ){
							list = null;
							list = parseElements( aFile, par );

							length += list.size();
							//			System.out.println( algo + ";" + round + "start");
							long tmp = - System.currentTimeMillis();						
							for( int i = 0; i < n; i++ ){
								hitterAlgo = getAlgo( eps, par );
								for( Element e : list ){
							//		hitterAlgo.insert(e, 1);
								}
								sumTupelCount += hitterAlgo.getMaxTupelCount();
							}
							tmp += System.currentTimeMillis();
							//				System.out.println( algo + ";" + round + "stop");
							time += tmp;

							Exact exactAlgo = new Exact( par );
							for( Element e : list ){
								exactAlgo.insert(e, 1);
							}

							Set<Element> exact = exactAlgo.outputSet(phi).keySet();
							Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
							ogm += Evaluation.ogmGanesan(approx, exact);
							cor += Evaluation.ogmCormode(approx, exact);
							bgm += Evaluation.bgm(approx, exact);
							double tmpA = Evaluation.bgm2(approx, exact);
							bgm2 += tmpA;
							sizeExact += exact.size();
							sizeApprox += approx.size();

							t_vect[fileNr] = tmp; 						
							a_vect[fileNr] = tmpA;
							s_vect[fileNr] = hitterAlgo.getMaxTupelCount();
							h_vect[fileNr] = approx.size();
							e_vect[fileNr] = exact.size();

							fileNr++;
						}

						out.write( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) );
						out.write(";" + ogm / ( n * allfiles.size() ) );
						out.write(";" + cor / ( n * allfiles.size() ) );
						out.write(";" + bgm / ( n * allfiles.size() ) );
						out.write(";" + bgm2 / ( n * allfiles.size() ) );
						out.write(";" + length /  allfiles.size() );
						out.write(";" + sizeExact /  allfiles.size() );
						out.write(";" + sizeApprox /  allfiles.size() );
						out.write(";" + Arrays.toString(t_vect) );
						out.write(";" + Arrays.toString(a_vect) );
						out.write(";" + Arrays.toString(s_vect) );
						out.write(";" + Arrays.toString(h_vect) );
						out.write(";" + Arrays.toString(e_vect) );
						System.out.println( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) + ";" + bgm2 / ( n * allfiles.size() ) );
						System.out.println( ";" + length /  allfiles.size() + ";" + sizeExact /  allfiles.size() + ";" + sizeApprox /  allfiles.size() );  
						out.newLine();
						out.flush();
					}
				}

			}			
			break;
			
			
			
			//////////////////////////////////////////////////////////////////
			// 
			//  Laufzeit und max Speicher bei Beschr. der Hierarchietiefe, Verwendung aller Dateien
			//
			//////////////////////////////////////////////////////////////////
			case ALL_CAP: //J:/log/tp4 D:/fertig/speed/TP4cap.txt a 0.00005			
							
			n = 1;
			eps = Double.parseDouble(args[3]);
			caps = new ArrayList<int[]>();
			
			prefix = "J:/log/";
			files = "ff;tp;rb;gy;ne;vg;xe;ka;xt;tb;ep".split(";");
			allfiles = new ArrayList<String>();
			for( String s : files ) allfiles.add( prefix + s + "1" );
			
			
			for( int a = 0; a < 2; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 0; round < 7; round++ ){ 					
					caps.clear();					

					switch( round ){
					case 0: 
						dims = new DimType[]{ DimType.CALL };  
						caps.add( new int[]{6} );
						caps.add( new int[]{3} );
						break;
					
					case 1:	
						dims = new DimType[]{ DimType.PATH }; 
						caps.add( new int[]{12} );
						caps.add( new int[]{6} );
						break;
						
					case 2: 
						dims = new DimType[]{ DimType.SEQUENCE }; 
						caps.add( new int[]{4} );
						caps.add( new int[]{2} );
						break;
						
					case 3:	
						dims = new DimType[]{ DimType.PATH, DimType.CALL }; 
						caps.add( new int[]{12,6} );
						caps.add( new int[]{6,3} );
						break;
						
					case 4:	
						dims = new DimType[]{ DimType.PATH, DimType.SEQUENCE }; 
						caps.add( new int[]{12,4} );
						caps.add( new int[]{6,2} );						
						break;
						
					case 5:	
						dims = new DimType[]{ DimType.CALL, DimType.SEQUENCE }; 
						caps.add( new int[]{6,4} );
						caps.add( new int[]{3,2} );						
						break;
						
					case 6: 
						dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; 
						caps.add( new int[]{12,6,4} );
						caps.add( new int[]{6,3,2} );						
						break;					
					}
						
					for( int[] cap : caps ){
						par = new SysParameter( dims, cap ); 		 					
						out.write( algo + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";" );
						System.out.println( algo + ";" + round + ";" + eps + ";" + Arrays.toString(cap) + ";" );

						time = 0;						
						sumTupelCount = 0;

						for( String aFile : allfiles ){
							list = parseElements( aFile, par );
							long tmp = - System.currentTimeMillis();						

							for( int i = 0; i < n; i++ ){
								hitterAlgo = getAlgo( eps, par );
								for( Element e : list ){
									hitterAlgo.insert(e, 1);
								}
								sumTupelCount += hitterAlgo.getMaxTupelCount();
							}
							tmp += System.currentTimeMillis();
							time += tmp;
						}
						out.write( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) );
						System.out.println( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) );
						out.newLine();
					}
				}

			}			
			break;


			
			//////////////////////////////////////////////////////////////////
			// 
			//  Laufzeit und max Speicher, Verwendung einer Datei, um Anteil parsen, stromverarbeitung
			//  und outputmethode zu sehen 
			//	
			//////////////////////////////////////////////////////////////////
		case TMP: 	//J:/log/tb3 D:/fertig/tmp/tmp t 0.0005 0.002
					//J:/log/tb3 D:/fertig/tmp/tmp t 0.0005 0.00002
					//J:/log/tb3 D:/fertig/tmp/tmp t 0.000005 0.00002
			
			n = 1;
			eps = Double.parseDouble(args[3]);
			phi = Double.parseDouble(args[4]);
			//phi = 2 * eps;
			//prefix = "J:/log/";
			//files = "tb".split(";");
			allfiles = new ArrayList<String>();
			//for( String s : files ) allfiles.add( prefix + s + "3" );
			allfiles.add( file );			
			
			for( int a = 0; a < 1; a++ ){
				if( a == 0) algo = AlgoType.FULL_ANC;
				else algo = AlgoType.PART_ANC;
				for( int round = 3; round < 4; round++ ){ 					
					switch( round ){
					case 0: dims = new DimType[]{ DimType.CALL };  break;
					case 1:	dims = new DimType[]{ DimType.PATH }; break;
					case 2: dims = new DimType[]{ DimType.SEQUENCE }; break;
					case 3:	dims = new DimType[]{ DimType.PATH, DimType.CALL }; break;
					case 4:	dims = new DimType[]{ DimType.PATH, DimType.SEQUENCE }; break;
					case 5:	dims = new DimType[]{ DimType.CALL, DimType.SEQUENCE }; break;
					case 6: dims = new DimType[]{ DimType.PATH, DimType.CALL, DimType.SEQUENCE }; break;					
					}
								
					par = new SysParameter( dims ); 		 					
					out.write( algo + ";" + round + ";" + eps + ";" );
					System.out.println( algo + ";" + round + ";" + eps + ";" );
					
					time = 0;						
					sumTupelCount = 0;
					double ogm = 0;
					double cor = 0;
					double bgm = 0;
					double bgm2 = 0;										
					int length = 0;
					int sizeExact = 0;
					int sizeApprox = 0;
					
					for( String aFile : allfiles ){
						System.out.println( algo + ";" + round + "start parse " + new Date() );
						list = parseElements( aFile, par );
						
						length += list.size();
						System.out.println( algo + ";" + round + "start stream " + new Date() );
						long tmp = - System.currentTimeMillis();						
						for( int i = 0; i < n; i++ ){
							hitterAlgo = getAlgo( eps, par );
							for( Element e : list ){
								hitterAlgo.insert(e, 1);
							}
							sumTupelCount += hitterAlgo.getMaxTupelCount();
						}
						tmp += System.currentTimeMillis();
						time += tmp;

						System.out.println( algo + ";" + round + "start output " + new Date() );
						Set<Element> approx = hitterAlgo.outputSet(phi).keySet();
						
						System.out.println( algo + ";" + round + "start exact " + new Date() );
						Exact exactAlgo = new Exact( par );
						for( Element e : list ){
							exactAlgo.insert(e, 1);
						}
						
						System.out.println( algo + ";" + round + "start output exact" + new Date() );
						Set<Element> exact = exactAlgo.outputSet(phi).keySet();

						System.out.println( algo + ";" + round + "start Evaluation " + new Date() );
						ogm += Evaluation.ogmGanesan(approx, exact);
						cor += Evaluation.ogmCormode(approx, exact);
						bgm += Evaluation.bgm(approx, exact);
						bgm2 += Evaluation.bgm2(approx, exact);
						System.out.println( algo + ";" + round + "stop Evaluation " + new Date() );
						sizeExact += exact.size();
						sizeApprox += approx.size();
						
					}
					out.write( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) );
					out.write(";" + ogm / ( n * allfiles.size() ) );
					out.write(";" + cor / ( n * allfiles.size() ) );
					out.write(";" + bgm / ( n * allfiles.size() ) );
					out.write(";" + bgm2 / ( n * allfiles.size() ) );
					out.write(";" + length /  allfiles.size() );
					out.write(";" + sizeExact /  allfiles.size() );
					out.write(";" + sizeApprox /  allfiles.size() );
					System.out.println( "" + time / ( n * allfiles.size() ) + ";" + sumTupelCount / ( n * allfiles.size() ) + ";" + bgm2 / ( n * allfiles.size() ) );
					System.out.println( ";" + length /  allfiles.size() + ";" + sizeExact /  allfiles.size() + ";" + sizeApprox /  allfiles.size() );  
					out.newLine();
					out.flush();
				}

			}			
			break;
			

			
		}//End switch
		LogService.logDBClose();
		out.close();
	}


	static AbstractComplexHHH getAlgo( double epsilon, Parameter par ){
		AbstractComplexHHH hitterAlgo; 
		switch( algo ){
		case FULL_ANC: hitterAlgo = new FullAncHHH( epsilon, par ); break;
		case PART_ANC: hitterAlgo = new PartAncHHH( epsilon, par ); break;
		default: throw new RuntimeException("Kein Algorithmus gewaehlt");
		}
		return hitterAlgo;
	}

	
	// Gibt den geparsten Inhalt der Datei als Liste von Elementen zurueck.
	// Die Elemente koennen nun in den HitterAlgorithmus gefuettert werden,
	// dabei kann die erforderliche Laufzeit gemessen werden, ohne dass sie
	// durch das Parsen verfaelscht wird.
	public static List<Element> parseElements( String file, 
			SysParameter par ) {				
							
		List<Element> list = new ArrayList<Element>();
		BufferedReader in = null;
		SysElement el;
		String line;
		int counter = 0;		

		SysParser parser = new SysParser( par );					
		//System.out.println( par );

		try{ 
			in  = new BufferedReader( new FileReader( file ) );

			while( (line = in.readLine()) != null ){      				
				if( line.length() > 0 && ( ! line.startsWith("#") )){			
					el = parser.createElement( line );
					if( el != null ) {		
						list.add(el);
						counter++;
					}
				}
			}

		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print( e.getMessage() );			
		}
		catch (java.io.IOException e){			
			System.out.print( e.getMessage() );			
		}

//		System.out.println( "counter = " + counter );
//		System.out.println( "ParserCounter = " + parser.getCounter() );
//		System.out.println( counter / (double)parser.getCounter() );

		LogService.logDBClose();
		try{
			in.close();			
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		}		
		return list;
	}


	// Gibt ein Objekt vom Typ AbstractComplexHHH zurueck,
	// das mit dem uebergebenen epsilon den in der Datei enthaltenen
	// Strom aggregiert hat und nun fuer beliebige phi die passenden
	// approximativen HHH ausgeben kann.
	private static AbstractComplexHHH fillApprox( String file, 
			SysParameter par, double epsilon, AlgoType algo ) {				

		AbstractComplexHHH fastPA;					
		BufferedReader in = null;
		BufferedWriter out = null;
		SysElement el;
		String line;
		int counter = 0;		

		//HashSet<String> callSubset = new HashSet<String>(); 
		//par.setUsedCalls( callSubset );
		SysParser parser = new SysParser( par );		
			
		System.out.println( "\n# Datei = " + file );
		System.out.println( "\n# Epsilon = " + epsilon );
		System.out.println( "\n# Algo = " + algo );
		System.out.println( par );
		
		switch( algo ){
		case FULL_ANC: fastPA = new FullAncHHH( epsilon, par ); break;
		case PART_ANC: fastPA = new PartAncHHH( epsilon, par ); break;
		default: throw new RuntimeException("Kein Algorithmus gewaehlt");
		}			

		try{ 
			in  = new BufferedReader( new FileReader( file) );
			out = new BufferedWriter(new FileWriter("tmp/out"));

			while( (line = in.readLine()) != null ){      				
				if( line.length() > 0 ){			
					//if( counter++ > 100000 ) break;
					//System.out.println( "Input = " + line );
					el = parser.createElement( line );
					if( el != null ) {		
						fastPA.insert( el, 1 );
						counter++;
					}
					//	if( counter > 500000 && counter < 900000 ) 
					//	out.write( el + System.getProperty("line.separator") );
					//	System.out.println( line );
					//	System.out.println( el );
				}
			}

		}
		catch (java.io.FileNotFoundException e){ 
			System.out.print( e.getMessage() );			
		}
		catch (java.io.IOException e){			
			System.out.print( e.getMessage() );			
		}

		System.out.println( "counter = " + counter );
		System.out.println( "ParserCounter = " + parser.getCounter() );
		System.out.println( counter / (double)parser.getCounter() );

		LogService.logDBClose();
		try{
			in.close();
			out.close();
		}
		catch (java.io.IOException e) { 
			System.out.println("CloseWrite: Error: " + e.getMessage()); 
		}
		
		return fastPA;
	}

}
