/**
 * @author Peter Fricke 
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import hitters.multi.Element;
import hitters.multi.Evaluation;

import java.util.Map;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

/**
 * Calculates the hierarchy-aware similarity of the given data structures.
 * 
 * @author Peter Fricke 
 *
 */
public class DataStructSimilarity extends SimilarityMeasure {
		
	private static final long serialVersionUID = 5231354969672836148L;
	public static final String DS_ATTRIBUTE = "dataStructID";
	ObjectAttribute<?> dsmAttribute;	
	int index = -1;
	
	/* (non-Javadoc)
	 * @see com.rapidminer.tools.math.similarity.DistanceMeasure#calculateDistance(double[], double[])
	 */
	@Override
	public double calculateDistance(double[] value1, double[] value2) {	
		return 1 - calculateSimilarity( value1, value2 );
	}

	/* (non-Javadoc)
	 * @see com.rapidminer.tools.math.similarity.DistanceMeasure#calculateSimilarity(double[], double[])
	 */
	@SuppressWarnings("unchecked")
	@Override
	public double calculateSimilarity(double[] value1, double[] value2) {

		if( dsmAttribute == null ) 
			throw new RuntimeException("No dsmAttribute was stored during init");

		Map<Element, Integer> ds1, ds2;
		int index1 = new Double( value1[index] ).intValue();
		int index2 = new Double( value2[index] ).intValue();
		ds1 = (Map<Element, Integer>) dsmAttribute.getMapping().mapObjectIndex( index1 );
		ds2 = (Map<Element, Integer>) dsmAttribute.getMapping().mapObjectIndex( index2 );		
		if( ds1.size() == 0 || ds2.size() == 0 ) return 0;
		
		double sim = Evaluation.dsm( ds1, ds2 );
		
		return sim;
	}

	
	/* (non-Javadoc)
	 * @see com.rapidminer.tools.math.similarity.DistanceMeasure#init(com.rapidminer.example.ExampleSet)
	 */
	@Override
	public void init(ExampleSet exampleSet) throws OperatorException {
		
		int i = 0;
		Attributes attributes = exampleSet.getAttributes();
		for( Attribute a : attributes ){			
			if( a.getName().equals( DS_ATTRIBUTE ) ){								
				dsmAttribute = (ObjectAttribute<?>)a;
				index = i;
			}
			i++;
		}
		if( dsmAttribute == null ){
			throw new UserError(null, 128, "ID (containing the data structure " +
					"obtained when calculating the Hierarchical Heavy Hitters)." +
					" The distance measure you have chosen is " +
					"not applicable for other datasets");		
		}
	}

}
