/**
 * 
 */
package com.rapidminer.gui.viewer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import hitters.multi.Element;
import hitters.multi.SysParameter;

import javax.swing.table.AbstractTableModel;

import com.rapidminer.operator.preprocessing.hhhitter.HHHResult;

/**
 * @author Peter Fricke
 *
 * @version $Id$
 */
public class HHHTableModel extends AbstractTableModel {
	
	private static final long serialVersionUID = -8269975310895824917L;
	HHHResult result;
	List<Set<Element>> hitters;
	List<String> names;
	SysParameter par;
	List< String[] > table;	
	
	public HHHTableModel( HHHResult result ){
		this.result = result;
		hitters = result.getAllHitters();
		names = result.getNames();
		par = result.getParameters().par;
		table = makeTable();
	}
	
	
	public String getColumnName(int column) {
		
		if( column == 0 ) return "Name";
		else return par.dimContents( column - 1 ).toString();
	}
		
	
	/* (non-Javadoc)
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	@Override
	public int getColumnCount() {		
		if( hitters.size() == 0 || hitters.get(0).size() == 0 )
			return 0;
		
		int columnCount = -1;
		for( Element e : hitters.get(0) ){
			columnCount = e.getDim() + 1;//+1 for name
			break;
		}
		
		return columnCount;
	}

	
	/* (non-Javadoc)
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	@Override
	public int getRowCount() {
		
		return table.size();
	}

	
	/* (non-Javadoc)
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	@Override
	public Object getValueAt(int arg0, int arg1) {
 
		return table.get(arg0)[arg1];
	}
	
	
	private List< String[] > makeTable(){
		
		List< String[] > table = new ArrayList< String[] >();
		int columnCount = getColumnCount();		
		String[] row;
		String[] comps;
		
		for( int i = 0; i < hitters.size(); i++ ){			
						
			if( i > 0) {
				row = new String[columnCount];				
				for( int k = 0; k < row.length; k++) row[k] = " ";
				table.add( row );
			}
			
			for( Element e : hitters.get(i) ){								
				comps = e.toShortString().split("\\|");
				row = new String[columnCount];
				System.arraycopy(comps, 0, row, 1, comps.length);
				row[0] = names.get(i);
				table.add( row );
			}			
		}

		return table;
	}
	
}
