
package com.rapidminer.example.table;

import com.rapidminer.example.UnknownStatistics;
import com.rapidminer.tools.Ontology;

public class DummyAttribute extends AbstractAttribute {

	DummyAttribute(String name, int valueType) {
		super(name, valueType);
		registerStatistics(new UnknownStatistics());
	}	

	DummyAttribute(String name) {
		this(name, Ontology.NUMERICAL);
	}

	private DummyAttribute(DummyAttribute a) {
		super(a);
	}

	public Object clone() {
		return new DummyAttribute(this);
	}

	public boolean isNominal() {
		return false;
	}

	public boolean isNumerical() { 
		return true; 
	}
	

	public NominalMapping getMapping() {
		throw new UnsupportedOperationException("The method getNominalMapping() is not supported by numerical attributes! You probably tried to execute an operator on a numerical data which is only able to handle nominal values. You could use one of the discretization operators before this application.");
	}

	public void setMapping(NominalMapping mapping) {}

	public String getAsString(double value, int numberOfDigits, boolean quoteNominal) {
		if (Double.isNaN(value)) return "?";
		else return Double.toString(value); 
	}

}
