/*
 * Decompiled with CFR 0.152.
 */
package hitters.tools;

import com.google.common.collect.HashMultiset;
import com.rapidminer.operator.UserError;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.MultiDatabase;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class Utils {
    private static final List<String> list;

    public static String createCallCode(HashSet<String> calls) throws UserError {
        for (String used : calls) {
            if (list.contains(used)) continue;
            throw new UserError(null, 127, new Object[]{"You have changed the taxonomy, but not the way filenames for cachefiles are created in hitters.tools.Utils. Please switch off caching or check hitters.tools.Utils."});
        }
        long code = 0L;
        int i = 0;
        for (String single : list) {
            if (calls.contains(single)) {
                code += 1L << i;
            }
            ++i;
        }
        return Long.toString(code);
    }

    public static String format(double d) {
        DecimalFormatSymbols formatInst = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
        return new DecimalFormat("#.000000", formatInst).format(d);
    }

    public static long exp(int b, int ex) {
        if (ex == 0) {
            return 1L;
        }
        long c = b;
        for (int i = 0; i < ex - 1; ++i) {
            c *= (long)b;
        }
        return c;
    }

    public static String[] resourceLocationsJar() {
        String locations = "/ /rsc/ /resources/rsc";
        return locations.split(" ");
    }

    public static String[] resourceLocationsFiles() {
        String locations = "/../resources/rsc/ /resources/rsc/ /../../resources/rsc/ /../../UBU/resources/rsc/ /../../HHH/resources/rsc/";
        return locations.split(" ");
    }

    public static HashMultiset<String> getHist(String filename) {
        HashMultiset<String> set = HashMultiset.create();
        DimType[] dims = new DimType[]{DimType.CALL};
        SysParameter par = new SysParameter(dims);
        MultiDatabase d = new MultiDatabase(filename, par);
        d.openRead();
        Vector<Element> elements = d.readSystemCalls();
        d.closeRead();
        for (Element e : elements) {
            String s = ((SysElement)e).toShortString();
            s = s.split("/")[2];
            set.add((Object)s);
        }
        return set;
    }

    public static HashMultiset<String> getGlobalHist(String path) {
        File[] files;
        HashMultiset<String> set = HashMultiset.create();
        File dir = new File(path);
        System.out.println("Dir = " + dir);
        for (File f : files = dir.listFiles()) {
            System.out.println("Get: " + f.getAbsolutePath());
            set.addAll(Utils.getHist(f.getAbsolutePath()));
        }
        return set;
    }

    public static String cleanPath2(String file) {
        if (file == null) {
            return null;
        }
        if (!file.startsWith("/")) {
            return null;
        }
        if (file.equals("/")) {
            return "/";
        }
        String path = Utils.cleanPath(file);
        if (path.startsWith("/fs")) {
            return null;
        }
        return path;
    }

    public static String cleanPath(String file) {
        int k;
        while (file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
        }
        while (file.startsWith("../") || file.startsWith("./")) {
            int i = file.indexOf("/");
            file = file.substring(i);
        }
        int lev = 0;
        int oldk = k = file.indexOf(47, 0);
        while (k >= 0) {
            if ((k = file.indexOf(47, k + 1)) == oldk + 1) {
                file = k == 1 ? file.substring(k) : file.substring(0, k - 1) + file.substring(k);
                --k;
                continue;
            }
            ++lev;
            oldk = k;
        }
        String[] parts = file.split("/");
        int i = 0;
        for (String comp : parts) {
            if (comp.equals("..")) {
                i = Math.max(i - 1, 1);
                continue;
            }
            if (comp.equals(".")) continue;
            parts[i++] = comp;
        }
        file = "/";
        for (int j = 1; j < i; ++j) {
            if (j > 1) {
                file = file + "/";
            }
            file = file + parts[j];
        }
        return file;
    }

    static {
        String fixedCalls = "_llseek;accept;accept4;access;brk;clock_gettime;clone;close;dup;dup2;dup3;execve;fcntl;fcntl64;fork;fstat;fstat64;futex;getdents;getdents64;gettimeofday;inotify_init;inotify_init1;ioctl;lseek;lstat;lstat64;mmap2;mprotect;munmap;nanosleep;open;pipe;pipe2;poll;read;readlink;recv;recvmsg;rt_sigaction;select;send;sendfile;sendmsg;sendto;socket;stat;stat64;time;uname;unshare;vfork;write;writev";
        String[] fixed = fixedCalls.split(";");
        list = Arrays.asList(fixed);
    }
}

