/*
 * Decompiled with CFR 0.152.
 */
package hitters.tools;

import hitters.multi.SysParameter;
import hitters.multi.Taxonomy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class ExSetCreate {
    public static void main(String[] args) {
        HashSet<String> labels = new HashSet<String>();
        ArrayList<String> wanted = new ArrayList<String>();
        boolean selectClasses = false;
        String path = args.length > 0 ? args[0] : "D:/ws/HHH/resources/data";
        String outputfile = args.length > 1 ? args[1] : "D:/rapidworkspace-44/DMV/da/tst.csv";
        File dir = new File(path);
        System.out.println("Dir = " + dir);
        File[] files = dir.listFiles();
        String[] filenames = new String[files.length];
        List<String> calls = null;
        List<String> calls2 = null;
        Random rnd = new Random(2001L);
        List<File> list = Arrays.asList(files);
        Collections.shuffle(list, rnd);
        files = list.toArray(new File[0]);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputfile));
            out.write("lab;id");
            calls = ExSetCreate.loadAllCalls();
            calls2 = ExSetCreate.loadCallsImpl();
            Collections.sort(calls);
            Collections.sort(calls2);
            if (args.length > 2 && args[2].equals("PATH")) {
                calls.removeAll(SysParameter.getMinCalls());
            }
            if (args.length > 2 && args[2].equals("FEATURE")) {
                ArrayList<String> shortCalls = new ArrayList<String>();
                for (int i = 1; i < 8; ++i) {
                    shortCalls.add(calls.get(i));
                }
                calls = shortCalls;
            }
            if (args.length > 2 && args[2].equals("CLASS")) {
                selectClasses = true;
                int pos = 3;
                while (args.length > pos) {
                    wanted.add(args[pos++]);
                }
                System.out.println("Wanted: " + wanted);
            }
            int k = -1;
            for (String call : calls) {
                out.write(";" + call);
                System.out.print(call + "  ");
                System.out.println(calls2.get(++k));
            }
            out.newLine();
            int i = -1;
            for (File f : files) {
                filenames[++i] = f.getPath().replace("\\", "/");
                String aLabel = f.getName().substring(0, 2);
                if (selectClasses && !wanted.contains(aLabel)) continue;
                labels.add(aLabel);
                out.write(aLabel + ";" + filenames[i]);
                for (int j = 0; j < calls.size(); ++j) {
                    out.write(";1");
                }
                out.newLine();
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        try {
            out.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
        System.out.println("Scanned directory " + path + ": ");
        System.out.println(files.length + " files, " + labels.size() + " labels. ");
        System.out.println(calls.size() + " calls.");
        System.out.println("Output written to " + outputfile + ".");
    }

    private static List<String> loadCallsImpl() {
        ArrayList<String> list = new ArrayList<String>();
        String file = "resources/callsImpl";
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                list.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private static Taxonomy loadTaxonomy() {
        Taxonomy taxonomy = null;
        try {
            taxonomy = new Taxonomy("Taxonomy3");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return taxonomy;
    }

    private static List<String> loadAllCalls() {
        Taxonomy taxonomy = ExSetCreate.loadTaxonomy();
        ArrayList<String> allCalls = new ArrayList<String>(taxonomy.getAllCalls());
        return allCalls;
    }
}

