/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.Weights;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WeightsTest {
    String file = "resources/testcase/WeightTest/Freq.txt";
    String resultFile = "resources/testcase/WeightTest/Freq.res";
    double exp = 0.5;
    List<String> solution = this.load(this.resultFile);
    Weights w;

    @Before
    public void setUp() throws Exception {
        try {
            this.w = new Weights("Freq.txt", this.exp);
        }
        catch (FileNotFoundException ex) {
            System.out.println("Kann die Datei resources/testcase/WeightTest/Freq.txt nicht finden.");
            System.out.print(ex.getMessage());
        }
    }

    @Test
    public void testGetWeightPlain() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            this.w = new Weights("Freq.txt", 1.0);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 2 || line.startsWith("#")) continue;
                String[] parts = line.split("\\s");
                names.add(parts[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        double d = 0.0;
        for (String call : names) {
            System.out.println(call + "  " + this.w.getFreq(call));
            d += this.w.getFreq(call);
        }
        System.out.println(d);
    }

    @Test
    public void testGetWeight() {
        String[] parts;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> expWeight = new ArrayList<Double>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 2 || line.startsWith("#")) continue;
                parts = line.split("\\s");
                names.add(parts[0]);
                expWeight.add(this.w.getWeight(parts[0]));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String res : this.solution) {
            parts = res.split("\\s");
            double resWt = Double.parseDouble(parts[1]);
            double calcWt = this.w.getWeight(parts[0]);
            Assert.assertTrue(Math.abs(calcWt - resWt) < 1.0E-12);
        }
    }

    @Test
    public void testGetWeightsSum() {
        String fixedCalls = "_llseek;accept;accept4;access;brk;clock_gettime;clone;close;dup;dup2;dup3;execve;fcntl;fcntl64;fork;fstat;fstat64;futex;getdents;getdents64;gettimeofday;inotify_init;inotify_init1;ioctl;lseek;lstat;lstat64;mmap2;mprotect;munmap;nanosleep;open;pipe;pipe2;poll;read;readlink;recv;recvmsg;rt_sigaction;select;send;sendfile;sendmsg;sendto;socket;stat;stat64;time;uname;unshare;vfork;write;writev";
        String[] fixed = fixedCalls.split(";");
        List<String> names = Arrays.asList(fixed);
        try {
            this.w = new Weights("Freq.txt", 1.0);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        int i = 0;
        double d = 0.0;
        for (String call : names) {
            System.out.println(call + "  " + this.w.getCount(call) + "  " + this.w.getFreq(call));
            d += this.w.getFreq(call);
            i += this.w.getCount(call);
        }
        System.out.println("Sum = " + i + "  " + d);
    }

    private List<String> load(String file) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }
}

