/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.DimType;
import hitters.multi.ProcTable;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.multi.SysParser;
import hitters.tools.LogService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SysParserTest {
    String prefix = "resources/testcase/SysParserTest/";
    DimType[] dims = new DimType[]{DimType.PATH, DimType.CALL};
    SysParameter par = new SysParameter(this.dims);
    SysParser parser = new SysParser(this.par);
    Pattern unfinishedP = Pattern.compile("<unfinished ...>$");
    Pattern resumedP = Pattern.compile("<...[^>]* resumed>");
    Pattern sigP = Pattern.compile("--- ");
    Pattern pidP = Pattern.compile("^[0-9]+");

    @Before
    public void setUp() throws Exception {
    }

    @Test
    @Ignore
    public void testBigMassive() {
        String file = "raw/big";
        BufferedWriter out = null;
        boolean problem = false;
        int counter = 0;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.prefix + file));
            out = new BufferedWriter(new FileWriter("tmp/out"));
            while ((line = in.readLine()) != null) {
                SysElement el;
                if (line.length() <= 0 || (el = this.parser.createElement(line)) == null) continue;
                if (++counter < 200000) {
                    out.write(el + System.getProperty("line.separator"));
                }
                el.hashCode();
            }
        }
        catch (FileNotFoundException e) {
            problem = true;
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            problem = true;
            System.out.print(e.getMessage());
        }
        System.out.println("counter = " + counter);
        System.out.println("ParserCounter = " + this.parser.getCounter());
        System.out.println((double)counter / (double)this.parser.getCounter());
        LogService.logDBClose();
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
        Assert.assertFalse(problem);
    }

    @Test
    public void testBracket() {
        List<String> input = this.load("SP1");
        List<String> solution = this.load("SP1.res");
        int i = 0;
        for (String s : input) {
            Matcher m;
            if (s.length() == 0 || (m = this.sigP.matcher(s)).find() || (m = this.unfinishedP.matcher(s)).find() || (m = this.resumedP.matcher(s)).find()) continue;
            String result = this.parser.getPars(s).toString();
            Assert.assertTrue(result.equals(solution.get(i++)));
        }
    }

    @Test
    public void testSplitArray() {
        List<String> input = this.load("SP2");
        List<String> solution = this.load("SP2.res");
        int i = 0;
        for (String s : input) {
            List<String> result = this.parser.splitArray(s);
            for (String c : result) {
                Assert.assertTrue(c.equals(solution.get(i++)));
            }
            if (result.size() <= 0) continue;
            ++i;
        }
    }

    @Test
    public void testSplitSet() {
        List<String> input = this.load("SP3");
        List<String> solution = this.load("SP3.res");
        int i = 0;
        for (String s : input) {
            List<String> result = this.parser.splitSet(s);
            for (String c : result) {
                Assert.assertTrue(c.equals(solution.get(i++)));
            }
            if (result.size() <= 0) continue;
            ++i;
        }
    }

    @Test
    public void testBatch() {
        Assert.assertTrue(this.worksCorrectly("getdents64"));
        Assert.assertTrue(this.worksCorrectly("mmap2"));
        Assert.assertTrue(this.worksCorrectly("select"));
        Assert.assertTrue(this.worksCorrectly("munmap"));
        Assert.assertTrue(this.worksCorrectly("_llseek"));
        Assert.assertTrue(this.worksCorrectly("lseek"));
        Assert.assertTrue(this.worksCorrectly("fstat64"));
        Assert.assertTrue(this.worksCorrectly("writev"));
        Assert.assertTrue(this.worksCorrectly("access"));
        Assert.assertTrue(this.worksCorrectly("fcntl64"));
        Assert.assertTrue(this.worksCorrectly("ioctl"));
        Assert.assertTrue(this.worksCorrectly("mprotect"));
        Assert.assertTrue(this.worksCorrectly("futex"));
        Assert.assertTrue(this.worksCorrectly("poll"));
        Assert.assertTrue(this.worksCorrectly("lstat64"));
        Assert.assertTrue(this.worksCorrectly("stat64"));
        Assert.assertTrue(this.worksCorrectly("recvUni"));
        Assert.assertTrue(this.worksCorrectly("sendUni"));
        Assert.assertTrue(this.worksCorrectly("rt_sigaction"));
        Assert.assertTrue(this.worksCorrectly("fd/brk_clock_get_time"));
        Assert.assertTrue(this.worksCorrectly("nanosleep"));
        Assert.assertTrue(this.worksCorrectly("pathNullProblem"));
        Assert.assertTrue(this.worksCorrectly("Broken4"));
        Assert.assertTrue(this.worksCorrectly("Verona"));
        Assert.assertTrue(this.worksCorrectly("MultiProc"));
        Assert.assertTrue(this.worksCorrectly("fd/open"));
        Assert.assertTrue(this.worksCorrectly("fd/dup2"));
        Assert.assertTrue(this.worksCorrectly("fd/execve"));
        Assert.assertTrue(this.worksCorrectly("fd/clone"));
        Assert.assertTrue(this.worksCorrectly("fd/tricky"));
        Assert.assertTrue(this.worksCorrectly("fd/pipe"));
        Assert.assertTrue(this.worksCorrectly("fd/socket"));
        Assert.assertTrue(this.worksCorrectly("fd/inotify"));
        Assert.assertTrue(this.worksCorrectly("fd/accept"));
        Assert.assertTrue(this.worksCorrectly("fd/fork_vfork"));
        Assert.assertTrue(this.worksCorrectly("fd/unshare"));
    }

    @Test
    public void testActive() {
        String call = "DAseq";
        DimType[] dims = new DimType[]{DimType.PATH};
        SysParameter par = new SysParameter(dims);
        System.out.println(par);
        SysParser parser = new SysParser(par);
        List<String> input = this.load(call);
        boolean problem = false;
        for (String line : input) {
            if (line.length() <= 0) continue;
            SysElement el = parser.createElement(line);
            System.out.println(el);
        }
        Assert.assertFalse(problem);
    }

    @Test
    public void testFd() {
        String call = "pathNullProblem";
        List<String> input = this.load(call);
        boolean problem = false;
        for (String line : input) {
            if (line.length() <= 0) continue;
            SysElement el = this.parser.createElement(line);
            System.out.println(el);
            el.hashCode();
        }
        Assert.assertFalse(problem);
    }

    @Test
    public void testMultiSeq() {
        SysElement el;
        String result;
        String file = "DimStuff/Seq";
        DimType[] dims = new DimType[]{DimType.PATH, DimType.CALL, DimType.SEQUENCE};
        SysParameter par = new SysParameter(dims);
        SysParser parser = new SysParser(par);
        List<String> input = this.load(file);
        List<String> solution = this.load(file + ".res");
        int i = 0;
        boolean problem = false;
        for (String line : input) {
            if (line.length() <= 0) continue;
            result = solution.get(i++);
            el = parser.createElement(line);
            if (el.toString().equals(result.trim())) continue;
            problem = true;
        }
        Assert.assertFalse(problem);
        DimType[] dims2 = new DimType[]{DimType.CALL, DimType.SEQUENCE};
        par = new SysParameter(dims2);
        parser = new SysParser(par);
        input = this.load(file);
        solution = this.load(file + "2.res");
        i = 0;
        for (String line : input) {
            if (line.length() <= 0) continue;
            result = solution.get(i++);
            el = parser.createElement(line);
            if (el.toString().equals(result.trim())) continue;
            problem = true;
        }
        Assert.assertFalse(problem);
        DimType[] dims3 = new DimType[]{DimType.PATH, DimType.SEQUENCE};
        par = new SysParameter(dims3);
        parser = new SysParser(par);
        input = this.load(file);
        solution = this.load(file + "3.res");
        i = 0;
        for (String line : input) {
            if (line.length() <= 0) continue;
            result = solution.get(i++);
            el = parser.createElement(line);
            if (el.toString().equals(result.trim())) continue;
            problem = true;
        }
        Assert.assertFalse(problem);
        DimType[] dims4 = new DimType[]{DimType.PATH, DimType.CALL, DimType.RETURN};
        par = new SysParameter(dims4);
        parser = new SysParser(par);
        input = this.load(file);
        solution = this.load(file + "4.res");
        i = 0;
        for (String line : input) {
            if (line.length() <= 0) continue;
            result = solution.get(i++);
            el = parser.createElement(line);
            if (el.toString().equals(result.trim())) continue;
            problem = true;
        }
        Assert.assertFalse(problem);
    }

    @Test
    public void testBuffer() {
        ProcTable pt = new ProcTable(this.par);
        int i = 0;
        List<String> solution = this.load("ProcTable/RoundBuffer.res");
        for (int c = 0; c < 12; ++c) {
            pt.putCall(c);
            String result = solution.get(i++);
            Assert.assertTrue(result.equals(Arrays.toString(pt.getCalls())));
        }
    }

    @Test
    public void testCleanPath() {
        String[] path = new String[]{"\"/etc///ld.so.nohwcap\"", "////etc/ld.so.nohwcap", "/////etc//////ld.so.nohwcap", "/usr/lib/eclipse", "//usr/lib//eclipse/plugins//org.eclipse.platform_3.2.2.r322_v20070117b/////nl/de/DE/splash.bmp", "\"/Socket\""};
        String[] clean = new String[]{"/etc/ld.so.nohwcap", "/etc/ld.so.nohwcap", "/etc/ld.so.nohwcap", "/usr/lib/eclipse", "/usr/lib/eclipse/plugins/org.eclipse.platform_3.2.2.r322_v20070117b/nl/de/DE/splash.bmp", "/Socket"};
        for (int i = 0; i < path.length; ++i) {
            System.out.println(this.parser.cleanPath(path[i]));
            Assert.assertTrue(this.parser.cleanPath(path[i]).equals(clean[i]));
        }
    }

    public static List<String> mySplitArray(String line) {
        String STRING = "\"[^\"]*\"";
        STRING = "\"(\\\"|[^\"])*\"";
        String STRINGTRAIL = "(" + STRING + "(\\.\\.\\.)?)";
        String SET = "\\{[^\\}\\{]*\\}";
        String ARRAY = "\\[[^\\[\\]]*\\]";
        String NUMBER = "((-?0x[0-9a-f]+)|(-?[0-9]+))";
        String SYMBOL = "([A-Z_\\|]+)";
        String COM = "(/\\*[^\\*]*\\*/)";
        String EXT_SINGLE = "(" + STRINGTRAIL + "|" + NUMBER + "|" + SET + "|" + ARRAY + "|" + SYMBOL + "|" + COM + ")";
        Pattern extSingleP = Pattern.compile(EXT_SINGLE);
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = extSingleP.matcher(line.substring(1));
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    @Test
    @Ignore
    public void testRegExp() {
        String STRING = "(\"((?<=\\\\)\"|[^\"])*\")";
        String STRINGTRAIL = "(" + STRING + "(\\.\\.\\.)?)";
        String FLAT_SET = "(\\{([^\\[\\]\\{\\}\\\"]|" + STRINGTRAIL + ")*\\})";
        String FLAT_ARRAY = "(\\[([^\\[\\]\\{\\}\\\"]|" + STRINGTRAIL + ")*\\])";
        String SET = "(\\{([^\\}\\{]|" + STRINGTRAIL + "|" + FLAT_SET + "|" + FLAT_ARRAY + ")*\\})";
        String NUMBER = "((-?0x[0-9a-f]+)|(-?[0-9]+))";
        String SYMBOL = "([A-Z_\\|]+)";
        String CLONE_VAL = "(" + NUMBER + "|" + SYMBOL + ")";
        String CLONE_KEY = "(child_stack=|flags=|child_tidptr=|parent_tidptr=)";
        String CLONE_SINGLE = "(" + CLONE_KEY + CLONE_VAL + ")|" + SET;
        Pattern cloneP = Pattern.compile(CLONE_SINGLE);
        List<String> list = this.load("fd/clone2");
        for (String s : list) {
            System.out.println("s = " + s);
            Matcher m = cloneP.matcher(s);
            while (m.find()) {
                System.out.println(m.group());
            }
        }
    }

    private boolean worksCorrectly(String file) {
        List<String> input = this.load(file);
        List<String> solution = this.load(file + ".res");
        int i = 0;
        boolean problem = false;
        this.parser = new SysParser(this.par);
        for (String line : input) {
            SysElement el;
            if (line.length() <= 0 || (el = this.parser.createElement(line)) == null) continue;
            String result = solution.get(i++);
            if (el.toString().equals(result.trim())) continue;
            problem = true;
        }
        if (i < solution.size()) {
            problem = true;
        }
        return !problem;
    }

    private List<String> load(String file) {
        ArrayList<String> list = new ArrayList<String>();
        file = this.prefix + file;
        int counter = 0;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null && counter++ < 100000) {
                if (line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }
}

