/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.Element;
import hitters.multi.HitterPolice;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.tools.LogService;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class SysCallExp {
    public static void main(String[] args) {
        String file = null;
        if (args.length > 0) {
            file = args[0].trim();
        }
        if (file == null) {
            file = "resources/testcase/ff1";
        }
        System.out.println("Benutzte Datei " + file);
        boolean correct = true;
        for (int i = 0; i < 1; ++i) {
            if (SysCallExp.testDatabaseReadSysCall(file, 0.02 * (double)(1 + i), 0.01 * (double)(1 + i))) continue;
            correct = false;
        }
        System.out.println("Probleme gefunden: " + !correct);
        LogService.logDBClose();
    }

    public static boolean testDatabaseReadSysCall(String file, double phi, double epsilon) {
        byte[][] plength = new byte[][]{{0, 4, 8, 16, 24, 32}};
        Parameter myParams = new Parameter(1, plength);
        PartAncHHH fastPA = new PartAncHHH(epsilon, myParams);
        MultiDatabase d = new MultiDatabase(file, myParams);
        d.openRead();
        Vector<Element> data = d.readSystemCalls();
        d.closeRead();
        System.out.println("Start: " + new Date());
        System.out.println("SIZE = " + data.size());
        System.out.println("phi = " + phi + " epsilon = " + epsilon);
        for (int i = 0; i < data.size(); ++i) {
            Element element = data.elementAt(i).clone();
            fastPA.insert(element, 1, true);
        }
        System.out.println("Tupel: = " + fastPA.getTupelCount() + " tupelMax " + fastPA.getMaxTupelCount() + " N= " + fastPA.getN());
        System.out.println("Stop Insert: " + new Date());
        HashMap<Element, MultiHitterInfo> res = fastPA.outputSet(phi);
        System.out.println(" Ergebnis f\u00fcr epsilon = " + epsilon + ", phi = " + phi + ": ");
        for (Element h : res.keySet()) {
            System.out.println(h + " " + res.get(h));
        }
        return HitterPolice.check(file, fastPA, myParams, phi, true);
    }
}

