/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import com.google.common.collect.HashMultiset;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.Element;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiHitterInfo;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import hitters.multi.StreamReader;
import java.util.Date;
import java.util.HashMap;

public class StreamReaderUser {
    public static void main(String[] args) {
        AbstractComplexHHH hitterAlgo;
        int PART_ANC = 4096;
        int FULL_ANC = 8192;
        int count = 0;
        int readCount = 0;
        int algoType = 0;
        double phi = 0.02;
        int delay = 0;
        HashMultiset<Element> hashContainer = HashMultiset.create();
        byte[][] plength = new byte[][]{{0, 4, 8, 16, 24, 32}};
        Parameter par = new Parameter(2 - plength.length, plength);
        if (args.length < 3) {
            System.out.println("Anzahl, Buffersize, Epsilon, AlgoType, Delay  angeben!");
        }
        long lines = Long.parseLong(args[0]);
        int buffersize = Integer.parseInt(args[1]);
        double epsilon = Double.parseDouble(args[2]);
        if (args[3].equals("FA")) {
            algoType = 8192;
        }
        if (args[3].equals("PA")) {
            algoType = 4096;
        }
        if (algoType == 0) {
            throw new RuntimeException("Algorithmus angeben!");
        }
        if (args.length > 4) {
            delay = Integer.parseInt(args[4]);
        }
        System.out.println("Lines = " + lines + ", buffersize = " + buffersize + ", epsilon = " + epsilon + " delay = " + delay);
        switch (algoType) {
            case 8192: {
                System.out.println("algoType = FA");
                hitterAlgo = new FullAncHHH(epsilon, par);
                break;
            }
            case 4096: {
                System.out.println("algoType = PA");
                hitterAlgo = new PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Algorithmus angeben!");
            }
        }
        StreamReader reader = new StreamReader(par);
        System.out.println("Start: " + new Date());
        while ((long)count < lines) {
            if (delay > 0) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            int remaining = Math.min(buffersize, (int)lines - count);
            readCount += reader.readLoop(hashContainer, remaining);
            count += hashContainer.size();
            for (Element e : hashContainer.elementSet()) {
                hitterAlgo.insert(e, hashContainer.count(e), true);
            }
        }
        reader.close();
        System.out.println("Stop: " + new Date());
        System.out.println("readcount= " + readCount);
        System.out.println(" N = " + hitterAlgo.getN());
        HashMap<Element, MultiHitterInfo> res = hitterAlgo.outputSet(phi);
        System.out.println(" Ergebnis f\u00fcr epsilon = " + epsilon + ", phi = " + phi + ": ");
        for (Element h : res.keySet()) {
            System.out.println(h + " " + res.get(h));
        }
    }
}

