/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.AbstractComplexHHH;
import hitters.multi.AlgoType;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.PartAncHHH;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.multi.SysParser;
import hitters.tools.LogService;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiDatabaseTest {
    String prefix = "resources/testcase/MultiDatabase/";

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testReadSystemCalls() {
        DimType[] dims = new DimType[]{DimType.PATH, DimType.RETURN, DimType.CALL};
        int[] caps = new int[]{1, 2, 2};
        SysParameter par = new SysParameter(dims, caps);
        MultiDatabase d = new MultiDatabase(this.prefix + "cut", par);
        d.openRead();
        Vector<Element> elems = d.readSystemCalls();
        List<String> solution = this.load("cut.res");
        int i = 0;
        for (Element e : elems) {
            System.out.println(e);
            System.out.println(solution.get(i) + "\n");
            Assert.assertTrue(e.toString().trim().equals(solution.get(i++).trim()));
        }
        System.out.println("\n\n\n");
        DimType[] dims2 = new DimType[]{DimType.CALL, DimType.PATH};
        int[] caps2 = new int[]{5, 8};
        par = new SysParameter(dims2, caps2);
        d = new MultiDatabase(this.prefix + "cut", par);
        d.openRead();
        elems = d.readSystemCalls();
        solution = this.load("cut2.res");
        i = 0;
        for (Element e : elems) {
            System.out.println(e);
            System.out.println(solution.get(i) + "\n");
            Assert.assertTrue(e.toString().equals(solution.get(i++)));
        }
        System.out.println("\n\n\n");
        DimType[] dims3 = new DimType[]{DimType.CALL, DimType.PATH};
        int[] caps3 = new int[]{4, 3};
        par = new SysParameter(dims3, caps3);
        d = new MultiDatabase(this.prefix + "cut", par);
        d.openRead();
        elems = d.readSystemCalls();
        solution = this.load("cut3.res");
        i = 0;
        for (Element e : elems) {
            System.out.println(e);
            System.out.println(solution.get(i) + "\n");
            Assert.assertTrue(e.toString().equals(solution.get(i++)));
        }
    }

    @Test
    public void testGenEquals() {
        DimType[] dims = new DimType[]{DimType.PATH, DimType.RETURN, DimType.CALL};
        int[] caps = new int[]{5, 2, 2};
        SysParameter par = new SysParameter(dims, caps);
        MultiDatabase d = new MultiDatabase(this.prefix + "eq", par);
        d.openRead();
        Vector<Element> elems = d.readSystemCalls();
        Assert.assertTrue(elems.elementAt(0).equals(elems.elementAt(1)));
        Assert.assertFalse(elems.elementAt(2).equals(elems.elementAt(1)));
        Assert.assertFalse(elems.elementAt(2).equals(elems.elementAt(0)));
        Assert.assertFalse(elems.elementAt(2).equals(elems.elementAt(3)));
        Assert.assertFalse(elems.elementAt(3).equals(elems.elementAt(4)));
        Assert.assertTrue(elems.elementAt(4).equals(elems.elementAt(5)));
        Assert.assertFalse(elems.elementAt(3).equals(elems.elementAt(6)));
        Element el2 = elems.elementAt(2).clone();
        int dim = par.retDim();
        elems.elementAt(2).turnIntoParent(dim);
        elems.elementAt(1).turnIntoParent(dim);
        Assert.assertTrue(elems.elementAt(2).equals(elems.elementAt(1)));
        elems.set(2, el2.clone());
        int[] label = new int[]{5, 1, 0};
        elems.elementAt(2).generalizeTo(label);
        elems.elementAt(3).generalizeTo(label);
        Assert.assertTrue(elems.elementAt(2).equals(elems.elementAt(3)));
        int[] label2 = new int[]{5, 1, 0};
        elems.elementAt(3).generalizeTo(label2);
        elems.elementAt(6).generalizeTo(label2);
        Assert.assertFalse(elems.elementAt(3).equals(elems.elementAt(6)));
        int[] label3 = new int[]{2, 1, 0};
        elems.elementAt(3).generalizeTo(label3);
        elems.elementAt(6).generalizeTo(label3);
        Assert.assertTrue(elems.elementAt(3).equals(elems.elementAt(6)));
    }

    @Test
    public void testReadWriteHitters1() {
        int i;
        DimType[] dims = new DimType[]{DimType.SEQUENCE, DimType.CALL};
        SysParameter par = new SysParameter(dims);
        AlgoType algo = AlgoType.PART_ANC;
        System.out.println(par.toFullString());
        double epsilon = 0.001;
        double phi = 0.01;
        int n = 10;
        String[] files = new String[]{"ff1", "ff6", "gy1", "gy6", "rb1", "rb6", "ge1", "ge2", "tp1", "tp6"};
        ArrayList<HashMap<Element, MultiHitterInfo>> res = new ArrayList<HashMap<Element, MultiHitterInfo>>();
        for (i = 0; i < n; ++i) {
            AbstractComplexHHH hitterAlgo = MultiDatabaseTest.fillApprox("resources/data/" + files[i], par, epsilon, algo);
            res.add(hitterAlgo.outputSet(phi));
            System.out.println(((HashMap)res.get(i)).size());
            MultiDatabase.saveHHH(((HashMap)res.get(i)).keySet(), "tmp/tst.0000" + i, files[i], par, epsilon, phi, algo);
        }
        for (i = 0; i < n; ++i) {
            Set<Element> l1 = MultiDatabase.readHHH("tmp/tst.0000" + i);
            System.out.println(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()));
            Assert.assertTrue(Math.abs(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()) - 1.0) < 1.0E-9);
            Assert.assertTrue(((Object)l1).equals(((HashMap)res.get(i)).keySet()));
        }
    }

    @Test
    public void testReadWriteHitters2() {
        int i;
        DimType[] dims = new DimType[]{DimType.PATH, DimType.RETURN};
        SysParameter par = new SysParameter(dims);
        AlgoType algo = AlgoType.PART_ANC;
        System.out.println(par.toFullString());
        double epsilon = 0.001;
        double phi = 0.01;
        int n = 3;
        String[] files = new String[]{"ff1", "gy6", "rb1"};
        ArrayList<HashMap<Element, MultiHitterInfo>> res = new ArrayList<HashMap<Element, MultiHitterInfo>>();
        for (i = 0; i < n; ++i) {
            AbstractComplexHHH hitterAlgo = MultiDatabaseTest.fillApprox("resources/data/" + files[i], par, epsilon, algo);
            res.add(hitterAlgo.outputSet(phi));
            System.out.println(((HashMap)res.get(i)).size());
            MultiDatabase.saveHHH(((HashMap)res.get(i)).keySet(), "tmp/tst2.0000" + i, files[i], par, epsilon, phi, algo);
        }
        for (i = 0; i < n; ++i) {
            Set<Element> l1 = MultiDatabase.readHHH("tmp/tst2.0000" + i);
            System.out.println(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()));
            Assert.assertTrue(Math.abs(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()) - 1.0) < 1.0E-9);
            Assert.assertTrue(((Object)l1).equals(((HashMap)res.get(i)).keySet()));
        }
    }

    @Test
    public void testReadWriteHitters3() {
        int i;
        DimType[] dims = new DimType[]{DimType.PATH, DimType.SEQUENCE};
        SysParameter par = new SysParameter(dims);
        AlgoType algo = AlgoType.PART_ANC;
        System.out.println(par.toFullString());
        HashSet<String> callSubset = new HashSet<String>();
        callSubset.add("writev");
        par.setUsedCalls(callSubset);
        double epsilon = 0.001;
        double phi = 0.01;
        int n = 3;
        String[] files = new String[]{"ff1", "gy6", "rb1"};
        ArrayList<HashMap<Element, MultiHitterInfo>> res = new ArrayList<HashMap<Element, MultiHitterInfo>>();
        for (i = 0; i < n; ++i) {
            AbstractComplexHHH hitterAlgo = MultiDatabaseTest.fillApprox("resources/data/" + files[i], par, epsilon, algo);
            res.add(hitterAlgo.outputSet(phi));
            System.out.println(((HashMap)res.get(i)).size());
            MultiDatabase.saveHHH(((HashMap)res.get(i)).keySet(), "tmp/tst2.0000" + i, files[i], par, epsilon, phi, algo);
        }
        for (i = 0; i < n; ++i) {
            Set<Element> l1 = MultiDatabase.readHHH("tmp/tst2.0000" + i);
            System.out.println(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()));
            Assert.assertTrue(Math.abs(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()) - 1.0) < 1.0E-9);
            Assert.assertTrue(((Object)l1).equals(((HashMap)res.get(i)).keySet()));
        }
    }

    @Test
    public void testReadWriteHitters4() {
        int i;
        DimType[] dims = new DimType[]{DimType.PATH, DimType.SEQUENCE};
        SysParameter par = new SysParameter(dims);
        AlgoType algo = AlgoType.PART_ANC;
        System.out.println(par.toFullString());
        double epsilon = 0.001;
        double phi = 0.01;
        int n = 3;
        String[] files = new String[]{"xt9-025", "gy6-000", "rb1-002"};
        ArrayList<HashMap<Element, MultiHitterInfo>> res = new ArrayList<HashMap<Element, MultiHitterInfo>>();
        for (i = 0; i < n; ++i) {
            AbstractComplexHHH hitterAlgo = MultiDatabaseTest.fillApprox("/home/fricke/log30/" + files[i], par, epsilon, algo);
            res.add(hitterAlgo.outputSet(phi));
            System.out.println(((HashMap)res.get(i)).size());
            MultiDatabase.saveHHH(((HashMap)res.get(i)).keySet(), "tmp/tst2.0000" + i, files[i], par, epsilon, phi, algo);
        }
        for (i = 0; i < n; ++i) {
            Set<Element> l1 = MultiDatabase.readHHH("tmp/tst2.0000" + i);
            System.out.println("Original: \n\n" + ((HashMap)res.get(i)).keySet());
            System.out.println("Faelschung: \n\n" + l1);
            System.out.println(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()));
            Assert.assertTrue(Math.abs(Evaluation.bgm2(l1, ((HashMap)res.get(i)).keySet()) - 1.0) < 1.0E-9);
            Assert.assertTrue(((Object)l1).equals(((HashMap)res.get(i)).keySet()));
        }
    }

    private List<String> load(String file) {
        ArrayList<String> list = new ArrayList<String>();
        file = this.prefix + file;
        int counter = 0;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null && counter++ < 500000) {
                if (line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private static AbstractComplexHHH fillApprox(String file, SysParameter par, double epsilon, AlgoType algo) {
        AbstractComplexHHH fastPA;
        BufferedReader in = null;
        int counter = 0;
        SysParser parser = new SysParser(par);
        switch (algo) {
            case FULL_ANC: {
                fastPA = new FullAncHHH(epsilon, par);
                break;
            }
            case PART_ANC: {
                fastPA = new PartAncHHH(epsilon, par);
                break;
            }
            default: {
                throw new RuntimeException("Kein Algorithmus gewaehlt");
            }
        }
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                SysElement el;
                if (line.length() <= 0 || (el = parser.createElement(line)) == null) continue;
                fastPA.insert(el, 1);
                ++counter;
            }
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        System.out.println("counter = " + counter);
        System.out.println("ParserCounter = " + parser.getCounter());
        System.out.println((double)counter / (double)parser.getCounter());
        LogService.logDBClose();
        try {
            in.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
        return fastPA;
    }
}

