/*
 * Decompiled with CFR 0.152.
 */
package hitters.test;

import hitters.multi.Element;
import hitters.multi.Exact;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.Parameter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExactTest {
    String dir = "resources/testcase/ExactTest/";
    Parameter myParams;
    MultiDatabase d;
    Exact myExact;
    byte[][] plength = new byte[0][];
    double phi;

    @Before
    public void setUp() throws Exception {
        this.myParams = new Parameter(2 - this.plength.length, this.plength);
        this.myExact = new Exact(this.myParams);
    }

    @Test
    public void testInsert() {
        this.d = new MultiDatabase(this.dir + "Exact1", this.myParams);
        this.d.openRead();
        Vector<Element> data = this.d.readElements();
        for (Element e : data) {
            this.myExact.insert(e, 1, true);
        }
        Assert.assertTrue(this.myExact.getN() == 15);
        Assert.assertTrue(this.myExact.getTupelCount() == 10);
        Assert.assertTrue(this.myExact.getMaxTupelCount() == 10);
        for (Element e : data) {
            this.myExact.insert(e.clone(), 9, true);
        }
        Assert.assertTrue(this.myExact.getN() == 150);
        Assert.assertTrue(this.myExact.getTupelCount() == 10);
        Assert.assertTrue(this.myExact.getMaxTupelCount() == 10);
    }

    @Test
    public void testOutputSet() {
        for (int i = 1; i < 9; ++i) {
            this.load("Exact" + i);
            this.validateCompletely(this.myExact, "Exact" + i, i);
        }
    }

    @Test
    public void testClean1D() {
        Parameter p = new Parameter(1);
        String file = "1D/PA1D";
        for (int i = 1; i < 4; ++i) {
            this.load(file + i, p);
            this.validateCompletely(this.myExact, file + i, i);
        }
    }

    @Test
    public void testClean3D() {
        int i;
        Parameter p = new Parameter(3);
        String file = "3D/PA3D";
        for (i = 1; i < 3; ++i) {
            this.load(file + i, p);
            this.validateCompletely(this.myExact, file + i, i);
        }
        i = 2;
        this.load(file + i, p);
        HashMap<Element, MultiHitterInfo> res = this.myExact.outputSet(this.phi, false);
        HashMap<Element, Integer> abs = this.myExact.dumpf();
        HashMap<Element, Integer> disc = this.myExact.dumpF(this.phi);
        for (Element e : abs.keySet()) {
            System.out.println(e.toShortString() + " (" + abs.get(e) + ")");
        }
        System.out.println();
        for (Element e : disc.keySet()) {
            System.out.println(e.toShortString() + " (" + disc.get(e) + ")");
        }
        System.out.println();
        for (Element e : res.keySet()) {
            System.out.println(e.toShortString() + " " + res.get(e).toShortString());
        }
    }

    @Test
    public void testBuffers() {
        String[] eInt1 = new String[this.myParams.getDimI()];
        String[] eInt2 = (String[])eInt1.clone();
        String[] eInt3 = (String[])eInt2.clone();
        String[] eStr1 = new String[]{"/b", "/1"};
        String[] eStr2 = new String[]{"*", "/1"};
        String[] eStr3 = new String[]{"/b", "*"};
        Element e1 = Element.createElement(eStr1, eInt1, this.myParams);
        Element e2 = Element.createElement(eStr2, eInt2, this.myParams);
        Element e3 = Element.createElement(eStr3, eInt3, this.myParams);
        this.load("ExactBufferFirst");
        HashMap<Element, MultiHitterInfo> res = this.myExact.outputSet(1.0, false);
        res = this.myExact.outputSet(0.9, true);
        res = this.myExact.outputSet(this.phi, true);
        this.validate(res, "ExactBufferFirst", 2);
        HashMap<Element, Integer> f = this.myExact.dumpf();
        HashMap<Element, Integer> F = this.myExact.dumpF(this.phi);
        Assert.assertTrue(f.get(e1) == 2);
        Assert.assertTrue(F.get(e1) == 2);
        Assert.assertTrue(f.get(e2) == 8);
        Assert.assertTrue(F.get(e2) == 2);
        Assert.assertTrue(f.get(e3) == 4);
        Assert.assertTrue(F.get(e3) == 4);
        this.myExact.insert(e1, 1, true);
        res = this.myExact.outputSet(this.phi, false);
        this.validate(res, "ExactBuffer", 99);
        res = this.myExact.outputSet(this.phi, false);
        res = this.myExact.outputSet(this.phi, true);
        res = this.myExact.outputSet(this.phi, true);
        this.validate(res, "ExactBuffer", 99);
        f = this.myExact.dumpf();
        F = this.myExact.dumpF(this.phi);
        Assert.assertTrue(f.get(e1) == 3);
        Assert.assertTrue(F.get(e1) == 3);
        Assert.assertTrue(f.get(e2) == 9);
        Assert.assertTrue(F.get(e2) == 3);
        Assert.assertTrue(f.get(e3) == 5);
        Assert.assertTrue(F.get(e3) == 5);
        this.myExact.insert(e1, 2, true);
        res = this.myExact.outputSet(this.phi, true);
        this.validate(res, "ExactBuffer2", 99);
        res = this.myExact.outputSet(this.phi, false);
        res = this.myExact.outputSet(this.phi, true);
        res = this.myExact.outputSet(this.phi, true);
        this.validate(res, "ExactBuffer2", 99);
        f = this.myExact.dumpf();
        F = this.myExact.dumpF(this.phi);
        Assert.assertTrue(f.get(e1) == 5);
        Assert.assertTrue(F.get(e1) == 5);
        Assert.assertTrue(f.get(e2) == 11);
        Assert.assertTrue(F.get(e2) == null);
        Assert.assertTrue(f.get(e3) == 7);
        Assert.assertTrue(F.get(e3) == 2);
    }

    private void validate(HashMap<Element, MultiHitterInfo> res, String testcase, int nr) {
        String s = null;
        ArrayList<String> list = new ArrayList<String>();
        for (Element e : res.keySet()) {
            list.add(e.toShortString() + " " + res.get(e).toShortString());
        }
        Collections.sort(list);
        List<String> solution = this.loadSolution(this.dir + testcase + ".res");
        Assert.assertTrue("Problem: Testcase " + nr + " Groessen unterschiedl.", list.size() == solution.size());
        for (int i = 0; i < list.size(); ++i) {
            s = (String)list.get(i);
            String pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
            String message = pre + " Berechnet: " + (String)list.get(i);
            message = message + "\nGelesen: " + solution.get(i);
            Assert.assertTrue(message, s.trim().equals(solution.get(i).trim()));
        }
    }

    private void validateCompletely(Exact exactAlgo, String testcase, int nr) {
        String message;
        String pre;
        int i;
        String s = null;
        HashMap<Element, Integer> abs = exactAlgo.dumpf();
        HashMap<Element, Integer> disc = exactAlgo.dumpF(this.phi);
        HashMap<Element, MultiHitterInfo> res = exactAlgo.outputSet(this.phi);
        ArrayList<String> listf = new ArrayList<String>();
        ArrayList<String> listF = new ArrayList<String>();
        ArrayList<String> listOut = new ArrayList<String>();
        List<String> solutionf = this.loadf(this.dir + testcase + ".res");
        List<String> solutionF = this.loadF(this.dir + testcase + ".res");
        List<String> solutionOut = this.loadOut(this.dir + testcase + ".res");
        for (Element e : abs.keySet()) {
            listf.add(e.toShortString() + " (" + abs.get(e) + ")");
        }
        for (Element e : disc.keySet()) {
            listF.add(e.toShortString() + " (" + disc.get(e) + ")");
        }
        for (Element e : res.keySet()) {
            listOut.add(e.toShortString() + " " + ((MultiHitterInfo)res.get(e)).toShortString());
        }
        Collections.sort(listf);
        Collections.sort(listF);
        Collections.sort(listOut);
        Assert.assertTrue("Problem: Testcase " + nr + " Groessen " + "unterschiedl.", listf.size() == solutionf.size());
        Assert.assertTrue("Problem: Testcase " + nr + " Groessen " + "unterschiedl.", listF.size() == solutionF.size());
        Assert.assertTrue("Problem: Testcase " + nr + " Groessen " + "unterschiedl.", listOut.size() == solutionOut.size());
        for (i = 0; i < listf.size(); ++i) {
            s = (String)listf.get(i);
            pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
            message = pre + " Berechnet fuer f: " + (String)listf.get(i);
            message = message + "\nGelesen: " + solutionf.get(i);
            Assert.assertTrue(message, s.trim().equals(solutionf.get(i).trim()));
        }
        for (i = 0; i < listF.size(); ++i) {
            s = (String)listF.get(i);
            pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
            message = pre + " Berechnet fuer f: " + (String)listF.get(i);
            message = message + "\nGelesen: " + solutionF.get(i);
            Assert.assertTrue(message, s.trim().equals(solutionF.get(i).trim()));
        }
        for (i = 0; i < listOut.size(); ++i) {
            s = (String)listOut.get(i);
            pre = "Problem: Testcase " + nr + " Zeile " + i + ": ";
            message = pre + " Berechnet fuer f: " + (String)listOut.get(i);
            message = message + "\nGelesen: " + solutionOut.get(i);
            Assert.assertTrue(message, s.trim().equals(solutionOut.get(i).trim()));
        }
    }

    private List<String> loadSolution(String file) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 2 || line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(list);
        return list;
    }

    private List<String> loadf(String file) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null && !line.startsWith("# F")) {
                if (line.length() <= 2 || line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(list);
        return list;
    }

    private List<String> loadF(String file) {
        ArrayList<String> list = new ArrayList<String>();
        boolean read = false;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null && !line.startsWith("# out")) {
                if (line.startsWith("# F")) {
                    read = true;
                }
                if (!read || line.length() <= 2 || line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(list);
        return list;
    }

    private List<String> loadOut(String file) {
        ArrayList<String> list = new ArrayList<String>();
        boolean read = false;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("# out")) {
                    read = true;
                }
                if (!read || line.length() <= 2 || line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(list);
        return list;
    }

    private void load(String testcase) {
        this.load(testcase, this.myParams);
    }

    private void load(String testcase, Parameter p) {
        this.d = new MultiDatabase(this.dir + testcase, p);
        this.d.openRead();
        Vector<Element> data = this.d.readElements();
        this.myExact = new Exact(p);
        for (Element e : data) {
            this.myExact.insert(e, 1, true);
        }
        this.phi = this.d.getPhi();
    }
}

