/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.tools.Utils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class Weights {
    String filename;
    HashMap<String, Integer> countMap = new HashMap();
    HashMap<String, Double> expMap = new HashMap();
    int sum = 0;

    public Weights(String file, double exp) throws FileNotFoundException {
        int i;
        String[] places;
        InputStreamReader reader = null;
        InputStream str = null;
        for (String place : places = Utils.resourceLocationsJar()) {
            str = Weights.class.getResourceAsStream(place + file);
            if (str == null) continue;
            reader = new InputStreamReader(str);
            break;
        }
        if (str == null) {
            String[] otherPlaces;
            URL url = Weights.class.getClassLoader().getResource(".");
            String p = url.getPath();
            for (String place : otherPlaces = Utils.resourceLocationsFiles()) {
                try {
                    reader = new FileReader(p + place + file);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (reader != null) break;
            }
        }
        this.filename = file;
        ArrayList<Integer> counts = new ArrayList<Integer>();
        ArrayList<String> names = new ArrayList<String>();
        int n = 0;
        double expSum = 0.0;
        try {
            String line;
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                if (line.length() <= 2 || line.startsWith("#")) continue;
                String[] parts = line.split("\\s");
                names.add(parts[0]);
                counts.add(Integer.parseInt(parts[1]));
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Integer c : counts) {
            n += c.intValue();
        }
        this.sum = n;
        double[] weightsTmp = new double[counts.size()];
        for (i = 0; i < counts.size(); ++i) {
            weightsTmp[i] = Math.pow((double)n / (double)((Integer)counts.get(i)).intValue(), exp);
            expSum += weightsTmp[i] * (double)((Integer)counts.get(i)).intValue();
        }
        for (i = 0; i < counts.size(); ++i) {
            this.countMap.put((String)names.get(i), (Integer)counts.get(i));
            this.expMap.put((String)names.get(i), weightsTmp[i] * ((double)n / expSum));
        }
    }

    public double getWeight(String call) {
        return this.expMap.get(call);
    }

    public double getFreq(String call) {
        if (this.countMap.get(call) == null) {
            return 0.0;
        }
        return (double)this.countMap.get(call).intValue() / (double)this.sum;
    }

    public int getCount(String call) {
        if (this.countMap.get(call) == null) {
            return 0;
        }
        return this.countMap.get(call);
    }
}

