/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.tools.Utils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Taxonomy {
    private static final int maxWidth = 40;
    private HashMap<String, String> map = new HashMap();
    private HashMap<String, String> callMap = new HashMap();
    private HashMap<String, Integer> call2flat = new HashMap();
    private HashMap<Integer, String> flat2call = new HashMap();
    private TaxNode root = new TaxNode("*");
    private int size = 0;

    public static void main(String[] args) {
        int[] code = new int[20];
        Taxonomy tax = null;
        try {
            tax = new Taxonomy("Taxonomy3");
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("Code = " + tax.getCode("/FILESYS/open"));
        System.out.println("Map = " + tax.map);
        System.exit(0);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 40; ++j) {
                for (int k = 0; k < 40; ++k) {
                    for (int l = 0; l < 40; ++l) {
                        code[1] = i;
                        code[2] = j;
                        code[3] = k;
                        code[4] = l;
                        String label = tax.getPathlabel(code);
                        if (label == null) continue;
                        System.out.print("\n" + label + " -> ");
                        for (int m = 1; m < 5; ++m) {
                            System.out.print(" /" + code[m]);
                        }
                    }
                }
            }
        }
    }

    public Taxonomy(String file) throws FileNotFoundException {
        String[] places;
        InputStreamReader reader = null;
        InputStream str = null;
        for (String place : places = Utils.resourceLocationsJar()) {
            str = Taxonomy.class.getResourceAsStream(place + file);
            if (str == null) continue;
            reader = new InputStreamReader(str);
            break;
        }
        if (str == null) {
            String[] otherPlaces;
            URL url = Taxonomy.class.getClassLoader().getResource(".");
            String p = url.getPath();
            for (String place : otherPlaces = Utils.resourceLocationsFiles()) {
                try {
                    reader = new FileReader(p + place + file);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (reader != null) break;
            }
        }
        String[] components = new String[20];
        Pattern callnameP = Pattern.compile("/[a-z_][^/$]+");
        Pattern groupAndCallP = Pattern.compile("/[A-Z_][^/$]+/[a-z_][^/$]+");
        int[] code = new int[20];
        int level = 0;
        int flatCounter = 0;
        this.deleteSuffix(code, components, level);
        try {
            String line;
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                if (line.length() <= 2 || line.startsWith("#")) continue;
                if (this.getLevel(line) == 2) {
                    this.flat2call.put(++flatCounter, line.substring(1).trim());
                    this.call2flat.put(line.substring(1).trim(), flatCounter);
                }
                if (this.getLevel(line) <= level) {
                    this.add(code, components);
                    level = this.getLevel(line);
                    this.deleteSuffix(code, components, level);
                    components[level] = this.getComponent(line);
                    int n = level;
                    code[n] = code[n] + 1;
                    continue;
                }
                components[++level] = this.getComponent(line);
                int n = level;
                code[n] = code[n] + 1;
            }
            if (level > 0) {
                this.add(code, components);
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 40; ++j) {
                String name;
                code[1] = i;
                code[2] = j;
                String label = this.getPathlabel(code);
                if (label == null) continue;
                String codeString = "/" + code[1] + "/" + code[2];
                Matcher m = groupAndCallP.matcher(label);
                if (m.find()) {
                    name = m.group();
                    this.map.put(name, codeString);
                }
                if (!(m = callnameP.matcher(label)).find(1)) continue;
                name = m.group();
                this.callMap.put(name.substring(1), codeString);
            }
        }
    }

    public Set<String> getAllCalls() {
        return this.callMap.keySet();
    }

    public String getCode(String call) {
        return this.map.get(call);
    }

    public String code4Call(String call) {
        return this.callMap.get(call);
    }

    public void add(int[] call, String[] components) {
        this.trav(call, components);
        ++this.size;
    }

    public String getPathlabel(int[] call) {
        return this.trav(call, null);
    }

    public String getPathlabel(String s) {
        String[] parts = s.split("/");
        int len = parts.length;
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            ints[i] = parts[i].equals("") ? 0 : Integer.parseInt(parts[i]);
        }
        return this.getPathlabel(ints);
    }

    public String flat2call(int flat) {
        String s = this.flat2call.get(flat);
        return s;
    }

    public int call2flat(String call) {
        Integer integer = this.call2flat.get(call);
        int i = integer == null ? -1 : integer;
        return i;
    }

    private String trav(int[] call, String[] components) {
        if (call == null) {
            throw new NullPointerException();
        }
        if (components != null && components[1] == "") {
            throw new RuntimeException("Taxonomie: Versuch * einzufuegen");
        }
        if (call[1] == 0) {
            for (int i = 1; i < call.length; ++i) {
                if (call[i] == 0) continue;
                return null;
            }
            return "*";
        }
        TaxNode node = this.root;
        String pathlabel = "";
        for (int i = 1; i < call.length; ++i) {
            int index = call[i];
            if (index < 0 || index >= 40) {
                throw new RuntimeException("Taxonomie: Zu viele Kinder erwartet. index=" + index + "maxWidth= " + 40);
            }
            if (index == 0) {
                for (int j = i; j < call.length; ++j) {
                    if (call[j] == 0) continue;
                    return null;
                }
                break;
            }
            if (node.children[index] == null) {
                if (components != null) {
                    node.children[index] = new TaxNode(components[i]);
                } else {
                    for (int k = i; k < call.length; ++k) {
                        if (call[k] == 0) continue;
                        pathlabel = pathlabel + "/" + call[k];
                    }
                    return pathlabel;
                }
            }
            node = node.children[index];
            pathlabel = pathlabel + "/" + node.label;
        }
        return pathlabel;
    }

    public int[] pathlabel2code(String pathlabel) {
        String[] comps = pathlabel.split("/");
        int[] call = new int[comps.length];
        TaxNode node = this.root;
        for (int i = 1; i < call.length; ++i) {
            for (int j = 1; j < node.children.length && node.children[j] != null; ++j) {
                if (!comps[i].trim().equals(node.children[j].label)) continue;
                call[i] = j;
            }
            if (call[i] < 1) {
                call[i] = Integer.parseInt(comps[i]);
            }
            node = node.children[call[i]];
        }
        return call;
    }

    public int size() {
        return this.size;
    }

    private void deleteSuffix(int[] code, String[] components, int level) {
        for (int i = level + 1; i < 20; ++i) {
            code[i] = 0;
            components[i] = "";
        }
    }

    private String getComponent(String line) {
        int pos = line.lastIndexOf("-");
        return line.substring(pos + 1).trim();
    }

    private int getLevel(String line) {
        int pos = line.lastIndexOf("-");
        for (int i = 0; i < pos; ++i) {
            if (line.charAt(i) == '-') continue;
            throw new RuntimeException(" Minuszeichen fehlen: getLevel:" + line);
        }
        return pos + 2;
    }

    private class TaxNode {
        public TaxNode[] children = new TaxNode[40];
        public String label;

        public TaxNode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

