/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.Element;
import hitters.multi.ProcTable;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.tools.LogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SysParser {
    public static final int MAXDEPTH = 20;
    private String STRING = "(\"((?<=\\\\)\"|[^\"])*\")";
    private String STRINGTRAIL = "(" + this.STRING + "(\\.\\.\\.)?)";
    private String NUMBER = "((-?0x[0-9a-f]+)|(-?[0-9]+))";
    private String RETVAL = "(" + this.NUMBER + "|\\?)";
    private String ERRCO = "(\\s[A-Z_]+)?";
    private String OPTBR = "(\\([^\\(\\)]*\\))?";
    private String OPTPART = "((" + this.ERRCO + "\\s" + this.OPTBR + ")?)";
    private String TAIL = "(?<=(\\s=\\s))" + this.RETVAL + this.OPTPART + "$";
    private String OCT = "[0-7]+";
    private String SYMBOL = "([A-Z_\\|]+)";
    private String EXT_SYMBOL = "(" + this.SYMBOL + "\\|" + this.OCT + ")|(" + this.SYMBOL + ")";
    private String KEY = "[a-z_]+";
    private String KEYVAL = this.KEY + "=(" + this.EXT_SYMBOL + "|" + this.NUMBER + ")";
    String FLAT_SET = "(\\{([^\\[\\]\\{\\}\\\"]|" + this.STRINGTRAIL + ")*\\})";
    String FLAT_ARRAY = "(\\[([^\\[\\]\\{\\}\\\"]|" + this.STRINGTRAIL + ")*\\])";
    String SET = "(\\{([^\\}\\{]|" + this.STRINGTRAIL + "|" + this.FLAT_SET + "|" + this.FLAT_ARRAY + ")*\\})";
    String ARRAY = "(\\[([^\\[\\]\\{\\}\\\"]|" + this.STRINGTRAIL + "|" + this.FLAT_SET + "|" + this.FLAT_ARRAY + ")*\\])";
    private String COM = "(/\\*[^\\*]*\\*/)";
    private String SINGLE = "(" + this.STRINGTRAIL + "|" + this.NUMBER + "|" + this.SET + "|" + this.ARRAY + "|" + this.SYMBOL + ")";
    private String CLONE_VAL = "(" + this.NUMBER + "|" + this.SYMBOL + ")";
    private String CLONE_KEY = "(child_stack=|flags=|child_tidptr=|parent_tidptr=)";
    private String CLONE_SINGLE = "(" + this.CLONE_KEY + this.CLONE_VAL + ")|" + this.SET;
    private String EXT_SINGLE = "(" + this.STRINGTRAIL + "|" + this.NUMBER + "|" + this.SET + "|" + this.ARRAY + "|" + this.SYMBOL + "|" + this.COM + ")";
    private String EXT_SINGLE_KV = this.STRINGTRAIL + "|" + this.NUMBER + "|" + this.SET + "|" + this.ARRAY + "|" + this.SYMBOL + "|" + this.KEYVAL;
    private Pattern singleP = Pattern.compile(this.SINGLE);
    private Pattern extSingleP = Pattern.compile(this.EXT_SINGLE);
    private Pattern extSingleKVP = Pattern.compile(this.EXT_SINGLE_KV);
    private Pattern cloneP = Pattern.compile(this.CLONE_SINGLE);
    private Pattern unfinishedP = Pattern.compile("<unfinished\\s\\.\\.\\.>[\\s]*$");
    private Pattern resumedP = Pattern.compile("<\\.\\.\\.\\s[a-z_][a-z_0-9]+\\sresumed>");
    private Pattern sigP = Pattern.compile("^[0-9]+[\\s]+---[\\s]+");
    private Pattern killP = Pattern.compile("^[0-9]+[\\s]+\\+\\+\\+[\\s]+");
    private Pattern pidP = Pattern.compile("^[0-9]+");
    private Pattern tailP = Pattern.compile(this.TAIL);
    private Pattern retP = Pattern.compile(this.RETVAL);
    private SysParameter myParams;
    private HashMap<String, ProcTable> procTables = new HashMap();
    private String currentPid = null;
    private String currentReturnValue = null;
    int counter = 0;

    public SysParser(SysParameter myParams) {
        this.myParams = myParams;
    }

    public SysElement createElement(String line) {
        try {
            if (line.startsWith("#")) {
                System.out.println("\n\n");
                return null;
            }
            Matcher m = this.pidP.matcher(line);
            if (!m.find()) {
                throw new RuntimeException("Strace bitte mit -f laufen lassen, Zeilen muessen PIDs enthalten.");
            }
            m = this.sigP.matcher(line);
            if (m.find()) {
                return null;
            }
            m = this.killP.matcher(line);
            if (m.find()) {
                return null;
            }
            m = this.unfinishedP.matcher(line);
            if (m.find()) {
                this.storeUnfinished(line);
                return null;
            }
            m = this.resumedP.matcher(line);
            if (m.find()) {
                line = this.mergeResumed(line);
            }
            if (line == null) {
                return null;
            }
            String call = this.getCallName(line);
            ++this.counter;
            if (!this.isUsed(call)) {
                return null;
            }
            this.currentPid = this.getPid(line);
            this.currentReturnValue = this.getReturnValue(line);
            if (this.currentReturnValue == null) {
                return null;
            }
            this.updateSequence(this.currentPid, call);
            if (call.equals("open")) {
                return this.getOpen(line);
            }
            if (call.equals("read")) {
                return this.getRead(line);
            }
            if (call.equals("write")) {
                return this.getWrite(line);
            }
            if (call.equals("mmap2")) {
                return this.getMmap2(line);
            }
            if (call.equals("munmap")) {
                return this.getMunmap(line);
            }
            if (call.equals("lseek")) {
                return this.getLseek(line);
            }
            if (call.equals("_llseek")) {
                return this.get_llseek(line);
            }
            if (call.equals("select")) {
                return this.getSelect(line);
            }
            if (call.equals("fstat64")) {
                return this.getStat64(line, "fstat64");
            }
            if (call.equals("stat64")) {
                return this.getStat64(line, "stat64");
            }
            if (call.equals("lstat64")) {
                return this.getStat64(line, "lstat64");
            }
            if (call.equals("fstat")) {
                return this.getStat64(line, "fstat");
            }
            if (call.equals("stat")) {
                return this.getStat64(line, "stat");
            }
            if (call.equals("lstat")) {
                return this.getStat64(line, "lstat");
            }
            if (call.equals("writev")) {
                return this.getWritev(line);
            }
            if (call.equals("access")) {
                return this.getAccess(line);
            }
            if (call.equals("fcntl64")) {
                return this.getFcntl64(line);
            }
            if (call.equals("fcntl")) {
                return this.getFcntl64(line);
            }
            if (call.equals("dup")) {
                return this.getDupfd(line, "dup");
            }
            if (call.equals("dup2")) {
                return this.getDupfd(line, "dup2");
            }
            if (call.equals("dup3")) {
                return this.getDupfd(line, "dup3");
            }
            if (call.equals("close")) {
                return this.getClose(line);
            }
            if (call.equals("getdents")) {
                return this.getDents(line);
            }
            if (call.equals("getdents64")) {
                return this.getDents(line);
            }
            if (call.equals("clock_gettime")) {
                return this.getClock_gettime(line);
            }
            if (call.equals("mprotect")) {
                return this.getMprotect(line);
            }
            if (call.equals("futex")) {
                return this.getFutex(line);
            }
            if (call.equals("poll")) {
                return this.getPoll(line);
            }
            if (call.equals("recvmsg")) {
                return this.getRecvUni(line, "recvmsg");
            }
            if (call.equals("recv")) {
                return this.getRecvUni(line, "recv");
            }
            if (call.equals("send")) {
                return this.getSendUni(line, "send");
            }
            if (call.equals("sendmsg")) {
                return this.getSendUni(line, "sendmsg");
            }
            if (call.equals("sendto")) {
                return this.getSendUni(line, "sendto");
            }
            if (call.equals("rt_sigaction")) {
                return this.getRt_sigaction(line);
            }
            if (call.equals("pipe")) {
                return this.getPipe(line, "pipe");
            }
            if (call.equals("pipe2")) {
                return this.getPipe(line, "pipe2");
            }
            if (call.equals("socket")) {
                return this.getSocket(line);
            }
            if (call.equals("inotify_init")) {
                return this.getInotify_init(line);
            }
            if (call.equals("inotify_init1")) {
                return this.getInotify_init(line);
            }
            if (call.equals("accept")) {
                return this.getAccept(line, "accept");
            }
            if (call.equals("accept4")) {
                return this.getAccept(line, "accept4");
            }
            if (call.equals("execve")) {
                return this.getExecve(line);
            }
            if (call.equals("clone")) {
                return this.getClone(line);
            }
            if (call.equals("fork")) {
                return this.getFork(line, "fork");
            }
            if (call.equals("vfork")) {
                return this.getFork(line, "vfork");
            }
            if (call.equals("unshare")) {
                return this.getUnshare(line);
            }
            if (call.equals("nanosleep")) {
                return this.getNanosleep(line);
            }
            if (call.equals("ioctl")) {
                return this.getSimpleWFd(line, "/DEVICE/ioctl");
            }
            if (call.equals("readlink")) {
                return this.getSimpleWPath(line, "/INFO/readlink");
            }
            if (call.equals("gettimeofday")) {
                return this.getSimple("/INFO/gettimeofday");
            }
            if (call.equals("time")) {
                return this.getSimple("/INFO/time");
            }
            if (call.equals("uname")) {
                return this.getSimple("/INFO/uname");
            }
            if (call.equals("brk")) {
                return this.getSimple("/PROCMEM/brk");
            }
        }
        catch (Exception e) {
            LogService.logF("# Problem beim Parsen der Systemcalls: line = " + line + " fuehrt zu Fehler:  " + e.toString() + " ");
        }
        LogService.logF(line);
        return null;
    }

    public int getCounter() {
        return this.counter;
    }

    private SysElement getOpen(String s) {
        List<String> args = this.getPars(s);
        boolean cloExec = false;
        int ret = Integer.parseInt(args.get(0));
        String file = args.get(1);
        if (args.get(2).contains("CLOEXEC")) {
            cloExec = true;
        }
        int intFlag = -1;
        if (args.get(2).contains("O_RDONLY")) {
            intFlag = 1;
        }
        if (args.get(2).contains("O_WRONLY")) {
            intFlag = 2;
        }
        if (args.get(2).contains("O_RDWR")) {
            intFlag = 3;
        }
        if (ret > -1) {
            this.putFile(this.getPid(s), ret, file, cloExec);
        }
        if (intFlag < 0) {
            throw new RuntimeException("IntFlag nicht gefunden + s");
        }
        return this.fixElement(file, "/FILESYS/open", intFlag + "");
    }

    private SysElement getWritev(String s) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        int size = 1;
        if (Integer.parseInt(args.get(3)) > 3) {
            size = 2;
        }
        return this.fixElement(file, "/FILESYS/writev", size + "");
    }

    private SysElement getReadWrite(String s, boolean write) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        int size = 1;
        if (Integer.parseInt(args.get(3)) > 1024) {
            size = 3;
        } else if (Integer.parseInt(args.get(3)) > 128) {
            size = 2;
        }
        String call = write ? "/FILESYS/write" : "/FILESYS/read";
        return this.fixElement(file, call, size + "");
    }

    private SysElement getRead(String s) {
        return this.getReadWrite(s, false);
    }

    private SysElement getWrite(String s) {
        return this.getReadWrite(s, true);
    }

    private SysElement getClose(String s) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        this.removeFile(this.getPid(s), args.get(1));
        return this.fixElement(file, "/FILESYS/close", "");
    }

    private SysElement getLseek(String s) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        int amount = 2;
        int seek = 0;
        if (Integer.parseInt(args.get(2)) > 512) {
            amount = 3;
        }
        if (Integer.parseInt(args.get(2)) < 0) {
            amount = 1;
        }
        if (args.get(3).contains("SEEK_SET")) {
            seek = 1;
        }
        if (args.get(3).contains("SEEK_CUR")) {
            seek = 2;
        }
        if (args.get(3).contains("SEEK_END")) {
            seek = 3;
        }
        String code = seek + "/" + amount;
        return this.fixElement(file, "/FILESYS/_llseek", code);
    }

    private SysElement get_llseek(String s) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        int amount = 2;
        int seek = 0;
        if (Integer.parseInt(args.get(2)) > 512) {
            amount = 3;
        }
        if (Integer.parseInt(args.get(2)) < 0) {
            amount = 1;
        }
        if (args.get(4).contains("SEEK_SET")) {
            seek = 1;
        }
        if (args.get(4).contains("SEEK_CUR")) {
            seek = 2;
        }
        if (args.get(4).contains("SEEK_END")) {
            seek = 3;
        }
        String code = seek + "/" + amount;
        return this.fixElement(file, "/FILESYS/_llseek", code);
    }

    private SysElement getFcntl64(String s) {
        int ret;
        List<String> args = this.getPars(s);
        String fd = args.get(1);
        String file = this.getFile(this.getPid(s), fd);
        int cat = 7;
        int val = 0;
        if (args.get(2).equals("F_DUPFD")) {
            cat = 1;
            val = 1;
        }
        if (args.get(2).equals("F_DUPFD_CLOEXEC")) {
            cat = 1;
            val = 2;
        }
        if (cat == 1 && (ret = Integer.parseInt(args.get(0))) > -1) {
            if (val == 2) {
                this.putFile(this.getPid(s), ret, file, true);
            } else {
                this.putFile(this.getPid(s), ret, file, false);
            }
        }
        if (args.get(2).equals("F_GETFD")) {
            cat = 2;
            val = 1;
        }
        if (args.get(2).equals("F_SETFD")) {
            cat = 2;
            val = 2;
            ret = Integer.parseInt(args.get(0));
            if (ret > -1) {
                if (args.get(3).contains("CLOEXEC")) {
                    this.setCloseOnExec(this.getPid(s), fd, true);
                } else {
                    this.setCloseOnExec(this.getPid(s), fd, false);
                }
            }
        }
        if (args.get(2).equals("F_GETFL")) {
            cat = 3;
            val = 1;
        }
        if (args.get(2).equals("F_SETFL")) {
            cat = 3;
            val = 2;
        }
        if (args.get(2).equals("F_GETLK")) {
            cat = 4;
            val = 1;
        }
        if (args.get(2).equals("F_SETLKW")) {
            cat = 4;
            val = 2;
        }
        if (args.get(2).equals("F_SETLK")) {
            cat = 4;
            val = 3;
        }
        if (args.get(2).equals("F_GETOWN")) {
            cat = 5;
            val = 1;
        }
        if (args.get(2).equals("F_SETOWN")) {
            cat = 5;
            val = 2;
        }
        if (args.get(2).equals("F_GETSIG")) {
            cat = 5;
            val = 3;
        }
        if (args.get(2).equals("F_SETSIG")) {
            cat = 5;
            val = 4;
        }
        if (args.get(2).equals("F_GETLEASE")) {
            cat = 6;
            val = 1;
        }
        if (args.get(2).equals("F_SETLEASE")) {
            cat = 6;
            val = 2;
        }
        String code = cat + "/" + val;
        return this.fixElement(file, "/FILESYS/fcntl64", code);
    }

    private SysElement getDupfd(String s, String name) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        int ret = Integer.parseInt(args.get(0));
        String code = "";
        if (name.equals("dup3")) {
            code = args.get(3).contains("CLOEXEC") ? "1" : "2";
        }
        if (ret > -1) {
            if (code.equals("1")) {
                this.putFile(this.getPid(s), ret, file, true);
            } else {
                this.putFile(this.getPid(s), ret, file, false);
            }
        }
        return this.fixElement(file, "/FILESYS/" + name, code);
    }

    private SysElement getStat64(String s, String name) {
        List<String> args = this.getPars(s);
        List<String> struct = this.splitSet(args.get(2));
        String file = name.contains("fstat") ? this.getFile(this.getPid(s), args.get(1)) : args.get(1);
        int mode = 1;
        if (struct.size() > 0) {
            if (struct.get(0).contains("S_IFREG")) {
                mode = 2;
            }
            if (struct.get(0).contains("S_IFIFO")) {
                mode = 3;
            }
            if (struct.get(0).contains("S_IFCHR")) {
                mode = 4;
            }
            if (struct.get(0).contains("S_IFSOCK")) {
                mode = 5;
            }
            if (struct.get(0).contains("S_IFDIR")) {
                mode = 6;
            }
            if (struct.get(0).contains("S_IFLNK")) {
                mode = 7;
            }
        }
        return this.fixElement(file, "/INFO/" + name, mode + "");
    }

    private SysElement getAccess(String s) {
        List<String> args = this.getPars(s);
        String file = args.get(1);
        int mode = 2;
        int read = 2;
        int write = 2;
        int exec = 2;
        if (args.get(2).contains("F_OK")) {
            mode = 1;
            read = 0;
            write = 0;
            exec = 0;
        } else {
            if (args.get(2).contains("R_OK")) {
                read = 1;
            }
            if (args.get(2).contains("W_OK")) {
                write = 1;
            }
            if (args.get(2).contains("X_OK")) {
                exec = 1;
            }
        }
        String code = mode + "/" + read + "/" + write + "/" + exec;
        return this.fixElement(file, "/INFO/access", code);
    }

    private SysElement getDents(String s) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        int size = 1;
        if (this.splitComment(args.get(2)) > 0) {
            size = 2;
        }
        if (this.splitComment(args.get(2)) > 10) {
            size = 3;
        }
        return this.fixElement(file, "/INFO/getdents", size + "");
    }

    private SysElement getSelect(String s) {
        List<String> args = this.getPars(s);
        int read = 1;
        int write = 1;
        int exceptions = 1;
        if (args.get(2).equals("NULL") || args.get(2).equals("[]")) {
            read = 2;
        }
        if (args.get(3).equals("NULL") || args.get(3).equals("[]")) {
            write = 2;
        }
        if (args.get(4).equals("NULL") || args.get(4).equals("[]")) {
            exceptions = 2;
        }
        String code = read + "/" + write + "/" + exceptions;
        return this.fixElement("*", "/INFO/select", code);
    }

    private SysElement getPoll(String s) {
        List<String> args = this.getPars(s);
        int time = 2;
        int single = 0;
        time = Integer.parseInt(args.get(3)) > 0 ? 1 : 2;
        single = Integer.parseInt(args.get(2)) == 1 ? 1 : 2;
        String code = time + "/" + single;
        return this.fixElement("*", "/INFO/poll", code);
    }

    private SysElement getInotify_init(String s) {
        List<String> args = this.getPars(s);
        String file = "*";
        int ret = Integer.parseInt(args.get(0));
        if (ret > -1) {
            file = "\"/Inotify\"";
            if (args.size() > 1 && args.get(1).contains("CLOEXEC")) {
                this.putFile(this.getPid(s), ret, file, true);
            } else {
                this.putFile(this.getPid(s), ret, file, false);
            }
        }
        return this.fixElement(file, "/INFO/inotify_init", "");
    }

    private SysElement getClock_gettime(String s) {
        List<String> args = this.getPars(s);
        int clockId = 0;
        if (args.get(1).contains("CLOCK_REALTIME")) {
            clockId = 1;
        }
        if (args.get(1).contains("CLOCK_MONOTONIC")) {
            clockId = 2;
        }
        if (args.get(1).contains("CLOCK_PROCESS_CPUTIME_ID")) {
            clockId = 3;
        }
        if (args.get(1).contains("CLOCK_THREAD_CPUTIME_ID")) {
            clockId = 4;
        }
        return this.fixElement("*", "/INFO/clock_gettime", clockId + "");
    }

    private SysElement getRecvUni(String s, String name) {
        List<String> args = this.getPars(s);
        int flags = 2;
        int position = name.contains("recvmsg") ? 3 : 4;
        if (args.get(position).contains("MSG_PEEK")) {
            flags = 1;
        }
        return this.fixElement("*", "/COMMUNICATION/" + name, flags + "");
    }

    private SysElement getSendUni(String s, String name) {
        List<String> args = this.getPars(s);
        int flags = 2;
        int position = name.contains("sendmsg") ? 3 : 4;
        if (args.get(position).contains("MSG_NOSIGNAL")) {
            flags = 1;
        }
        return this.fixElement("*", "/COMMUNICATION/" + name, flags + "");
    }

    private SysElement getRt_sigaction(String s) {
        List<String> args = this.getPars(s);
        int action = 3;
        int sigCategory = 1;
        int sig = 0;
        if (args.get(2).equals("{SIG_DFL}")) {
            action = 1;
        }
        if (args.get(2).equals("{SIG_IGN}")) {
            action = 2;
        }
        if (args.get(1).contains("SIGCONT")) {
            sigCategory = 2;
            sig = 0;
        }
        if (args.get(1).contains("SIGCHLD")) {
            sigCategory = 3;
            sig = 0;
        }
        if (args.get(1).contains("SIGHUP")) {
            sigCategory = 4;
            sig = 1;
        }
        if (args.get(1).contains("SIGINT")) {
            sigCategory = 4;
            sig = 2;
        }
        if (args.get(1).contains("SIGKILL")) {
            sigCategory = 4;
            sig = 3;
        }
        if (args.get(1).contains("SIGPIPE")) {
            sigCategory = 4;
            sig = 4;
        }
        if (args.get(1).contains("SIGALRM")) {
            sigCategory = 4;
            sig = 5;
        }
        if (args.get(1).contains("SIGTERM")) {
            sigCategory = 4;
            sig = 6;
        }
        if (args.get(1).contains("SIGUSR1")) {
            sigCategory = 4;
            sig = 7;
        }
        if (args.get(1).contains("SIGUSR2")) {
            sigCategory = 4;
            sig = 8;
        }
        if (args.get(1).contains("SIGQUIT")) {
            sigCategory = 5;
            sig = 1;
        }
        if (args.get(1).contains("SIGILL")) {
            sigCategory = 5;
            sig = 2;
        }
        if (args.get(1).contains("SIGABRT")) {
            sigCategory = 5;
            sig = 3;
        }
        if (args.get(1).contains("SIGFPE")) {
            sigCategory = 5;
            sig = 4;
        }
        if (args.get(1).contains("SIGSEGV")) {
            sigCategory = 5;
            sig = 5;
        }
        if (args.get(1).contains("SIGSTOP")) {
            sigCategory = 6;
            sig = 1;
        }
        if (args.get(1).contains("SIGTSTP")) {
            sigCategory = 6;
            sig = 2;
        }
        if (args.get(1).contains("SIGTTIN")) {
            sigCategory = 6;
            sig = 3;
        }
        if (args.get(1).contains("SIGTTOU")) {
            sigCategory = 6;
            sig = 4;
        }
        String code = action + "/" + sigCategory + "/" + sig;
        return this.fixElement("*", "/COMMUNICATION/rt_sigaction", code);
    }

    private SysElement getPipe(String s, String name) {
        List<String> args = this.getPars(s);
        String fileR = "*";
        int ret = Integer.parseInt(args.get(0));
        List<String> fileDescr = this.splitArray(args.get(1));
        int fdR = Integer.parseInt(fileDescr.get(0));
        int fdW = Integer.parseInt(fileDescr.get(1));
        int cloExec = 0;
        if (name.equals("pipe2")) {
            cloExec = args.get(2).contains("CLOEXEC") ? 1 : 2;
        }
        if (ret > -1) {
            fileR = "\"/RPipe\"";
            String fileW = "\"/WPipe\"";
            if (cloExec == 1) {
                this.putFile(this.getPid(s), fdR, fileR, true);
                this.putFile(this.getPid(s), fdW, fileW, true);
            } else {
                this.putFile(this.getPid(s), fdR, fileR, false);
                this.putFile(this.getPid(s), fdW, fileW, false);
            }
        }
        if (name.equals("pipe2")) {
            return this.fixElement(fileR, "/COMMUNICATION/pipe2", cloExec + "");
        }
        return this.fixElement(fileR, "/COMMUNICATION/pipe", "");
    }

    private SysElement getSocket(String s) {
        List<String> args = this.getPars(s);
        String file = "*";
        int ret = Integer.parseInt(args.get(0));
        String domain = args.get(1);
        int domainInt = 0;
        if (domain.endsWith("UNIX")) {
            domainInt = 1;
        }
        if (domain.endsWith("LOCAL")) {
            domainInt = 1;
        }
        if (domain.endsWith("INET")) {
            domainInt = 2;
        }
        if (domain.endsWith("INET6")) {
            domainInt = 3;
        }
        if (domain.endsWith("IPX")) {
            domainInt = 4;
        }
        if (domain.endsWith("NETLINK")) {
            domainInt = 5;
        }
        if (domain.endsWith("X25")) {
            domainInt = 6;
        }
        if (domain.endsWith("AX25")) {
            domainInt = 7;
        }
        if (domain.endsWith("ATMPVC")) {
            domainInt = 8;
        }
        if (domain.endsWith("APPLETALK")) {
            domainInt = 9;
        }
        if (domain.endsWith("PACKET")) {
            domainInt = 10;
        }
        if (domain.endsWith("FILE")) {
            domainInt = 11;
        }
        if (ret > -1) {
            file = "\"/Socket\"";
            if (args.get(2).contains("CLOEXEC")) {
                this.putFile(this.getPid(s), ret, file, true);
            } else {
                this.putFile(this.getPid(s), ret, file, false);
            }
        }
        return this.fixElement(file, "/COMMUNICATION/socket", domainInt + "");
    }

    private SysElement getAccept(String s, String name) {
        List<String> args = this.getPars(s);
        String file = "*";
        int ret = Integer.parseInt(args.get(0));
        int cloExec = 0;
        if (ret > -1) {
            file = "\"/ConnectedSocket\"";
            if (args.size() > 4 && args.get(4).contains("CLOEXEC")) {
                this.putFile(this.getPid(s), ret, file, true);
                cloExec = 1;
            } else {
                this.putFile(this.getPid(s), ret, file, false);
                cloExec = 2;
            }
        }
        if (name.equals("accept")) {
            return this.fixElement(file, "/COMMUNICATION/accept", "");
        }
        return this.fixElement(file, "/COMMUNICATION/accept4", cloExec + "");
    }

    private SysElement getMmap2(String s) {
        List<String> args = this.getPars(s);
        String file = "";
        int fd = Integer.parseInt(args.get(5));
        if (fd > -1) {
            file = this.getFile(this.getPid(s), args.get(5));
        }
        int rwe = 1;
        int share = args.get(4).contains("MAP_PRIVATE") ? 2 : 1;
        int addr = args.get(1).contains("NULL") ? 1 : 2;
        if (args.get(3).contains("PROT_READ")) {
            rwe += 4;
        }
        if (args.get(3).contains("PROT_WRITE")) {
            rwe += 2;
        }
        if (args.get(3).contains("PROT_EXEC")) {
            ++rwe;
        }
        String code = share + "/" + addr + "/" + rwe;
        return this.fixElement(file, "/PROCMEM/mmap2", code);
    }

    private SysElement getMunmap(String s) {
        List<String> args = this.getPars(s);
        int size = Integer.parseInt(args.get(2)) > 4096 ? 2 : 1;
        return this.fixElement("*", "/PROCMEM/munmap", size + "");
    }

    private SysElement getMprotect(String s) {
        List<String> args = this.getPars(s);
        int cat = 2;
        int prot = 0;
        if (args.get(3).contains("PROT_NONE")) {
            cat = 1;
        } else {
            if (args.get(3).contains("PROT_READ")) {
                prot = 1;
            }
            if (args.get(3).contains("PROT_WRITE")) {
                prot = 2;
            }
            if (args.get(3).contains("PROT_EXEC")) {
                prot = 3;
            }
        }
        String code = cat + "/" + prot;
        return this.fixElement("*", "/PROCMEM/mprotect", code);
    }

    private SysElement getFutex(String s) {
        List<String> args = this.getPars(s);
        int op = 0;
        int cat = 0;
        if (args.get(2).contains("FUTEX_WAIT")) {
            cat = 1;
            op = 1;
        }
        if (args.get(2).contains("FUTEX_WAIT_PRIVATE")) {
            cat = 1;
            op = 2;
        }
        if (args.get(2).contains("FUTEX_WAKE")) {
            cat = 2;
            op = 1;
        }
        if (args.get(2).contains("FUTEX_REQUEUE")) {
            cat = 2;
            op = 2;
        }
        if (args.get(2).contains("FUTEX_CMP_REQUEUE")) {
            cat = 2;
            op = 3;
        }
        if (args.get(2).contains("FUTEX_CMP_REQUEUE_PRIVATE")) {
            cat = 2;
            op = 4;
        }
        if (args.get(2).contains("FUTEX_WAKE_PRIVATE")) {
            cat = 2;
            op = 5;
        }
        if (args.get(2).contains("FUTEX_WAKE_OP_PRIVATE")) {
            cat = 2;
            op = 6;
        }
        String code = cat + "/" + op;
        return this.fixElement("*", "/PROCMEM/futex", code);
    }

    private SysElement getExecve(String s) {
        List<String> args = this.getPars(s);
        String file = args.get(1);
        List<String> argList = this.splitArray(args.get(2));
        int argnum = argList.size();
        if (argnum > 1) {
            argnum = 2;
        }
        this.doCloseOnExec(this.getPid(s));
        return this.fixElement(file, "/PROCMEM/execve", argnum + "");
    }

    private SysElement getClone(String s) {
        List<String> args = this.getParsForClone(s);
        String oldPid = this.getPid(s);
        String newPid = args.get(0);
        int intNewPid = Integer.parseInt(newPid);
        int cloneFiles = 0;
        int stackNull = 0;
        int cloneThread = 0;
        if (args.get(2).contains("CLONE_FILES")) {
            if (intNewPid > -1) {
                this.shareProcTable(oldPid, newPid);
            }
            cloneFiles = 1;
        } else {
            if (intNewPid > -1) {
                this.copyProcTable(oldPid, newPid);
            }
            cloneFiles = 2;
        }
        String[] comps = args.get(1).split("=");
        stackNull = comps[1].trim().equals("0") ? 1 : 2;
        cloneThread = args.get(2).contains("CLONE_THREAD") ? 1 : 2;
        String code = cloneFiles + "/" + stackNull + "/" + cloneThread;
        return this.fixElement("*", "/PROCMEM/clone", code + "");
    }

    private SysElement getFork(String s, String name) {
        List<String> args = this.getPars(s);
        String oldPid = this.getPid(s);
        String newPid = args.get(0);
        int intNewPid = Integer.parseInt(newPid);
        if (intNewPid > -1) {
            this.copyProcTable(oldPid, newPid);
        }
        return this.fixElement("*", "/PROCMEM/" + name, "");
    }

    private SysElement getUnshare(String s) {
        List<String> args = this.getPars(s);
        String pid = this.getPid(s);
        int ret = Integer.parseInt(args.get(0));
        int files = 0;
        int fs = 0;
        int newns = 0;
        files = args.get(1).contains("CLONE_FILES") ? 1 : 2;
        fs = args.get(1).contains("CLONE_FS") ? 1 : 2;
        newns = args.get(1).contains("CLONE_NEWNS") ? 1 : 2;
        if (files == 1 && ret > -1) {
            this.copyProcTable(pid, pid);
        }
        String code = files + "/" + fs + "/" + newns;
        return this.fixElement("*", "/PROCMEM/unshare", code);
    }

    private SysElement getNanosleep(String s) {
        List<String> args = this.getPars(s);
        int time = 0;
        List<String> timespec = this.splitSet(args.get(1));
        int secs = Integer.parseInt(timespec.get(0));
        int nano = Integer.parseInt(timespec.get(1));
        time = secs > 0 || nano > 20000000 ? 1 : 2;
        return this.fixElement("*", "/PROCMEM/nanosleep", time + "");
    }

    private SysElement getSimpleWPath(String s, String code) {
        List<String> args = this.getPars(s);
        String file = args.get(1);
        return this.fixElement(file, code, "");
    }

    private SysElement getSimpleWFd(String s, String code) {
        List<String> args = this.getPars(s);
        String file = this.getFile(this.getPid(s), args.get(1));
        return this.fixElement(file, code, "");
    }

    private SysElement getSimple(String code) {
        return this.fixElement("", code, "");
    }

    public List<String> getPars(String line) {
        ArrayList<String> pars = new ArrayList<String>();
        pars.add(this.getReturnValue(line));
        int pos = line.lastIndexOf("=");
        line = line.substring(0, pos + 1);
        int end = line.lastIndexOf(")");
        int start = line.indexOf("(");
        line = line.substring(start, end + 1);
        Matcher m = this.singleP.matcher(line);
        while (m.find()) {
            pars.add(m.group());
        }
        return pars;
    }

    public List<String> getParsForClone(String line) {
        ArrayList<String> pars = new ArrayList<String>();
        pars.add(this.getReturnValue(line));
        int pos = line.lastIndexOf("=");
        line = line.substring(0, pos + 1);
        int end = line.lastIndexOf(")");
        int start = line.indexOf("(");
        line = line.substring(start, end + 1);
        Matcher m = this.cloneP.matcher(line);
        while (m.find()) {
            pars.add(m.group());
        }
        return pars;
    }

    public String getReturnValue(String line) {
        String ret = null;
        Matcher m = this.tailP.matcher(line);
        if (!m.find()) {
            return null;
        }
        if ((m = this.retP.matcher(m.group())).find()) {
            ret = m.group();
            if (ret.equals("?")) {
                ret = "-2";
            }
        } else {
            return null;
        }
        return ret.trim();
    }

    public List<String> splitArray(String line) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = this.extSingleP.matcher(line.substring(1));
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public List<String> splitSet(String line) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = this.extSingleKVP.matcher(line.substring(1));
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public int splitComment(String line) {
        Matcher m = this.extSingleKVP.matcher(line);
        Integer res = null;
        int val = 0;
        if (m.find()) {
            res = Integer.parseInt(m.group());
        }
        if (res != null) {
            val = res;
        }
        return val;
    }

    public String getPid(String s) {
        Matcher m = this.pidP.matcher(s);
        m.find();
        String pidString = m.group();
        return pidString;
    }

    public String getFile(String pid, String fd) {
        String file = null;
        ProcTable pt = this.procTables.get(pid);
        if (pt != null) {
            file = pt.getFile(fd);
        }
        if (file == null) {
            file = "\"/DateiUnbekannt\"";
        }
        return file;
    }

    public void putFile(String pid, int fd, String file, boolean cloExec) {
        ProcTable pt = this.procTables.get(pid);
        if (file == null) {
            file = "\"/DateiUnbekannt\"";
        }
        if (pt == null) {
            pt = new ProcTable(this.myParams);
            this.procTables.put(pid, pt);
        }
        pt.putFile(fd, file, cloExec);
    }

    public String removeFile(String pid, String fd) {
        String file = null;
        ProcTable pt = this.procTables.get(pid);
        if (pt != null) {
            file = pt.getFile(fd);
            pt.removeFile(fd);
        }
        if (file == null) {
            file = "\"/DateiUnbekannt\"";
        }
        return file;
    }

    public void setCloseOnExec(String pid, String fd, boolean cloExec) {
        ProcTable pt = this.procTables.get(pid);
        if (pt != null) {
            pt.setCloseOnExec(fd, cloExec);
        }
    }

    public void copyProcTable(String oldPid, String newPid) {
        ProcTable pt = this.procTables.get(oldPid);
        if (pt == null) {
            this.procTables.put(newPid, null);
        } else {
            this.procTables.put(newPid, pt.clone());
        }
    }

    public void shareProcTable(String oldPid, String newPid) {
        ProcTable pt = this.procTables.get(oldPid);
        this.procTables.put(newPid, pt.shareFd());
    }

    public void doCloseOnExec(String pid) {
        ProcTable pt = this.procTables.get(pid);
        if (pt != null) {
            pt.doCloseOnExec();
        }
    }

    public String mergeResumed(String line) {
        String mergedLine = null;
        String pid = this.getPid(line);
        ProcTable pt = this.procTables.get(pid);
        if (pt != null) {
            mergedLine = pt.mergeParts(line);
        }
        return mergedLine;
    }

    public void storeUnfinished(String line) {
        String pid = this.getPid(line);
        ProcTable pt = this.procTables.get(pid);
        if (pt == null) {
            pt = new ProcTable(this.myParams);
            this.procTables.put(pid, pt);
        }
        pt.setUnfishedPart(line);
    }

    public void updateSequence(String pid, String call) {
        ProcTable pt = this.procTables.get(pid);
        int flat = this.call2flat(call);
        if (flat > 0) {
            if (pt == null) {
                pt = new ProcTable(this.myParams);
                this.procTables.put(pid, pt);
            }
            pt.putCall(flat);
        }
    }

    public String getSequence(String line) {
        String sequence = null;
        String pid = this.getPid(line);
        ProcTable pt = this.procTables.get(pid);
        if (pt != null) {
            sequence = pt.getSequence();
        }
        return sequence;
    }

    public SysElement fixElement(String file, String call, String code) {
        String[] eStr = new String[this.myParams.getDimS()];
        if (this.myParams.pathDim() > -1) {
            if (file == null || file.equals("")) {
                file = "*";
            }
            if (file.length() > 1) {
                file = this.cleanPath(file);
            }
            eStr[this.myParams.pathDim()] = file;
        }
        String[] eInt = new String[this.myParams.getDimI()];
        block5: for (int i = 0; i < this.myParams.getDimI(); ++i) {
            eInt[i] = "";
            switch (this.myParams.dimContents(i + this.myParams.getDimS())) {
                case CALL: {
                    eInt[i] = this.getCode(call) + "/" + code;
                    if (eInt[i] != null) continue block5;
                    throw new RuntimeException("Kann den Code fuer " + eInt[0] + " nicht in der Taxonomie finden.");
                }
                case SEQUENCE: {
                    int[] callSeq = null;
                    ProcTable pt = this.procTables.get(this.currentPid);
                    if (pt != null) {
                        callSeq = pt.getCalls();
                    }
                    if (callSeq == null || callSeq.length == 1) {
                        eInt[i] = "*";
                        continue block5;
                    }
                    for (int k = 1; k < callSeq.length; ++k) {
                        if (callSeq[k] <= 0) continue;
                        int n = i;
                        eInt[n] = eInt[n] + "/" + callSeq[k];
                    }
                    continue block5;
                }
                case RETURN: {
                    if (this.currentReturnValue.equals("-1")) {
                        eInt[i] = "/2";
                        continue block5;
                    }
                    eInt[i] = "/1";
                    continue block5;
                }
                default: {
                    throw new RuntimeException("default");
                }
            }
        }
        int[] res = Element.stringToInt(eInt, this.myParams);
        SysElement sysEl = new SysElement(eStr, res, this.myParams);
        if (sysEl != null) {
            sysEl.capHierarchy(this.myParams.getCap());
        }
        return sysEl;
    }

    public SysElement parseLine(String line) {
        String[] comps = line.split("\\|");
        String[] eStr = new String[this.myParams.getDimS()];
        if (this.myParams.pathDim() > -1) {
            String file = comps[this.myParams.pathDim()].trim();
            if (file == null || file.equals("")) {
                file = "*";
            }
            if (file.length() > 1) {
                file = this.cleanPath(file);
            }
            eStr[this.myParams.pathDim()] = file;
        }
        String[] eInt = new String[this.myParams.getDimI()];
        block5: for (int i = 0; i < this.myParams.getDimI(); ++i) {
            eInt[i] = "";
            switch (this.myParams.dimContents(i + this.myParams.getDimS())) {
                case CALL: {
                    String clean = comps[this.myParams.callDim()].trim();
                    eInt[i] = this.getFullCode(clean);
                    if (eInt[i] != null) continue block5;
                    throw new RuntimeException("Kann den Code fuer " + eInt[0] + " nicht in der Taxonomie finden.");
                }
                case SEQUENCE: {
                    String clean = comps[this.myParams.seqDim()].trim();
                    String[] singleCall = clean.split("/");
                    if (singleCall.length == 1) {
                        eInt[i] = "*";
                        continue block5;
                    }
                    for (int k = 1; k < singleCall.length; ++k) {
                        int n = i;
                        eInt[n] = eInt[n] + "/" + this.myParams.getTaxonomy().call2flat(singleCall[k]);
                    }
                    continue block5;
                }
                case RETURN: {
                    String clean = comps[this.myParams.retDim()].trim();
                    if (clean.equals("/ERROR")) {
                        eInt[i] = "/2";
                    }
                    if (clean.equals("/NO_ERROR")) {
                        eInt[i] = "/1";
                    }
                    if (clean.equals("*")) {
                        eInt[i] = "/0";
                    }
                    if (!eInt[i].equals("")) continue block5;
                    throw new RuntimeException("Kann Rueckgabewert nicht aufloesen: " + clean);
                }
                default: {
                    throw new RuntimeException("default");
                }
            }
        }
        int[] res = Element.stringToInt(eInt, this.myParams);
        SysElement sysEl = new SysElement(eStr, res, this.myParams);
        if (sysEl != null) {
            sysEl.capHierarchy(this.myParams.getCap());
        }
        return sysEl;
    }

    public String getCode(String s) {
        return this.myParams.getTaxonomy().getCode(s);
    }

    public String getFullCode(String s) {
        int[] array = this.myParams.getTaxonomy().pathlabel2code(s);
        String code = "";
        for (int i = 1; i < array.length; ++i) {
            code = code + "/" + array[i];
        }
        return code;
    }

    public int call2flat(String call) {
        return this.myParams.getTaxonomy().call2flat(call);
    }

    public String getCallName(String s) {
        int stop;
        int start = s.indexOf(" ");
        if (start + 1 > (stop = s.indexOf("("))) {
            System.out.println("Fehler in getCallName: Zeile = " + s + ", start = " + start + " stop= " + stop);
        }
        return s.substring(start + 1, stop).trim();
    }

    public boolean isUsed(String call) {
        return this.myParams.usedCalls().contains(call);
    }

    public String cleanPath(String file) {
        int k;
        if (file == null) {
            file = "/DateiUnbekannt";
        }
        if (file.startsWith("\"") && (file = file.substring(1)).endsWith("\"")) {
            file = file.substring(0, file.length() - 1);
        }
        while (file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
        }
        int lev = 0;
        int oldk = k = file.indexOf(47, 0);
        while (k >= 0) {
            if ((k = file.indexOf(47, k + 1)) == oldk + 1) {
                file = k == 1 ? file.substring(k) : file.substring(0, k - 1) + file.substring(k);
                --k;
                continue;
            }
            ++lev;
            oldk = k;
        }
        return file;
    }
}

