/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.DimType;
import hitters.multi.Parameter;
import hitters.multi.Taxonomy;
import hitters.multi.Weights;
import java.util.Arrays;
import java.util.HashSet;

public class SysParameter
extends Parameter {
    DimType[] usedDims;
    int[] cap = null;
    HashSet<String> minCalls;
    HashSet<String> usedCalls;
    final byte[] callPlength = new byte[]{0, 4, 12, 18, 24, 28, 32};
    final byte[] seqPlength = new byte[]{0, 8, 16, 24, 32};
    final byte[] retPlength = new byte[]{0, 2, 32};
    int pathDim = -1;
    int callDim = -1;
    int seqDim = -1;
    int retDim = -1;
    double exp = 0.0;
    private Taxonomy taxonomy;
    private Weights myWeights;

    public SysParameter(DimType[] dims) {
        int i;
        this.usedDims = new DimType[dims.length];
        int counter = 0;
        for (DimType d : dims) {
            if (d != DimType.PATH) continue;
            this.usedDims[counter++] = DimType.PATH;
        }
        for (DimType d : dims) {
            if (d == DimType.PATH) continue;
            this.usedDims[counter++] = d;
        }
        this.dimS = 0;
        this.dimI = 0;
        for (i = 0; i < this.usedDims.length; ++i) {
            if (this.usedDims[i] == DimType.PATH) {
                this.dimS = 1;
                continue;
            }
            if (this.usedDims[i] == DimType.NONE) continue;
            ++this.dimI;
        }
        this.plength = new byte[this.dimI][];
        this.cap = new int[this.usedDims.length];
        block9: for (i = 0; i < this.usedDims.length; ++i) {
            switch (this.usedDims[i]) {
                case PATH: {
                    this.pathDim = i;
                    this.cap[i] = 12;
                    continue block9;
                }
                case CALL: {
                    this.plength[i - this.dimS] = this.callPlength;
                    this.callDim = i;
                    this.cap[i] = this.callPlength.length - 1;
                    continue block9;
                }
                case SEQUENCE: {
                    this.plength[i - this.dimS] = this.seqPlength;
                    this.seqDim = i;
                    this.cap[i] = this.seqPlength.length - 1;
                    continue block9;
                }
                case RETURN: {
                    this.plength[i - this.dimS] = this.retPlength;
                    this.retDim = i;
                    this.cap[i] = this.retPlength.length - 1;
                }
            }
        }
        this.mask = this.calcMasks();
        this.taxonomy = this.loadTaxonomy();
        this.myWeights = this.loadWeights();
        this.minCalls = SysParameter.getMinCalls();
        this.usedCalls = this.loadAllCalls();
        this.usedCalls.addAll(this.minCalls);
    }

    public SysParameter(DimType[] dims, int[] caps) {
        this(dims);
        if (dims.length != caps.length) {
            throw new RuntimeException("Dimensionen von caps und dims bitte passend waehlen.");
        }
        for (int i = 0; i < this.usedDims.length; ++i) {
            for (int j = 0; j < dims.length; ++j) {
                if (this.usedDims[i] != dims[j]) continue;
                if (this.cap[i] >= caps[j]) {
                    this.cap[i] = caps[j];
                    continue;
                }
                throw new RuntimeException("Caps zu gross fuer interne Darstellung.");
            }
        }
    }

    public DimType dimContents(int i) {
        return this.usedDims[i];
    }

    public int pathDim() {
        return this.pathDim;
    }

    public int callDim() {
        return this.callDim;
    }

    public int seqDim() {
        return this.seqDim;
    }

    public int retDim() {
        return this.retDim;
    }

    public boolean capDepth() {
        return this.cap != null;
    }

    public int[] getCap() {
        return this.cap;
    }

    public void setTaxonomy(Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public Weights getWeights() {
        return this.myWeights;
    }

    public boolean useWeights() {
        return this.exp > 1.0E-12;
    }

    public int getSeqLength() {
        return this.seqPlength.length - 1;
    }

    public HashSet<String> usedCalls() {
        return this.usedCalls;
    }

    public void setUsedCalls(HashSet<String> calls) {
        this.usedCalls = calls;
        if (this.pathDim() > -1) {
            boolean redundant = false;
            for (String c : this.minCalls) {
                if (!calls.contains(c)) continue;
                redundant = true;
            }
            if (redundant) {
                System.out.println("Adding calls already in minCalls. Check if this is what you want.");
            }
            this.usedCalls.addAll(this.minCalls);
        }
    }

    @Override
    public int gethi(int dim) {
        return this.cap[dim];
    }

    @Override
    public String toString() {
        String s = super.toString();
        s = s + this.cr + "# Dimensionen = " + Arrays.toString((Object[])this.usedDims);
        if (this.cap != null) {
            s = s + this.cr + "# " + Arrays.toString(this.cap);
        }
        s = s + this.cr + "# L = " + this.getL();
        s = s + this.cr + "# Exp = " + this.exp + this.cr + "#" + this.cr;
        return s;
    }

    @Override
    public String toNiceString() {
        String s = super.toNiceString();
        s = s + this.cr + "Hierarchical variables used: " + Arrays.toString((Object[])this.usedDims) + this.cr;
        s = s + "Depth of hierarchy for each variable: " + Arrays.toString(this.cap);
        return s;
    }

    public String toFullString() {
        String s = this.toString();
        s = s + this.cr + "# Verwendete Calls (" + this.usedCalls.size() + "): ";
        for (String call : this.usedCalls) {
            s = s + this.cr + "# " + call;
        }
        return s;
    }

    private int[][] calcMasks() {
        int[][] mask = new int[this.dimI][];
        for (int d = 0; d < this.dimI; ++d) {
            mask[d] = new int[this.plength[d].length];
            for (int i = 1; i < mask[d].length; ++i) {
                mask[d][i] = -1 << 32 - this.plength[d][i];
            }
        }
        return mask;
    }

    private Taxonomy loadTaxonomy() {
        Taxonomy taxonomy = null;
        try {
            taxonomy = new Taxonomy("Taxonomy3");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return taxonomy;
    }

    private Weights loadWeights() {
        Weights myWeights = null;
        try {
            myWeights = new Weights("Freq.txt", this.exp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myWeights;
    }

    private HashSet<String> loadAllCalls() {
        if (this.taxonomy == null) {
            this.taxonomy = this.loadTaxonomy();
        }
        HashSet<String> allCalls = new HashSet<String>(this.taxonomy.getAllCalls());
        return allCalls;
    }

    public static HashSet<String> getMinCalls() {
        HashSet<String> minCalls = new HashSet<String>();
        minCalls.add("open");
        minCalls.add("close");
        minCalls.add("dup");
        minCalls.add("dup2");
        minCalls.add("dup3");
        minCalls.add("clone");
        minCalls.add("fork");
        minCalls.add("vfork");
        minCalls.add("execve");
        minCalls.add("fcntl");
        minCalls.add("fcntl64");
        minCalls.add("unshare");
        minCalls.add("socket");
        minCalls.add("pipe");
        minCalls.add("pipe2");
        minCalls.add("inotify_init");
        minCalls.add("inotify_init1");
        minCalls.add("accept");
        minCalls.add("accept4");
        return minCalls;
    }

    public String dimString() {
        return "# Dimensionen = " + Arrays.toString((Object[])this.usedDims) + this.cr;
    }
}

