/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.Element;
import hitters.multi.Parameter;
import hitters.multi.SysElement;
import hitters.multi.SysParameter;
import hitters.multi.SysParser;
import hitters.tools.LogService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;

public class StreamReader {
    private static final int SYSCALL = 1;
    private static final int SIMPLE = 2;
    private static final int UNKNOWN = -1;
    private final int dimS;
    private final int dimI;
    private final int dim;
    private int streamType = -1;
    private BufferedReader in;
    private Parameter myParams;
    SysParameter sysPar = null;
    SysParser parser = null;
    private String[] clean;
    private String str = null;

    public StreamReader(Parameter myParams) {
        if (LogService.shouldLog(1)) {
            LogService.log(1, "MultiDataBase: dimI lt. Par " + myParams.getDimI() + " dimS lt Par " + myParams.getDimS());
        }
        boolean problem = false;
        this.myParams = myParams;
        this.dimS = myParams.getDimS();
        this.dimI = myParams.getDimI();
        this.dim = this.dimI + this.dimS;
        this.clean = new String[this.dim];
        this.in = new BufferedReader(new InputStreamReader(System.in));
        while (this.streamType == -1) {
            try {
                this.str = this.in.readLine();
                this.streamType = this.getStreamType(this.str);
                System.out.println("streamtype " + this.printType(this.streamType));
                if (this.str != null) continue;
                Thread.sleep(500L);
            }
            catch (IOException e) {
                System.out.print(e.getMessage());
            }
            catch (InterruptedException e) {
                System.out.print(e.getMessage());
            }
        }
        if (this.streamType == 1 && (this.dimI != 1 || this.dimS != 1)) {
            problem = true;
        }
        if (this.streamType == 2 && this.dimI != 0) {
            problem = true;
        }
        if (problem) {
            throw new RuntimeException("Stromtyp passt nicht zu Parametern:\n StreamType == " + this.printType(this.streamType) + "\n" + myParams);
        }
        if (this.streamType == 1) {
            if (!(myParams instanceof SysParameter)) {
                throw new RuntimeException("System Calls lesen nur mit Parameterobjekt vom Typ SysParameter.");
            }
            this.sysPar = (SysParameter)myParams;
            this.parser = new SysParser(this.sysPar);
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
    }

    public int readLoop(Collection<Element> container, long lines) {
        int readcount = 0;
        int counter = 0;
        String str = "";
        Element elem = null;
        container.clear();
        while (str != null) {
            try {
                ++readcount;
                str = this.in.readLine();
                if (this.streamType == -1) {
                    this.streamType = this.getStreamType(str);
                    System.out.println("streamtype " + this.printType(this.streamType));
                }
                switch (this.streamType) {
                    case 2: {
                        elem = this.readStreamElement(str);
                        break;
                    }
                    case 1: {
                        elem = this.readSysElement(str);
                        break;
                    }
                }
                if (elem == null) continue;
                container.add(elem);
                if ((long)(++counter) < lines) continue;
                return readcount;
            }
            catch (IOException e) {
                System.out.print(e.getMessage());
            }
        }
        return readcount;
    }

    public Element readStreamElement(String line) {
        Element e = null;
        if (line != null && line.length() > 0 && line.startsWith("/")) {
            int i;
            String[] item = line.split("[|]");
            if (this.dim != item.length) {
                throw new RuntimeException("Verschiedene Dim. in Parametern und Strom: Item.length=" + item.length + ", lt Par: " + this.dim);
            }
            for (i = 0; i < item.length; ++i) {
                this.clean[i] = item[i].trim();
            }
            String[] eStr = new String[this.dimS];
            String[] eInt = new String[this.dimI];
            for (i = 0; i < this.dimS; ++i) {
                eStr[i] = this.clean[i];
            }
            for (i = 0; i < this.dimI; ++i) {
                eInt[i] = this.clean[i + this.dimS];
            }
            e = Element.createElement(eStr, eInt, this.myParams);
        }
        return e;
    }

    public Element readSysElement(String line) {
        SysElement e = null;
        if (line != null && line.length() > 0) {
            e = null;
            e = this.parser.createElement(line);
        }
        return e;
    }

    private int getStreamType(String s) {
        if (s == null || s.trim().equals("")) {
            return -1;
        }
        if (s.startsWith("#")) {
            return 2;
        }
        if (s.startsWith("/")) {
            return 2;
        }
        if (s.startsWith("|")) {
            return 2;
        }
        if (s.startsWith("*")) {
            return 2;
        }
        if (s.contains("=")) {
            return 1;
        }
        return -1;
    }

    private String printType(int streamType) {
        String s;
        switch (streamType) {
            case 1: {
                s = "SYSCALL";
                break;
            }
            case 2: {
                s = "SIMPLE";
                break;
            }
            case -1: {
                s = "UNKNOWN";
                break;
            }
            default: {
                s = "Undefined";
            }
        }
        return s;
    }
}

