/*
 * Decompiled with CFR 0.152.
 */
package hitters.multi;

import hitters.multi.Element;
import hitters.multi.MultiHitterInfo;
import hitters.multi.Parameter;
import hitters.tools.LogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractHHH {
    Parameter par;
    int N = 0;
    int tupelCount = 0;
    int maxTupel = 0;

    public AbstractHHH(Parameter myParams) {
        this.par = myParams;
        if (LogService.shouldLog(1)) {
            LogService.log(1, "AbstractHHH: DimI = " + myParams.getDimI() + " Dims = " + myParams.getDimS() + " Dim = " + myParams.getDim() + " und myParams.getL() +1 " + (myParams.getL() + 1));
        }
    }

    Set<Element> trimHitters(Set<Element> fullHitters, int[] label) {
        boolean blocked = false;
        HashSet<Element> temp = new HashSet<Element>();
        HashSet<Element> trim = new HashSet<Element>();
        for (Element h : fullHitters) {
            if (!h.isBelowLabel(label)) continue;
            temp.add(h);
        }
        for (Element h : temp) {
            blocked = false;
            for (Element other : temp) {
                if (!other.isGenOf(h) || other.equals(h)) continue;
                blocked = true;
            }
            if (blocked) continue;
            trim.add(h);
        }
        return trim;
    }

    public List<int[]> calcLabels(int level) {
        int dim = this.par.getDim();
        int[] label = new int[dim];
        ArrayList<int[]> list = new ArrayList<int[]>();
        switch (dim) {
            case 1: {
                label = new int[dim];
                label[0] = level;
                list.add(label);
                break;
            }
            case 2: {
                int imin2;
                int i = imin2 = Math.max(0, level - this.par.gethi(1));
                while (i <= Math.min(this.par.gethi(0), level)) {
                    label = new int[dim];
                    label[0] = i++;
                    label[1] = level - label[0];
                    list.add(label);
                }
                break;
            }
            case 3: {
                int imin3;
                for (int i = imin3 = Math.max(0, level - this.par.gethi(1) - this.par.gethi(2)); i <= Math.min(this.par.gethi(0), level); ++i) {
                    int iminj3;
                    for (int j = iminj3 = Math.max(0, level - i - this.par.gethi(2)); j <= Math.min(this.par.gethi(1), level - i); ++j) {
                        label = new int[dim];
                        label[0] = i;
                        label[1] = j;
                        label[2] = level - i - j;
                        list.add(label);
                    }
                }
                break;
            }
            case 4: {
                int imini;
                for (int i = imini = Math.max(0, level - this.par.gethi(1) - this.par.gethi(2) - this.par.gethi(3)); i <= Math.min(this.par.gethi(0), level); ++i) {
                    int iminj;
                    for (int j = iminj = Math.max(0, level - i - this.par.gethi(2) - this.par.gethi(3)); j <= Math.min(this.par.gethi(1), level - i); ++j) {
                        int imink;
                        for (int k = imink = Math.max(0, level - i - j - this.par.gethi(3)); k <= Math.min(this.par.gethi(2), level - i - j); ++k) {
                            label = new int[dim];
                            label[0] = i;
                            label[1] = j;
                            label[2] = k;
                            label[3] = level - i - j - k;
                            list.add(label);
                        }
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Dimension nicht implementiert.");
            }
        }
        return list;
    }

    public void insert(Element e, int count) {
        this.insert(e, count, true);
    }

    public abstract void insert(Element var1, int var2, boolean var3);

    public abstract HashMap<Element, MultiHitterInfo> outputSet(double var1);

    public abstract HashMap<Element, MultiHitterInfo> outputSet(double var1, boolean var3);

    public abstract HashMap<Element, Integer> dumpf();

    public abstract HashMap<Element, Integer> dumpF(double var1);

    public abstract int instantiateDelta(Element var1);

    public int getN() {
        return this.N;
    }

    public int getTupelCount() {
        return this.tupelCount;
    }

    public int getMaxTupelCount() {
        return Math.max(this.maxTupel, this.tupelCount);
    }

    public Parameter getParameter() {
        return this.par;
    }
}

