/*
 * Decompiled with CFR 0.152.
 */
package hitters;

import hitters.multi.Element;
import hitters.multi.Evaluation;
import hitters.multi.Exact;
import hitters.multi.MultiHitterInfo;
import hitters.multi.Parameter;
import hitters.multi.PartAncHHH;
import java.util.HashMap;
import java.util.Set;

public class Beispiel {
    public static void main(String[] args) {
        String[][] stream = new String[][]{{"/a", "/1"}, {"/b", "/1"}, {"/a", "/2"}, {"/b", "/2"}, {"/a", "/1"}, {"/a", "/1"}, {"/a", "/1"}, {"/b", "/1"}, {"/b", "/2"}, {"/a", "/1"}, {"/a", "/1"}, {"/a", "/2"}, {"/a", "/2"}};
        Parameter par = new Parameter(2);
        double epsilon = 0.1;
        double phi = 0.35;
        PartAncHHH myPA = new PartAncHHH(epsilon, par);
        Exact myExact = new Exact(par);
        System.out.println("\n\nEingabe: 13 Items, Epsilon = 0.1, Phi = 0.35\n");
        for (String[] s : stream) {
            Element e = Element.createElement(s, par);
            System.out.println(e.toShortString());
            myExact.insert(e, 1);
            myPA.insert(e.clone(), 1);
        }
        HashMap<Element, MultiHitterInfo> approx = myPA.outputSet(phi);
        HashMap<Element, MultiHitterInfo> exact = myExact.outputSet(phi);
        Set<Element> approxSet = approx.keySet();
        Set<Element> exactSet = exact.keySet();
        double precision = Evaluation.precision(approxSet, exactSet);
        double recall = Evaluation.recall(approxSet, exactSet);
        double dice = Evaluation.dice(approxSet, exactSet);
        System.out.println("\nExakte Loesung:");
        for (Element elem : exactSet) {
            System.out.println(elem.toShortString());
        }
        System.out.println("\nApproximationsloesung:");
        for (Element elem : approxSet) {
            System.out.print(elem.toShortString());
            System.out.println("\t\t" + approx.get(elem));
        }
        System.out.println("\n\nPrecision = " + precision);
        System.out.println("Recall = " + recall);
        System.out.println("Dice = " + dice);
    }
}

