/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.hhhitter.HHHExtraction;
import com.rapidminer.operator.preprocessing.hhhitter.HHHResult;
import com.rapidminer.operator.preprocessing.hhhitter.ParameterWrapper;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import hitters.multi.AbstractComplexHHH;
import hitters.multi.AlgoType;
import hitters.multi.DimType;
import hitters.multi.Element;
import hitters.multi.FullAncHHH;
import hitters.multi.MultiDatabase;
import hitters.multi.MultiHitterInfo;
import hitters.multi.PartAncHHH;
import hitters.multi.SysParameter;
import hitters.tools.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HHHExtractionSpinczyk
extends HHHExtraction {
    public static final String DATA_PATH = "data_path";
    public static final String FIRST_FILE = "first_file";
    public static final String LAST_FILE = "last_file";
    static Pattern callP = Pattern.compile("syscall:\\s[a-z_0-9]+(?=,\\s)");
    static Pattern gidP = Pattern.compile("(?<=,\\s)gid:\\s[0-9]{1,5}(?=$)");
    static Pattern uidP = Pattern.compile("(?<=,\\s)uid:\\s[0-9]{1,5}(?=,\\s)");
    static Pattern fileP = Pattern.compile("(?<=,\\s)file:\\s[^,\\n]+(?=,)");

    public HHHExtractionSpinczyk(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        LogService logService = LogService.getGlobal();
        logService.setVerbosityLevel(2);
        logService.log("Start apply   ", 2);
        ExampleSet exampleSet = (ExampleSet)this.getInput(ExampleSet.class);
        ExampleSet clone = (ExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        this.sizeExSet = exampleSet.size();
        this.cacheHits = 0;
        this.setSize = "\"";
        this.avgSetSize = 0.0;
        this.dsSize = 0.0;
        ParameterWrapper pw = this.getParameterWrapper();
        boolean writeDs = this.getParameterAsBoolean("write_data_struct");
        String cachePrefix = this.getParameterAsString("cache_path");
        Attribute structID = this.createHitterAttribute(clone);
        Attribute dsID = this.createDSAttribute(clone, writeDs);
        ArrayList<Set<Element>> allHHH = new ArrayList<Set<Element>>();
        ArrayList<String> names = new ArrayList<String>();
        int firstFile = this.getParameterAsInt(FIRST_FILE);
        int lastFile = this.getParameterAsInt(LAST_FILE);
        String oldline = "";
        HashMap<String, String> parsed = new HashMap<String, String>();
        HashMap<Integer, AbstractComplexHHH> algos = null;
        HashMap<Integer, Set<Element>> hitterSets = null;
        if (this.getParameterAsBoolean("use_cache") && !writeDs) {
            logService.log("Searching for cache.", 2);
            hitterSets = this.readCache(clone, cachePrefix, pw, firstFile, lastFile);
            if (hitterSets == null) {
                logService.log("Cache not found.", 5);
            }
        }
        if (hitterSets == null) {
            algos = new HashMap<Integer, AbstractComplexHHH>();
            this.fillAlgoMap(algos, clone, pw);
            for (int i = this.getParameterAsInt(FIRST_FILE); i <= this.getParameterAsInt(LAST_FILE); ++i) {
                this.checkForStop();
                String f = "" + i;
                while (f.length() < 7) {
                    f = "0" + f;
                }
                String file = this.getParameterAsString(DATA_PATH) + "/file" + f + ".log";
                try {
                    Element e;
                    String[] s;
                    AbstractComplexHHH al;
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    boolean first = true;
                    while ((line = in.readLine()) != null) {
                        if ((line = line.trim()).length() <= 2 || line.startsWith("#")) continue;
                        if (line.startsWith("syscall: ")) {
                            if (first) {
                                first = false;
                                oldline = oldline + line.replaceAll("\n", "").trim();
                                continue;
                            }
                            if (this.parseLine(oldline, parsed, file) && (al = algos.get(Integer.parseInt(parsed.get("uid")))) != null && parsed.get("call").equals("close") && (s = new String[]{Utils.cleanPath2(parsed.get("file"))})[0] != null) {
                                e = Element.createElement(s, pw.par);
                                if (e != null) {
                                    e.capHierarchy(pw.par.getCap());
                                }
                                al.insert(e, 1);
                            }
                            oldline = "";
                        }
                        oldline = oldline + line.replaceAll("\n", "").trim();
                    }
                    if (first || !this.parseLine(oldline, parsed, file) || (al = algos.get(Integer.parseInt(parsed.get("uid")))) == null || !parsed.get("call").equals("close") || (s = new String[]{Utils.cleanPath2(parsed.get("file"))})[0] == null) continue;
                    e = Element.createElement(s, pw.par);
                    if (e != null) {
                        e.capHierarchy(pw.par.getCap());
                    }
                    al.insert(e, 1);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.writeCacheMarcoEilig(algos, cachePrefix, pw, firstFile, lastFile);
            if (this.getParameterAsBoolean("use_cache")) {
                this.writeCache(algos, cachePrefix, pw, firstFile, lastFile);
            }
            hitterSets = this.calcHitterSets(clone, algos, pw);
        }
        for (Example example : clone) {
            this.checkForStop();
            Attribute uidAttr = clone.getAttributes().get("uid");
            int uid = (int)example.getNumericalValue(uidAttr);
            Set<Element> hhh = hitterSets.get(uid);
            this.setSize = this.setSize + hhh.size() + "; ";
            this.avgSetSize += (double)hhh.size();
            allHHH.add(hhh);
            names.add(uid + "");
            double val = ((ObjectAttribute)structID).getMapping().mapString(hhh);
            example.setValue(structID, val);
            if (!writeDs) continue;
            AbstractComplexHHH hitterAlgo = algos.get(uid);
            HashMap<Element, Integer> ds = hitterAlgo.dumpf();
            this.dsSize += (double)ds.size();
            val = ((ObjectAttribute)dsID).getMapping().mapString(ds);
            example.setValue(dsID, val);
        }
        this.avgSetSize /= (double)clone.size();
        this.dsSize /= (double)clone.size();
        this.setSize = this.setSize + "\"";
        HHHResult result = new HHHResult(pw, allHHH, names);
        if (this.getParameterAsBoolean("result")) {
            return new IOObject[]{clone, result};
        }
        return new IOObject[]{clone};
    }

    private HashMap<Integer, Set<Element>> readCache(ExampleSet clone, String cachePrefix, ParameterWrapper pw, int firstFile, int lastFile) {
        HashMap<Integer, Set<Element>> hitterSets = new HashMap<Integer, Set<Element>>();
        String cacheDir = this.createCacheName(cachePrefix, pw, firstFile, lastFile);
        for (Example example : clone) {
            Attribute uidAttr = clone.getAttributes().get("uid");
            int uid = (int)example.getNumericalValue(uidAttr);
            String cacheName = cacheDir + "/" + uid;
            System.out.println("Trying " + cacheName);
            File cacheFile = new File(cacheName + ".hhh");
            if (!cacheFile.exists()) {
                return null;
            }
            System.out.println("Read " + cacheName);
            Set<Element> hhh = MultiDatabase.readHHH(cacheName);
            hitterSets.put(uid, hhh);
        }
        return hitterSets;
    }

    private HashMap<Integer, Set<Element>> calcHitterSets(ExampleSet clone, HashMap<Integer, AbstractComplexHHH> algos, ParameterWrapper pw) {
        HashMap<Integer, Set<Element>> hitterSets = new HashMap<Integer, Set<Element>>();
        for (Example example : clone) {
            Attribute uidAttr = clone.getAttributes().get("uid");
            int uid = (int)example.getNumericalValue(uidAttr);
            Set<Element> hhh = algos.get(uid).outputSet(pw.phi).keySet();
            hitterSets.put(uid, hhh);
        }
        return hitterSets;
    }

    private void writeCache(HashMap<Integer, AbstractComplexHHH> algos, String cachePrefix, ParameterWrapper pw, int firstFile, int lastFile) {
        String cacheDir = this.createCacheName(cachePrefix, pw, firstFile, lastFile);
        for (Integer i : algos.keySet()) {
            AbstractComplexHHH hitterAlgo = algos.get(i);
            Set<Element> hhh = hitterAlgo.outputSet(pw.phi).keySet();
            try {
                MultiDatabase.saveHHH(hhh, cacheDir + "/" + i, null, pw.par, pw.epsilon, pw.phi, pw.algo);
            }
            catch (Exception e) {
                LogService.getGlobal().log("Can't write cache: " + cacheDir + i + " " + e, 5);
            }
        }
    }

    private void writeCacheMarcoEilig(HashMap<Integer, AbstractComplexHHH> algos, String cachePrefix, ParameterWrapper pw, int firstFile, int lastFile) {
        BufferedWriter out = null;
        BufferedWriter out2 = null;
        String cr = System.getProperty("line.sparator");
        cr = Tools.getLineSeparator();
        try {
            out = new BufferedWriter(new FileWriter("J:/outEilig"));
            out2 = new BufferedWriter(new FileWriter("J:/outEiligShort"));
            out.write(pw.par.dimString() + cr);
            for (Integer i : algos.keySet()) {
                AbstractComplexHHH hitterAlgo = algos.get(i);
                HashMap<Element, MultiHitterInfo> hhhMap = hitterAlgo.outputSet(pw.phi);
                for (Element el : hhhMap.keySet()) {
                    out.write(i + "\t" + hhhMap.get((Object)el).fmin + "\t" + hhhMap.get((Object)el).fmax + "\t" + hhhMap.get((Object)el).F + "\t" + el.toShortString() + cr);
                    int f = (int)(0.5 * (double)(hhhMap.get((Object)el).fmin + hhhMap.get((Object)el).fmax));
                    out2.write(i + "\t" + Math.min(f, hhhMap.get((Object)el).F) + "\t" + el.toShortString() + "\t" + Utils.cleanPath(el.toShortString()) + cr);
                }
            }
            out.write(cr);
        }
        catch (FileNotFoundException e) {
            System.out.print(e.getMessage());
        }
        catch (IOException e) {
            System.out.print(e.getMessage());
        }
        try {
            out.close();
            out2.close();
        }
        catch (IOException e) {
            System.out.println("CloseWrite: Error: " + e.getMessage());
        }
    }

    private String createCacheName(String cachePrefix, ParameterWrapper pw, int firstFile, int lastFile) {
        String cacheDir = cachePrefix + "/Spinc" + (Object)((Object)pw.algo) + "/eps" + Utils.format(pw.epsilon) + "#phi" + Utils.format(pw.phi);
        SysParameter sysPar = pw.par;
        for (int i = 0; i < pw.par.getDim(); ++i) {
            cacheDir = cacheDir + "#" + (Object)((Object)sysPar.dimContents(i)) + "#" + sysPar.getCap()[i];
        }
        File tmpDir = new File(cacheDir = cacheDir + "#" + firstFile + "#" + lastFile);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return cacheDir;
    }

    private void fillAlgoMap(HashMap<Integer, AbstractComplexHHH> algos, ExampleSet clone, ParameterWrapper pw) {
        Attribute uidAttr = clone.getAttributes().get("uid");
        for (Example example : clone) {
            AbstractComplexHHH hitterAlgo = pw.algo == AlgoType.PART_ANC ? new PartAncHHH(pw.epsilon, pw.par) : new FullAncHHH(pw.epsilon, pw.par);
            int uid = (int)example.getNumericalValue(uidAttr);
            algos.put(uid, hitterAlgo);
        }
    }

    @Override
    protected DimType[] retrieveDims() throws UserError {
        DimType[] dims = new DimType[]{DimType.PATH};
        return dims;
    }

    @Override
    protected int[] retrieveCaps() throws UndefinedParameterError {
        int[] cap = new int[]{12};
        return cap;
    }

    private boolean parseLine(String oldline, HashMap<String, String> parsed, String itFile) {
        parsed.clear();
        String call = null;
        String uid = null;
        String gid = null;
        String file = null;
        Matcher m = callP.matcher(oldline);
        if (m.find()) {
            call = m.group().split(":")[1].trim();
        }
        if ((m = gidP.matcher(oldline)).find()) {
            gid = m.group().split(":")[1].trim();
        }
        if ((m = uidP.matcher(oldline)).find()) {
            uid = m.group().split(":")[1].trim();
        }
        if ((m = fileP.matcher(oldline)).find()) {
            file = m.group().split(":")[1].trim();
            file = this.cleanPath(file);
        }
        parsed.put("call", call);
        parsed.put("uid", uid);
        parsed.put("file", file);
        if (uid == null || gid == null || call == null) {
            System.out.println("NO WAY: " + itFile + "  " + oldline);
            return false;
        }
        return true;
    }

    private String cleanPath(String file) {
        int k;
        while (file.endsWith("/")) {
            file = file.substring(0, file.length() - 1);
        }
        int lev = 0;
        int oldk = k = file.indexOf(47, 0);
        while (k >= 0) {
            if ((k = file.indexOf(47, k + 1)) == oldk + 1) {
                file = k == 1 ? file.substring(k) : file.substring(0, k - 1) + file.substring(k);
                --k;
                continue;
            }
            ++lev;
            oldk = k;
        }
        return file;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDirectory type = new ParameterTypeDirectory(DATA_PATH, "Path to the directory containing the logfiles.", "J:/unzipped");
        types.add((ParameterType)type);
        type = new ParameterTypeInt(FIRST_FILE, "Number of the first logfile to use.", 0, 437, 0);
        types.add((ParameterType)type);
        type = new ParameterTypeInt(LAST_FILE, "Number of the last logfile to use.", 0, 437, 0);
        types.add((ParameterType)type);
        return types;
    }
}

