/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeObjectFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.preprocessing.hhhitter.BGM2Similarity;
import com.rapidminer.operator.preprocessing.hhhitter.BGMSimilarity;
import com.rapidminer.operator.preprocessing.hhhitter.CormodeSimilarity;
import com.rapidminer.operator.preprocessing.hhhitter.DataStructSimilarity;
import com.rapidminer.operator.preprocessing.hhhitter.OGMSimilarity;
import com.rapidminer.operator.preprocessing.hhhitter.ParameterWrapper;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import hitters.multi.AlgoType;
import hitters.multi.DimType;
import hitters.multi.SysParameter;
import java.util.List;

public abstract class HHHExtraction
extends Operator {
    protected InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("training set");
    protected OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    protected OutputPort resultOutput = (OutputPort)this.getOutputPorts().createPort("result");
    protected OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("exampleSet");
    public static final String ALGORITHM = "algorithm";
    public static final String EPSILON = "epsilon";
    public static final String PHI = "phi";
    public static final String CACHE_PATH = "cache_path";
    public static final String RESULT = "result";
    public static final String USE_CACHE = "use_cache";
    public static final String DATASTRUCT = "write_data_struct";
    int cacheHits = 0;
    int sizeExSet = 0;
    String setSize = "";
    double avgSetSize = 0.0;
    double dsSize = 0.0;

    public HHHExtraction(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueString("SetSize", "The size of the set of Hierarchical Heavy Hitters for each example."){

            public String getStringValue() {
                return HHHExtraction.this.setSize;
            }
        });
        this.addValue((Value)new ValueDouble("AvgSetSize", "The average size of the set of Hierarchical Heavy Hitters."){

            public double getDoubleValue() {
                return new Double(HHHExtraction.this.avgSetSize);
            }
        });
        this.addValue((Value)new ValueDouble("CacheHits", "Cache hits / number of examples."){

            public double getDoubleValue() {
                return new Double((double)HHHExtraction.this.cacheHits / (1.0 * (double)HHHExtraction.this.sizeExSet));
            }
        });
        this.addValue((Value)new ValueDouble("DataStructSize", "Size of data structure obtained when calculating the HHH."){

            public double getDoubleValue() {
                return new Double(HHHExtraction.this.dsSize);
            }
        });
    }

    protected Attribute createHitterAttribute(ExampleSet clone) {
        Attribute structID = clone.getAttributes().get("structID");
        if (structID == null) {
            LogService.getGlobal().log("Create struct attribute.", 4);
            structID = AttributeObjectFactory.createAttribute("structID", 12);
            clone.getExampleTable().addAttribute(structID);
            clone.getAttributes().addRegular(structID);
        }
        return structID;
    }

    protected ParameterWrapper getParameterWrapper() throws UserError {
        ParameterWrapper pw = new ParameterWrapper();
        DimType[] dims = this.retrieveDims();
        int[] cap = this.retrieveCaps();
        pw.par = new SysParameter(dims, cap);
        pw.epsilon = this.getParameterAsDouble(EPSILON);
        pw.phi = this.getParameterAsDouble(PHI);
        if (pw.phi < pw.epsilon) {
            LogService.getGlobal().log("Phi < epsilon, setting phi = epsilon", 5);
            pw.phi = pw.epsilon;
        }
        pw.algo = this.getParameterAsInt(ALGORITHM) == 0 ? AlgoType.PART_ANC : AlgoType.FULL_ANC;
        return pw;
    }

    protected Attribute createDSAttribute(ExampleSet clone, boolean writeDs) {
        Attribute dsID = clone.getAttributes().get("dataStructID");
        if (dsID == null && writeDs) {
            LogService.getGlobal().log("Create ds attribute.", 4);
            dsID = AttributeObjectFactory.createAttribute("dataStructID", 12);
            clone.getExampleTable().addAttribute(dsID);
            clone.getAttributes().addRegular(dsID);
        }
        return dsID;
    }

    protected abstract DimType[] retrieveDims() throws UserError;

    protected abstract int[] retrieveCaps() throws UndefinedParameterError;

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        String[] algo = new String[]{"Partial Ancestry", "Full Ancestry"};
        ParameterTypeCategory type = new ParameterTypeCategory(ALGORITHM, "The algorithm used to calculate the HHH.", algo, 1);
        types.add(type);
        type = new ParameterTypeDouble(EPSILON, "The number epsilon used to calculate the HHH.", 1.0E-12, 0.5, 5.0E-4);
        types.add(type);
        type = new ParameterTypeDouble(PHI, "The number phi used to calculate the HHH.", 1.0E-12, 0.5, 0.002);
        types.add(type);
        type = new ParameterTypeDirectory(CACHE_PATH, "Path to the directory for the files containing the cached HHHs.", "D:/cache");
        types.add(type);
        type = new ParameterTypeBoolean(RESULT, "Operator should return the Hierarchical Heavy Hitters as a ResultObject.", true);
        types.add(type);
        type = new ParameterTypeBoolean(USE_CACHE, "Cache the HHH for each logfile and parameter set for later use. Uses only a moderate amount of disk space.", true);
        types.add(type);
        type = new ParameterTypeBoolean(DATASTRUCT, "Write the data structure obtained when calculating the HHH to the example set.", false);
        types.add(type);
        return types;
    }

    public boolean shouldAutoConnect(OutputPort outputPort) {
        if (outputPort == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(outputPort);
    }

    static {
        System.out.println("");
        System.out.println("Registering DistanceMeasures ***************************");
        System.out.println("");
        DistanceMeasures.registerMeasure((int)1, (String)"OGM Similarity", OGMSimilarity.class);
        DistanceMeasures.registerMeasure((int)1, (String)"Cormode Similarity", CormodeSimilarity.class);
        DistanceMeasures.registerMeasure((int)1, (String)"BGM Similarity", BGMSimilarity.class);
        DistanceMeasures.registerMeasure((int)1, (String)"BGM2 Similarity", BGM2Similarity.class);
        DistanceMeasures.registerMeasure((int)1, (String)"Data Structure Similarity", DataStructSimilarity.class);
    }
}

