/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.hhhitter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ObjectAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;
import hitters.multi.Evaluation;
import java.util.Map;

public class DataStructSimilarity
extends SimilarityMeasure {
    private static final long serialVersionUID = 5231354969672836148L;
    public static final String DS_ATTRIBUTE = "dataStructID";
    ObjectAttribute<?> dsmAttribute;
    int index = -1;

    public double calculateDistance(double[] value1, double[] value2) {
        return 1.0 - this.calculateSimilarity(value1, value2);
    }

    public double calculateSimilarity(double[] value1, double[] value2) {
        if (this.dsmAttribute == null) {
            throw new RuntimeException("No dsmAttribute was stored during init");
        }
        int index1 = new Double(value1[this.index]).intValue();
        int index2 = new Double(value2[this.index]).intValue();
        Map ds1 = (Map)this.dsmAttribute.getMapping().mapObjectIndex(index1);
        Map ds2 = (Map)this.dsmAttribute.getMapping().mapObjectIndex(index2);
        if (ds1.size() == 0 || ds2.size() == 0) {
            return 0.0;
        }
        double sim = Evaluation.dsm(ds1, ds2);
        return sim;
    }

    public void init(ExampleSet exampleSet) throws OperatorException {
        int i = 0;
        Attributes attributes = exampleSet.getAttributes();
        for (Attribute a : attributes) {
            if (a.getName().equals(DS_ATTRIBUTE)) {
                this.dsmAttribute = (ObjectAttribute)a;
                this.index = i;
            }
            ++i;
        }
        if (this.dsmAttribute == null) {
            throw new UserError(null, 128, new Object[]{"ID (containing the data structure obtained when calculating the Hierarchical Heavy Hitters). The distance measure you have chosen is not applicable for other datasets"});
        }
    }
}

