/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationEvaluator;
import com.rapidminer.operator.performance.PerformanceVector;
import hitters.multi.Weights;

public class CoarsePopulationEvaluator
implements PopulationEvaluator {
    private ExampleSet originalSet;
    private IOContainer input;
    private FeatureOperator operator;
    private Weights myWeights = null;
    private double threshold;

    public CoarsePopulationEvaluator(FeatureOperator operator, IOContainer input, ExampleSet originalSet) {
        this.originalSet = originalSet;
        this.input = input;
        this.operator = operator;
        try {
            this.myWeights = new Weights("Freq.txt", 0.0);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't find my weights!");
        }
    }

    public CoarsePopulationEvaluator(FeatureOperator operator, IOContainer input, ExampleSet originalSet, double threshold) {
        this(operator, input, originalSet);
        this.threshold = threshold;
    }

    private void evaluate(Individual individual) throws OperatorException {
        if (individual.getPerformance() == null) {
            double[] weights = individual.getWeights();
            ExampleSet clone = FeatureOperator.createCleanClone((ExampleSet)this.originalSet, (double[])weights);
            IOObject[] operatorChainInput = new IOObject[]{clone};
            IOContainer innerResult = this.input.prepend(operatorChainInput);
            for (int i = 0; i < this.operator.getNumberOfOperators(); ++i) {
                innerResult = this.operator.getOperator(i).apply(innerResult);
            }
            PerformanceVector performanceVector = (PerformanceVector)innerResult.remove(PerformanceVector.class);
            individual.setPerformance(performanceVector);
        }
    }

    private double getSum(Individual ind) {
        double sum = 0.0;
        double[] weights = ind.getWeights();
        int i = 0;
        for (Attribute a : this.originalSet.getAttributes()) {
            int n = i++;
            if (!(weights[n] > 1.0E-12)) continue;
            sum += this.myWeights.getFreq(a.getName());
        }
        return sum;
    }

    public void evaluate(Population population) throws OperatorException {
        Individual parent = population.getCurrentBest();
        double sumP = parent == null ? Double.MIN_NORMAL : this.getSum(parent);
        PerformanceVector parentPerformance = null;
        if (parent != null) {
            parentPerformance = parent.getPerformance();
        }
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            double sum = this.getSum(population.get(i));
            if (sum > this.threshold / 1000.0 && (sum - sumP) / sum >= this.threshold || parentPerformance == null) {
                this.evaluate(population.get(i));
                continue;
            }
            population.get(i).setPerformance(parentPerformance);
        }
    }
}

