/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.operator.preprocessing.hhhitter.HHHResult;
import hitters.multi.Element;
import hitters.multi.SysParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class HHHTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8269975310895824917L;
    HHHResult result;
    List<Set<Element>> hitters;
    List<String> names;
    SysParameter par;
    List<String[]> table;

    public HHHTableModel(HHHResult result) {
        this.result = result;
        this.hitters = result.getAllHitters();
        this.names = result.getNames();
        this.par = result.getParameters().par;
        this.table = this.makeTable();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        return this.par.dimContents(column - 1).toString();
    }

    @Override
    public int getColumnCount() {
        int columnCount;
        block1: {
            if (this.hitters.size() == 0 || this.hitters.get(0).size() == 0) {
                return 0;
            }
            columnCount = -1;
            Iterator<Element> i$ = this.hitters.get(0).iterator();
            if (!i$.hasNext()) break block1;
            Element e = i$.next();
            columnCount = e.getDim() + 1;
        }
        return columnCount;
    }

    @Override
    public int getRowCount() {
        return this.table.size();
    }

    @Override
    public Object getValueAt(int arg0, int arg1) {
        return this.table.get(arg0)[arg1];
    }

    private List<String[]> makeTable() {
        ArrayList<String[]> table = new ArrayList<String[]>();
        int columnCount = this.getColumnCount();
        for (int i = 0; i < this.hitters.size(); ++i) {
            String[] row;
            if (i > 0) {
                row = new String[columnCount];
                for (int k = 0; k < row.length; ++k) {
                    row[k] = " ";
                }
                table.add(row);
            }
            for (Element e : this.hitters.get(i)) {
                String[] comps = e.toShortString().split("\\|");
                row = new String[columnCount];
                System.arraycopy(comps, 0, row, 1, comps.length);
                row[0] = this.names.get(i);
                table.add(row);
            }
        }
        return table;
    }
}

