/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table.struct.tree;

import com.rapidminer.example.table.struct.tree.KTreeNode;
import com.rapidminer.example.table.struct.tree.NodeList;
import java.util.ArrayList;

public abstract class AbstractKTreeNode
implements KTreeNode {
    protected String label = "";
    protected KTreeNode parent = null;
    ArrayList<KTreeNode> children = new ArrayList();
    protected int depth = 0;
    protected int depthBelow = -1;

    public AbstractKTreeNode() {
    }

    public AbstractKTreeNode(KTreeNode parentNode) {
        this();
        this.parent = parentNode;
        this.depth = this.parent.getDepth() + 1;
    }

    @Override
    public KTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(KTreeNode newParent) {
        this.parent = newParent;
        this.depth = this.parent.getDepth() + 1;
    }

    public NodeList getProductionList(int cs) {
        return null;
    }

    @Override
    public int getDepth() {
        if (this.depth >= 0) {
            return this.depth;
        }
        this.depth = this.parent != null ? this.parent.getDepth() + 1 : 0;
        return this.depth;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void addChild(KTreeNode child) {
        child.setParent(this);
        this.children.add(child);
        this.depthBelow = Math.max(this.depthBelow, child.getDepthBelow());
    }

    @Override
    public ArrayList<KTreeNode> children() {
        return this.children;
    }

    @Override
    public KTreeNode getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public boolean isLeaf() {
        return this.children().isEmpty();
    }

    @Override
    public int getDepthBelow() {
        if (this.children.size() == 0) {
            return 0;
        }
        if (this.depthBelow <= 0) {
            this.depthBelow = this.computeDepthBelow();
        }
        return this.depthBelow;
    }

    protected int computeDepthBelow() {
        int below = 0;
        for (KTreeNode ch : this.children()) {
            below = Math.max(below, ch.getDepthBelow());
        }
        if (this.children().size() > 0) {
            return 1 + below;
        }
        return below;
    }

    @Override
    public abstract void setKernelValue(Double var1);

    @Override
    public abstract Double getKernelValue();

    @Override
    public abstract String toString2();

    @Override
    public String printTree() {
        StringBuffer s = new StringBuffer();
        s.append(this.getLabel());
        s.append(" ");
        if (!this.isLeaf()) {
            s.append("[ ");
            for (KTreeNode ch : this.children()) {
                s.append(ch.printTree());
            }
            s.append(" ]");
        }
        return s.toString();
    }

    public abstract String getProduction();
}

