/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectMapping
implements NominalMapping {
    private static final long serialVersionUID = 5021638750496191771L;
    private Map<Object, Integer> symbolToIndexMap = new HashMap<Object, Integer>();
    private List<Object> indexToSymbolMap = new ArrayList<Object>();

    public ObjectMapping() {
    }

    ObjectMapping(ObjectMapping mapping) {
        this.symbolToIndexMap.clear();
        this.indexToSymbolMap.clear();
        int i = 0;
        while (i < mapping.size()) {
            int index = i++;
            Object value = mapping.mapObjectIndex(index);
            this.symbolToIndexMap.put(value, index);
            this.indexToSymbolMap.add(value);
        }
    }

    public Object clone() {
        return new ObjectMapping(this);
    }

    public int mapString(Object obj) {
        if (obj == null) {
            return -1;
        }
        int index = this.getIndex(obj);
        if (index < 0) {
            this.indexToSymbolMap.add(obj);
            index = this.indexToSymbolMap.size() - 1;
            this.symbolToIndexMap.put(obj, index);
        }
        return index;
    }

    public int getIndex(Object obj) {
        Integer index = this.symbolToIndexMap.get(obj);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public String mapIndex(int index) {
        if (index < 0 || index >= this.indexToSymbolMap.size()) {
            throw new AttributeTypeException("Cannot map index of nominal attribute to nominal value: index " + index + " is out of bounds!");
        }
        return this.indexToSymbolMap.get(index).toString();
    }

    public Object mapObjectIndex(int index) {
        if (index < 0 || index >= this.indexToSymbolMap.size()) {
            if (index == -1) {
                return null;
            }
            throw new AttributeTypeException("Cannot map index of nominal attribute to nominal value: index " + index + " is out of bounds!");
        }
        return this.indexToSymbolMap.get(index);
    }

    public void setMapping(Object nominalValue, int index) {
        Object oldValue = this.indexToSymbolMap.get(index);
        this.indexToSymbolMap.set(index, nominalValue);
        this.symbolToIndexMap.remove(oldValue);
        this.symbolToIndexMap.put(nominalValue, index);
    }

    public int getNegativeIndex() {
        this.ensureClassification();
        if (this.mapIndex(0) == null) {
            throw new AttributeTypeException("Attribute: Cannot use FIRST_CLASS_INDEX for negative class!");
        }
        return 0;
    }

    public int getPositiveIndex() {
        this.ensureClassification();
        if (this.mapIndex(0) == null) {
            throw new AttributeTypeException("Attribute: Cannot use FIRST_CLASS_INDEX for negative class!");
        }
        for (int index : this.symbolToIndexMap.values()) {
            if (index == 0) continue;
            return index;
        }
        throw new AttributeTypeException("Attribute: No other class than FIRST_CLASS_INDEX found!");
    }

    public String getNegativeString() {
        return this.mapIndex(this.getNegativeIndex()).toString();
    }

    public String getPositiveString() {
        return this.mapIndex(this.getPositiveIndex()).toString();
    }

    public List<String> getValues() {
        ArrayList<String> out = new ArrayList<String>();
        for (Object o : this.indexToSymbolMap) {
            out.add(o.toString());
        }
        return out;
    }

    public int size() {
        return this.indexToSymbolMap.size();
    }

    public void clear() {
        this.symbolToIndexMap.clear();
        this.indexToSymbolMap.clear();
    }

    private void ensureClassification() {
        if (this.size() != 2) {
            throw new AttributeTypeException("Attribute " + this.toString() + " is not a classification attribute!");
        }
    }

    public String toString() {
        return this.indexToSymbolMap.toString() + Tools.getLineSeparator() + this.symbolToIndexMap.toString();
    }

    public int getIndex(String nominalValue) {
        return 0;
    }

    public int mapString(String nominalValue) {
        throw new RuntimeException("Do not try to map strings in an object mapping.");
    }

    public void setMapping(String nominalValue, int index) {
    }

    public void sortMappings() {
    }

    public boolean equals(NominalMapping mapping) {
        return false;
    }
}

