/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.lang.reflect.Method;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetHashCodeTester<E>
extends AbstractSetTester<E> {
    public void testHashCode() {
        int expectedHashCode = 0;
        for (Object element : this.getSampleElements()) {
            expectedHashCode += element == null ? 0 : element.hashCode();
        }
        SetHashCodeTester.assertEquals("A Set's hashCode() should be the sum of those of its elements.", expectedHashCode, ((Object)this.getSet()).hashCode());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testHashCode_containingNull() {
        Collection elements = this.getSampleElements(this.getNumElements() - 1);
        int expectedHashCode = 0;
        for (Object element : elements) {
            expectedHashCode += element == null ? 0 : element.hashCode();
        }
        elements.add(null);
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(elements.toArray());
        SetHashCodeTester.assertEquals("A Set's hashCode() should be the sum of those of its elements (with a null element counting as having a hash of zero).", expectedHashCode, ((Object)this.getSet()).hashCode());
    }

    public static Method[] getHashCodeMethods() {
        try {
            return new Method[]{SetHashCodeTester.class.getMethod("testHashCode", new Class[0]), SetHashCodeTester.class.getMethod("testHashCode_containingNull", new Class[0])};
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

