/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListToArrayTester<E>
extends AbstractListTester<E> {
    public void testToArray_noArg() {
        Object[] actual = this.getList().toArray();
        ListToArrayTester.assertArrayEquals("toArray() order should match list", this.createSamplesArray(), actual);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testToArray_tooSmall() {
        Object[] actual = this.getList().toArray(new Object[0]);
        ListToArrayTester.assertArrayEquals("toArray(tooSmall) order should match list", this.createSamplesArray(), actual);
    }

    public void testToArray_largeEnough() {
        Object[] actual = this.getList().toArray(new Object[this.getNumElements()]);
        ListToArrayTester.assertArrayEquals("toArray(largeEnough) order should match list", this.createSamplesArray(), actual);
    }

    private static void assertArrayEquals(String message, Object[] expected, Object[] actual) {
        ListToArrayTester.assertEquals(message, Arrays.asList(expected), Arrays.asList(actual));
    }
}

