/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.lang.reflect.Method;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionCreationTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNull_supported() {
        Object[] array = this.createArrayWithNullElement();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        this.expectContents(array);
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCreateWithNull_unsupported() {
        Object[] array = this.createArrayWithNullElement();
        try {
            ((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
            CollectionCreationTester.fail("Creating a collection containing null should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static Method getCreateWithNullUnsupportedMethod() {
        try {
            return CollectionCreationTester.class.getMethod("testCreateWithNull_unsupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

