/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAddTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAdd_supportedNotPresent() {
        CollectionAddTester.assertTrue("add(notPresent) should return true", this.collection.add(this.samples.e3));
        this.expectAdded(this.samples.e3);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAdd_unsupportedNotPresent() {
        try {
            this.collection.add(this.samples.e3);
            CollectionAddTester.fail("add(notPresent) should throw");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectMissing(this.samples.e3);
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAdd_unsupportedPresent() {
        try {
            CollectionAddTester.assertFalse("add(present) should return false or throw", this.collection.add(this.samples.e0));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAdd_nullSupported() {
        CollectionAddTester.assertTrue("add(null) should return true", this.collection.add(null));
        this.expectAdded(new Object[]{null});
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD}, absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testAdd_nullUnsupported() {
        try {
            this.collection.add(null);
            CollectionAddTester.fail("add(null) should throw");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
        this.expectNullMissingWhenNullUnsupported("Should not contain null after unsupported add(null)");
    }

    public static Method getAddNullSupportedMethod() {
        try {
            return CollectionAddTester.class.getMethod("testAdd_nullSupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getAddNullUnsupportedMethod() {
        try {
            return CollectionAddTester.class.getMethod("testAdd_nullUnsupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

