/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListIndexOfTester<E>
extends AbstractListTester<E> {
    protected abstract int find(Object var1);

    protected abstract String getMethodName();

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testFind_yes() {
        AbstractListIndexOfTester.assertEquals(this.getMethodName() + "(firstElement) should return 0", 0, this.find(this.samples.e0));
    }

    public void testFind_no() {
        AbstractListIndexOfTester.assertEquals(this.getMethodName() + "(notPresent) should return -1", -1, this.find(this.samples.e3));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testFind_nullNotContainedButSupported() {
        AbstractListIndexOfTester.assertEquals(this.getMethodName() + "(nullNotPresent) should return -1", -1, this.find(null));
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testFind_nullNotContainedAndUnsupported() {
        try {
            AbstractListIndexOfTester.assertEquals(this.getMethodName() + "(nullNotPresent) should return -1 or throw", -1, this.find(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testFind_nonNullWhenNullContained() {
        this.initCollectionWithNullElement();
        AbstractListIndexOfTester.assertEquals(this.getMethodName() + "(notPresent) should return -1", -1, this.find(this.samples.e3));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testFind_nullContained() {
        this.initCollectionWithNullElement();
        AbstractListIndexOfTester.assertEquals(this.getMethodName() + "(null) should return " + this.getNullLocation(), this.getNullLocation(), this.find(null));
    }

    public void testFind_wrongType() {
        try {
            AbstractListIndexOfTester.assertEquals(this.getMethodName() + "(wrongType) should return -1 or throw", -1, this.find((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

