/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.UnhashableObject;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleElements<E> {
    public final E e0;
    public final E e1;
    public final E e2;
    public final E e3;
    public final E e4;

    public SampleElements(E e0, E e1, E e2, E e3, E e4) {
        this.e0 = e0;
        this.e1 = e1;
        this.e2 = e2;
        this.e3 = e3;
        this.e4 = e4;
    }

    public static <K, V> SampleElements<Map.Entry<K, V>> mapEntries(SampleElements<K> keys, SampleElements<V> values) {
        return new SampleElements<Map.Entry<K, V>>(Helpers.mapEntry(keys.e0, values.e0), Helpers.mapEntry(keys.e1, values.e1), Helpers.mapEntry(keys.e2, values.e2), Helpers.mapEntry(keys.e3, values.e3), Helpers.mapEntry(keys.e4, values.e4));
    }

    private static class Collider {
        final int value;

        Collider(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj instanceof Collider && ((Collider)obj).value == this.value;
        }

        public int hashCode() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Colliders
    extends SampleElements<Object> {
        public Colliders() {
            super(new Collider(1), new Collider(2), new Collider(3), new Collider(4), new Collider(5));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Unhashables
    extends SampleElements<UnhashableObject> {
        public Unhashables() {
            super(new UnhashableObject(1), new UnhashableObject(2), new UnhashableObject(3), new UnhashableObject(4), new UnhashableObject(5));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Enums
    extends SampleElements<AnEnum> {
        public Enums() {
            super(AnEnum.B, AnEnum.A, AnEnum.C, AnEnum.D, AnEnum.E);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Strings
    extends SampleElements<String> {
        public static final String BEFORE_FIRST = "\u0000";
        public static final String MIN_ELEMENT = "a";
        public static final String AFTER_LAST = "z";

        public Strings() {
            super("b", MIN_ELEMENT, "c", "d", "e");
        }
    }
}

