/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.features.CollectionFeature;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionIteratorTester<E>
extends AbstractCollectionTester<E> {
    public void testIterator() {
        ArrayList iteratorElements = new ArrayList();
        for (Object element : this.collection) {
            iteratorElements.add(element);
        }
        Helpers.assertEqualIgnoringOrder(Arrays.asList(this.createSamplesArray()), iteratorElements);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testIterationOrdering() {
        ArrayList iteratorElements = new ArrayList();
        for (Object element : this.collection) {
            iteratorElements.add(element);
        }
        List expected = Helpers.copyToList(this.getOrderedElements());
        CollectionIteratorTester.assertEquals((String)"Different ordered iteration", expected, iteratorElements);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_REMOVE})
    public void testIterator_knownOrderRemoveSupported() throws Exception {
        this.runIteratorTest(IteratorFeature.MODIFIABLE, AbstractIteratorTester.KnownOrder.KNOWN_ORDER);
    }

    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER}, absent={CollectionFeature.SUPPORTS_REMOVE})
    public void testIterator_knownOrderRemoveUnsupported() throws Exception {
        this.runIteratorTest(IteratorFeature.UNMODIFIABLE, AbstractIteratorTester.KnownOrder.KNOWN_ORDER);
    }

    @CollectionFeature.Require(absent={CollectionFeature.KNOWN_ORDER}, value={CollectionFeature.SUPPORTS_REMOVE})
    public void testIterator_unknownOrderRemoveSupported() throws Exception {
        this.runIteratorTest(IteratorFeature.MODIFIABLE, AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER);
    }

    @CollectionFeature.Require(absent={CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_REMOVE})
    public void testIterator_unknownOrderRemoveUnsupported() throws Exception {
        this.runIteratorTest(IteratorFeature.UNMODIFIABLE, AbstractIteratorTester.KnownOrder.UNKNOWN_ORDER);
    }

    private void runIteratorTest(Set<IteratorFeature> features, AbstractIteratorTester.KnownOrder knownOrder) throws Exception {
        new IteratorTester<E>(5, features, this.getOrderedElements(), knownOrder){
            {
                this.ignoreSunJavaBug6529795();
            }

            @Override
            protected Iterator<E> newTargetIterator() {
                CollectionIteratorTester.this.resetCollection();
                return CollectionIteratorTester.this.collection.iterator();
            }

            @Override
            protected void verify(List<E> elements) {
                CollectionIteratorTester.this.expectContents(elements);
            }
        }.test();
    }

    public static Method getIteratorKnownOrderRemoveSupportedMethod() {
        try {
            return CollectionIteratorTester.class.getMethod("testIterator_knownOrderRemoveSupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getIteratorUnknownOrderRemoveSupportedMethod() {
        try {
            return CollectionIteratorTester.class.getMethod("testIterator_unknownOrderRemoveSupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void testIteratorNoSuchElementException() {
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
        try {
            iterator.next();
            CollectionIteratorTester.fail((String)"iterator.next() should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static Method getIteratorKnownOrderRemoveUnsupportedMethod() {
        try {
            return CollectionIteratorTester.class.getMethod("testIterator_knownOrderRemoveUnsupported", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

