/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.FeatureUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerCollectionSizeTestSuiteBuilder<B extends PerCollectionSizeTestSuiteBuilder<B, G, T, E>, G extends TestContainerGenerator<T, E>, T, E>
extends FeatureSpecificTestSuiteBuilder<B, G> {
    private static final Logger logger = Logger.getLogger(PerCollectionSizeTestSuiteBuilder.class.getName());

    @Override
    public TestSuite createTestSuite() {
        this.checkCanCreate();
        String name = this.getName();
        Set<Feature<Feature<?>>> features = Helpers.copyToSet(this.getFeatures());
        List<Class<? extends AbstractTester>> testers = this.getTesters();
        logger.fine(" Testing: " + name);
        Set<Feature<Feature<Feature<?>>>> sizesToTest = Helpers.copyToSet(CollectionSize.values());
        sizesToTest.retainAll(features);
        features.removeAll(sizesToTest);
        FeatureUtil.addImpliedFeatures(sizesToTest);
        sizesToTest.retainAll(Arrays.asList(CollectionSize.ZERO, CollectionSize.ONE, CollectionSize.SEVERAL));
        logger.fine("   Sizes: " + PerCollectionSizeTestSuiteBuilder.formatFeatureSet(sizesToTest));
        if (sizesToTest.isEmpty()) {
            throw new IllegalStateException(name + ": no CollectionSizes specified (check the argument to " + "FeatureSpecificTestSuiteBuilder.withFeatures().)");
        }
        TestSuite suite = new TestSuite(name);
        for (Feature<?> feature : sizesToTest) {
            String oneSizeName = String.format("%s [collection size: %s]", name, feature.toString().toLowerCase());
            OneSizeGenerator oneSizeGenerator = new OneSizeGenerator((TestContainerGenerator)this.getSubjectGenerator(), (CollectionSize)feature);
            Set<Feature<?>> oneSizeFeatures = Helpers.copyToSet(features);
            oneSizeFeatures.add(feature);
            Set<Method> oneSizeSuppressedTests = this.getSuppressedTests();
            OneSizeTestSuiteBuilder oneSizeBuilder = (OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)((OneSizeTestSuiteBuilder)new OneSizeTestSuiteBuilder(testers).named(oneSizeName)).usingGenerator(oneSizeGenerator)).withFeatures(oneSizeFeatures)).suppressing(oneSizeSuppressedTests);
            TestSuite oneSizeSuite = oneSizeBuilder.createTestSuite();
            suite.addTest((Test)oneSizeSuite);
            for (TestSuite derivedSuite : this.createDerivedSuites(oneSizeBuilder)) {
                oneSizeSuite.addTest((Test)derivedSuite);
            }
        }
        return suite;
    }

    List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<T, E>> parentBuilder) {
        return new ArrayList<TestSuite>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneSizeGenerator<T, E>
    implements OneSizeTestContainerGenerator<T, E> {
        private final TestContainerGenerator<T, E> generator;
        private final CollectionSize collectionSize;

        public OneSizeGenerator(TestContainerGenerator<T, E> generator, CollectionSize collectionSize) {
            this.generator = generator;
            this.collectionSize = collectionSize;
        }

        @Override
        public TestContainerGenerator<T, E> getInnerGenerator() {
            return this.generator;
        }

        @Override
        public SampleElements<E> samples() {
            return this.generator.samples();
        }

        @Override
        public T create(Object ... elements) {
            return this.generator.create(elements);
        }

        @Override
        public E[] createArray(int length) {
            return this.generator.createArray(length);
        }

        @Override
        public T createTestSubject() {
            Collection<E> elements = this.getSampleElements(this.getCollectionSize().getNumElements());
            return this.generator.create(elements.toArray());
        }

        @Override
        public Collection<E> getSampleElements(int howMany) {
            SampleElements<E> samples = this.samples();
            List<Object> allSampleElements = Arrays.asList(samples.e0, samples.e1, samples.e2, samples.e3, samples.e4);
            return new ArrayList<Object>(allSampleElements.subList(0, howMany));
        }

        @Override
        public CollectionSize getCollectionSize() {
            return this.collectionSize;
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.generator.order(insertionOrder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OneSizeTestSuiteBuilder<T, E>
    extends FeatureSpecificTestSuiteBuilder<OneSizeTestSuiteBuilder<T, E>, OneSizeGenerator<T, E>> {
        private final List<Class<? extends AbstractTester>> testers;

        public OneSizeTestSuiteBuilder(List<Class<? extends AbstractTester>> testers) {
            this.testers = testers;
        }

        @Override
        protected List<Class<? extends AbstractTester>> getTesters() {
            return this.testers;
        }
    }
}

