/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.PerCollectionSizeTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.features.SetFeature;
import com.google.common.collect.testing.testers.MapClearTester;
import com.google.common.collect.testing.testers.MapContainsKeyTester;
import com.google.common.collect.testing.testers.MapContainsValueTester;
import com.google.common.collect.testing.testers.MapCreationTester;
import com.google.common.collect.testing.testers.MapEqualsTester;
import com.google.common.collect.testing.testers.MapGetTester;
import com.google.common.collect.testing.testers.MapHashCodeTester;
import com.google.common.collect.testing.testers.MapIsEmptyTester;
import com.google.common.collect.testing.testers.MapPutAllTester;
import com.google.common.collect.testing.testers.MapPutTester;
import com.google.common.collect.testing.testers.MapRemoveTester;
import com.google.common.collect.testing.testers.MapSizeTester;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTestSuiteBuilder<K, V>
extends PerCollectionSizeTestSuiteBuilder<MapTestSuiteBuilder<K, V>, TestMapGenerator<K, V>, Map<K, V>, Map.Entry<K, V>> {
    public static <K, V> MapTestSuiteBuilder<K, V> using(TestMapGenerator<K, V> generator) {
        return (MapTestSuiteBuilder)new MapTestSuiteBuilder<K, V>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        return Arrays.asList(MapClearTester.class, MapContainsKeyTester.class, MapContainsValueTester.class, MapCreationTester.class, MapEqualsTester.class, MapGetTester.class, MapHashCodeTester.class, MapIsEmptyTester.class, MapPutTester.class, MapPutAllTester.class, MapRemoveTester.class, MapSizeTester.class);
    }

    @Override
    List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new MapEntrySetGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeEntrySetFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " entrySet")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new MapKeySetGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(MapTestSuiteBuilder.computeKeySetFeatures(parentBuilder.getFeatures()))).named(parentBuilder.getName() + " keys")).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        derivedSuites.add(((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using(new MapValueCollectionGenerator<K, V>(parentBuilder.getSubjectGenerator())).named(parentBuilder.getName() + " values")).withFeatures(MapTestSuiteBuilder.computeValuesCollectionFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        return derivedSuites;
    }

    private static Set<Feature<?>> computeEntrySetFeatures(Set<Feature<?>> mapFeatures) {
        return MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
    }

    private static Set<Feature<?>> computeKeySetFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> keySetFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_KEYS)) {
            keySetFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        return keySetFeatures;
    }

    private static Set<Feature<?>> computeValuesCollectionFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> valuesCollectionFeatures = MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_VALUES)) {
            valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        return valuesCollectionFeatures;
    }

    private static Set<Feature<?>> computeCommonDerivedCollectionFeatures(Set<Feature<?>> mapFeatures) {
        HashSet derivedFeatures = new HashSet();
        if (mapFeatures.contains(MapFeature.SUPPORTS_REMOVE)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE);
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE_ALL);
            derivedFeatures.add(CollectionFeature.SUPPORTS_RETAIN_ALL);
        }
        if (mapFeatures.contains(MapFeature.SUPPORTS_CLEAR)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_CLEAR);
        }
        if (mapFeatures.contains(MapFeature.REJECTS_DUPLICATES_AT_CREATION)) {
            derivedFeatures.add(SetFeature.REJECTS_DUPLICATES_AT_CREATION);
        }
        for (CollectionSize size : CollectionSize.values()) {
            if (!mapFeatures.contains(size)) continue;
            derivedFeatures.add(size);
        }
        return derivedFeatures;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapValueCollectionGenerator<K, V>
    implements TestCollectionGenerator<V> {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<V> samples;

        public MapValueCollectionGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0).getValue(), ((Map.Entry)mapSamples.e1).getValue(), ((Map.Entry)mapSamples.e2).getValue(), ((Map.Entry)mapSamples.e3).getValue(), ((Map.Entry)mapSamples.e4).getValue());
        }

        @Override
        public SampleElements<V> samples() {
            return this.samples;
        }

        @Override
        public Collection<V> create(Object ... elements) {
            Object[] valuesArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<K, Object>> entries = new ArrayList<Map.Entry<K, Object>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(entry.getKey(), valuesArray[i++]));
            }
            return ((Map)this.mapGenerator.create(entries.toArray())).values();
        }

        @Override
        public V[] createArray(int length) {
            V[] vs = ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createValueArray(length);
            return vs;
        }

        @Override
        public Iterable<V> order(List<V> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapKeySetGenerator<K, V>
    implements TestSetGenerator<K> {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;
        private final SampleElements<K> samples;

        public MapKeySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
            SampleElements mapSamples = this.mapGenerator.samples();
            this.samples = new SampleElements(((Map.Entry)mapSamples.e0).getKey(), ((Map.Entry)mapSamples.e1).getKey(), ((Map.Entry)mapSamples.e2).getKey(), ((Map.Entry)mapSamples.e3).getKey(), ((Map.Entry)mapSamples.e4).getKey());
        }

        @Override
        public SampleElements<K> samples() {
            return this.samples;
        }

        @Override
        public Set<K> create(Object ... elements) {
            Object[] keysArray = elements;
            Collection<Map.Entry<K, V>> originalEntries = this.mapGenerator.getSampleElements(elements.length);
            ArrayList<Map.Entry<Object, V>> entries = new ArrayList<Map.Entry<Object, V>>(elements.length);
            int i = 0;
            for (Map.Entry<K, V> entry : originalEntries) {
                entries.add(Helpers.mapEntry(keysArray[i++], entry.getValue()));
            }
            return ((Map)this.mapGenerator.create(entries.toArray())).keySet();
        }

        @Override
        public K[] createArray(int length) {
            K[] ks = ((TestMapGenerator)this.mapGenerator.getInnerGenerator()).createKeyArray(length);
            return ks;
        }

        @Override
        public Iterable<K> order(List<K> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapEntrySetGenerator<K, V>
    implements TestSetGenerator<Map.Entry<K, V>> {
        private final OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator;

        public MapEntrySetGenerator(OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>> mapGenerator) {
            this.mapGenerator = mapGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.mapGenerator.samples();
        }

        @Override
        public Set<Map.Entry<K, V>> create(Object ... elements) {
            return ((Map)this.mapGenerator.create(elements)).entrySet();
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.mapGenerator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.mapGenerator.order(insertionOrder);
        }
    }
}

