/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.ConflictingRequirementsException;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.FeatureUtil;
import com.google.common.collect.testing.features.TesterRequirements;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureSpecificTestSuiteBuilder<B extends FeatureSpecificTestSuiteBuilder<B, G>, G> {
    private G subjectGenerator;
    private Set<Feature<?>> features;
    private String name;
    private Set<Method> suppressedTests = new HashSet<Method>();
    private static final Logger logger = Logger.getLogger(FeatureSpecificTestSuiteBuilder.class.getName());

    protected B self() {
        return (B)this;
    }

    protected B usingGenerator(G subjectGenerator) {
        this.subjectGenerator = subjectGenerator;
        return this.self();
    }

    protected G getSubjectGenerator() {
        return this.subjectGenerator;
    }

    public B withFeatures(Feature<?> ... features) {
        return this.withFeatures(Arrays.asList(features));
    }

    public B withFeatures(Iterable<? extends Feature<?>> features) {
        this.features = Helpers.copyToSet(features);
        return this.self();
    }

    protected Set<Feature<?>> getFeatures() {
        return Collections.unmodifiableSet(this.features);
    }

    public B named(String name) {
        if (name.contains("(")) {
            throw new IllegalArgumentException("Eclipse hides all characters after '('; please use '[]' or other characters instead of parentheses");
        }
        this.name = name;
        return this.self();
    }

    protected String getName() {
        return this.name;
    }

    public B suppressing(Method ... methods) {
        return this.suppressing(Arrays.asList(methods));
    }

    public B suppressing(Collection<Method> methods) {
        this.suppressedTests.addAll(methods);
        return this.self();
    }

    protected Set<Method> getSuppressedTests() {
        return this.suppressedTests;
    }

    public TestSuite createTestSuite() {
        this.checkCanCreate();
        logger.fine(" Testing: " + this.name);
        logger.fine("Features: " + FeatureSpecificTestSuiteBuilder.formatFeatureSet(this.features));
        FeatureUtil.addImpliedFeatures(this.features);
        logger.fine("Expanded: " + FeatureSpecificTestSuiteBuilder.formatFeatureSet(this.features));
        List<Class<AbstractTester>> testers = this.getTesters();
        TestSuite suite = new TestSuite(this.name);
        for (Class<AbstractTester> testerClass : testers) {
            TestSuite testerSuite = this.makeSuiteForTesterClass(testerClass);
            if (testerSuite.countTestCases() <= 0) continue;
            suite.addTest((Test)testerSuite);
        }
        return suite;
    }

    protected void checkCanCreate() {
        if (this.subjectGenerator == null) {
            throw new IllegalStateException("Call using() before createTestSuite().");
        }
        if (this.name == null) {
            throw new IllegalStateException("Call named() before createTestSuite().");
        }
        if (this.features == null) {
            throw new IllegalStateException("Call withFeatures() before createTestSuite().");
        }
    }

    protected abstract List<Class<? extends AbstractTester>> getTesters();

    private boolean matches(Test test) {
        TesterRequirements requirements;
        Method method;
        try {
            method = FeatureSpecificTestSuiteBuilder.extractMethod(test);
        }
        catch (IllegalArgumentException e) {
            logger.finer(String.format("%s: including by default: %s", test, e.getMessage()));
            return true;
        }
        if (this.suppressedTests.contains(method)) {
            logger.finer(String.format("%s: excluding because it was explicitly suppressed.", test));
            return false;
        }
        try {
            requirements = FeatureUtil.getTesterRequirements(method);
        }
        catch (ConflictingRequirementsException e) {
            throw new RuntimeException(e);
        }
        Set<Feature<Feature<?>>> missingFeatures = Helpers.copyToSet(requirements.getPresentFeatures());
        missingFeatures.removeAll(this.features);
        if (!missingFeatures.isEmpty()) {
            logger.finer(String.format("%s: skipping because these features are absent: %s", method, missingFeatures));
            return false;
        }
        Set<Feature<Feature<?>>> unwantedFeatures = Helpers.copyToSet(requirements.getAbsentFeatures());
        unwantedFeatures.retainAll(this.features);
        if (!unwantedFeatures.isEmpty()) {
            logger.finer(String.format("%s: skipping because these features are present: %s", method, unwantedFeatures));
            return false;
        }
        return true;
    }

    private static Method extractMethod(Test test) {
        if (test instanceof AbstractTester) {
            AbstractTester tester = (AbstractTester)test;
            try {
                return tester.getTestMethod();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (test instanceof TestCase) {
            TestCase testCase = (TestCase)test;
            try {
                return testCase.getClass().getMethod(testCase.getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("unable to extract method from test: not a TestCase.");
    }

    protected TestSuite makeSuiteForTesterClass(Class<? extends AbstractTester<?>> testerClass) {
        TestSuite candidateTests = new TestSuite(testerClass);
        TestSuite suite = this.filterSuite(candidateTests);
        Enumeration allTests = suite.tests();
        while (allTests.hasMoreElements()) {
            Object test = allTests.nextElement();
            if (!(test instanceof AbstractTester)) continue;
            AbstractTester tester = (AbstractTester)((Object)test);
            tester.init(this.subjectGenerator, this.name);
        }
        return suite;
    }

    private TestSuite filterSuite(TestSuite suite) {
        TestSuite filtered = new TestSuite(suite.getName());
        Enumeration tests = suite.tests();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (!this.matches(test)) continue;
            filtered.addTest(test);
        }
        return filtered;
    }

    protected static String formatFeatureSet(Set<? extends Feature<?>> features) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Feature<?> feature : features) {
            if (feature instanceof Enum) {
                Enum f = (Enum)((Object)feature);
                temp.add(f.getDeclaringClass().getSimpleName() + "." + feature);
                continue;
            }
            temp.add(feature.toString());
        }
        return ((Object)temp).toString();
    }
}

