package Bachelorpackage;

/*
 * Copyright 2017 Andreas Sitta
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Comparator;

/**
 * Wort-Objekt. Hier werden Worte eines Textes nur noch mit ID und vorkommender Hufigkeit abgespeichert.
 * @author Andreas Sitta
 * @version 1.0
 *
 */
public class Word implements Comparable<Word> {
	public int id;
	public int freq;
	
	public Word(int id, int freq){
		this.id=id;
		this.freq=freq;
	}
	
	
	@Override
	public int compareTo(Word word) {
		return Integer.compare(this.id, word.id);
	}
}

class IDComparator implements Comparator<Word> {
		@Override
		public int compare(Word w1, Word w2) {
		    return Integer.compare(w1.id,w2.id);
		  }
}

class FreqComparator implements Comparator<Word> {
	@Override
	public int compare(Word w1, Word w2) {
	    return Integer.compare(w1.freq,w2.freq);
	  }
}
	

class StringWord implements Comparable<StringWord> {
	public String name;
	public int freq;
	
	public StringWord(String name, int freq){
		this.name=name;
		this.freq=freq;
	}
	
	@Override
	public int compareTo(StringWord word) {
		return this.name.compareTo(word.name);
	}
}

class StringFreqComparator implements Comparator<StringWord> {
	@Override
	public int compare(StringWord w1, StringWord w2) {
	    return Integer.compare(w1.freq,w2.freq);
	  }
}
	
	
	

